#ifndef __GAME_H
#define __GAME_H


#define M_PI            (3.14159f)
#define COLLIDE_GAP     (0.2f)
#define PLAYER_MOVE     (0.13f)
#define PLAYER_ROT      (0.1f)
#define TIME_TOTAL      (30)

typedef struct 
{
    float x;
    float y;
    float dir;
} Player;

typedef struct
{
    char    tile[10][10];
    char    w;
    char    h;
    float   startX;
    float   startY;
    float   startDir;
} Map;

typedef struct
{   
    Player   player;
    Map      *map;
    int      mapId;
    int      timeLeft;
    int      exit;        // exit requested
} Game;


void gameInit();
int  gameLocate(int x, int y);
void gameControl();
void gameTick();

#endif // __GAME_H
