#include "game.h"
#include "disp.h"
#include <stdio.h>
#include <malloc.h>
#include <user_lock.h>

///////////////////////
// Global variables
///////////////////////

unsigned char*           buf[2];             // one image per buffer
void *                   sts[2];             // for fbf_cma
unsigned int             cur_buf;            // current buffer
volatile unsigned int    slice_x;            // slice index (shared)
volatile unsigned int    slice_count;        // slice count (shared)
sqt_lock_t               slice_get_lock;     // slice index lock
sqt_lock_t               slice_done_lock;    // slice index lock
pthread_t                trdid[1024];        // thread identifiers array
Game                     game;               // Game state

// Textures
unsigned char*  g_tex[] =
{
    NULL, // 0
    NULL, // rock
    NULL, // door
    NULL, // handle
    NULL, // wood
};

//////////////////////////
// Exported functions
//////////////////////////

//////////////////////////////////////////
__attribute__((constructor)) void render()
{
    unsigned int slice;

    while ( game.exit == 0 ) 
    {
        dispRenderSlice( &slice );
    }
    giet_pthread_exit( NULL );
}

////////////////////////////////////////
__attribute__((constructor)) void main()
{
    unsigned int w, h, p;   // platform parameters
 
    unsigned int i, j, n;   // indexes for loops

    giet_tty_alloc(0);

    giet_tty_printf("\n[RAYCAST] enters main at cycle %d\n", 
                    giet_proctime() );

    // get and check platform parameters
    giet_procs_number(&w, &h, &p);

    giet_pthread_assert( (w<=16) , "[RAYCAST ERROR] check hardware config" );
    giet_pthread_assert( (h<=16) , "[RAYCAST ERROR] check hardware config" );
    giet_pthread_assert( (p<= 4) , "[RAYCAST ERROR] check hardware config" );

    // compute total number of threads
    unsigned int nthreads = w * h * p;

    // Initialize heap for each cluster
    for (i = 0; i < w; i++)
        for (j = 0; j < h; j++)
            heap_init(i, j);

    // Initialize lock protecting slice allocator 
    sqt_lock_init( &slice_get_lock,  w , h , p );
    sqt_lock_init( &slice_done_lock, w , h , p );

    // Allocate buffers
    buf[0] = malloc(FBUF_X_SIZE * FBUF_Y_SIZE);
    buf[1] = malloc(FBUF_X_SIZE * FBUF_Y_SIZE);
    sts[0] = malloc(64);
    sts[1] = malloc(64);

    // Initialize frame buffer and start Chained buffer DMA
    giet_fbf_cma_alloc();
    giet_fbf_cma_init_buf(buf[0], buf[1], sts[0], sts[1]);
    giet_fbf_cma_start(FBUF_X_SIZE * FBUF_Y_SIZE);
    cur_buf = 0;

    // Load textures
    g_tex[1] = dispLoadTexture("misc/rock_32.raw");
    g_tex[2] = dispLoadTexture("misc/door_32.raw");
    g_tex[3] = dispLoadTexture("misc/handle_32.raw");
    g_tex[4] = dispLoadTexture("misc/wood_32.raw");

    // Initialise game
    gameInit();

    giet_tty_printf("\n[RAYCAST] initialisation completed at cycle %d\n",
                    giet_proctime() );

    // launch other threads to speed render
    for ( n = 1 ; n < nthreads ; n++ )
    {
        if ( giet_pthread_create( &trdid[n],
                                  NULL,                  // no attribute
                                  &render,
                                  NULL ) )               // no argument
        {
            giet_tty_printf("\n[RAYCAST ERROR] creating thread %d\n", n );
            giet_pthread_exit( NULL );
        }
    }



    // Game main loop : display one frame 
    // and get one player move per iteration
    while ( game.exit == 0 ) 
    {
        // initialise synchronisation variables
        // this actually allows the render threads to make useful work
        slice_count = 0;
        slice_x     = 0;

        // contribute to build current buffer
        unsigned int slice;
        while ( dispRenderSlice( &slice ) );
/*
        unsigned int again;
        do
        {
            again = dispRenderSlice( &slice );
        }
        while ( again );
*/
        // Wait last slice completion
        while (slice_count < FBUF_X_SIZE)  giet_tty_printf(" ");

        // Flip buffer
        giet_fbf_cma_display(cur_buf);
        cur_buf = 1 - cur_buf;

        // get new player position [x,y,dir]
        gameControl();
    }

    giet_pthread_exit( NULL );

}  // end main()
