//////////////////////////////////////////////////////////////////////////////////
// File     : user_lock.h         
// Date     : 01/12/2014
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The file_lock.c and file_lock.h files are part of the GIET-VM nano-kernel.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _USER_LOCK_H_
#define _USER_LOCK_H_

#include "hard_config.h"

///////////////////////////////////////////////////////////////////////////////////
//  simple lock structure
///////////////////////////////////////////////////////////////////////////////////

typedef struct user_lock_s 
{
    unsigned int current;        // current slot index
    unsigned int free;           // next free slot index
    unsigned int padding[14];    // for 64 bytes alignment
} user_lock_t;

///////////////////////////////////////////////////////////////////////////////////
//  simple lock access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int atomic_increment( unsigned int* ptr,
                                      unsigned int  increment );

extern void lock_acquire( user_lock_t * lock );

extern void lock_release( user_lock_t * lock );

extern void lock_init( user_lock_t * lock );

///////////////////////////////////////////////////////////////////////////////////
//      SQT lock structures 
///////////////////////////////////////////////////////////////////////////////////

typedef struct sqt_lock_node_s 
{
    unsigned int            current;         // current ticket index
    unsigned int            free;            // next free ticket index
    unsigned int            level;           // hierarchical level (0 is bottom)
    struct sqt_lock_node_s* parent;          // parent node (NULL for root)
    struct sqt_lock_node_s* child[4];        // children node
    unsigned int            padding[8];      // for 64 bytes alignment         
} sqt_lock_node_t;

typedef struct sqt_lock_s 
{
    sqt_lock_node_t* node[X_SIZE][Y_SIZE][5];  // array of pointers on SBT nodes 
} sqt_lock_t;

//////////////////////////////////////////////////////////////////////////////////
//      SQT lock access functions
//////////////////////////////////////////////////////////////////////////////////


extern void sqt_lock_init( sqt_lock_t*  lock,
                       unsigned int         x_size,
                       unsigned int         y_size,
                       unsigned int         ntasks );

extern void sqt_lock_acquire( sqt_lock_t*  lock );

extern void sqt_lock_release( sqt_lock_t*  lock );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

