#!/usr/bin/env python

from mapping import *

######################################################################################
#   file   : shell.py  
#   date   : july 2015
#   author : Alain Greiner
#######################################################################################
#  This file describes the mapping of the single thread "shell" application. 
#  It is mapped on processor[xmap][ymap][pmap] of the target
#  multi-clusters, multi-processors architecture.
####################################################################################

######################
def extend( mapping ):

    # define mapping 
    xmap  = mapping.x_size - 1
    ymap  = mapping.y_size - 1
    pmap  = mapping.nprocs - 1

    # define vsegs base & size
    code_base  = 0x10000000
    code_size  = 0x00010000     # 64 Kbytes 
    
    data_base  = 0x20000000
    data_size  = 0x00080000     # 512 Kbytes 

    stack_base = 0x40000000 
    stack_size = 0x00200000     # 2 Mbytes 

    heap_base  = 0x60000000 
    heap_size  = 0x00001000     # 4 Kbytes 

    # create vspace
    vspace = mapping.addVspace( name = 'shell', startname = 'shell_data' , active = True )
    
    # data vseg
    mapping.addVseg( vspace, 'shell_data', data_base , data_size, 
                     'C_WU', vtype = 'ELF', x = xmap, y = ymap, pseg = 'RAM', 
                     binpath = 'bin/shell/appli.elf',
                     local = False )

    # code vseg
    mapping.addVseg( vspace, 'shell_code', code_base , code_size,
                     'CXWU', vtype = 'ELF', x = xmap, y = ymap, pseg = 'RAM', 
                     binpath = 'bin/shell/appli.elf',
                     local = False )

    # stack vseg             
    mapping.addVseg( vspace, 'shell_stack', stack_base, stack_size,
                     'C_WU', vtype = 'BUFFER', x = xmap , y = ymap , pseg = 'RAM',
                     local = False, big = True )

    # heap vseg (unused)            
    mapping.addVseg( vspace, 'shell_heap', heap_base, heap_size,
                     'C_WU', vtype = 'BUFFER', x = xmap , y = ymap , pseg = 'RAM',
                     local = False )

    # task 
    mapping.addThread( vspace, 
                       'shell', 
                       True,              # is_main
                       xmap, ymap, pmap,
                       'shell_stack',
                       'shell_heap',
                       0 )                # startid

    # extend mapping name
    mapping.name += '_shell'

    return vspace  # useful for test
            
################################ test ######################################################

if __name__ == '__main__':

    vspace = extend( Mapping( 'test', 2, 2, 4 ) )
    print vspace.xml()


# Local Variables:
# tab-width: 4;
# c-basic-offset: 4;
# c-file-offsets:((innamespace . 0)(inline-open . 0));
# indent-tabs-mode: nil;
# End:
#
# vim: filetype=python:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

