/////////////////////////////////////////////////////////////////////////////////////////
// File   : mjpeg.h   
// Date   : octobre 2015
// author : Alain Greiner
/////////////////////////////////////////////////////////////////////////////////////////
// This file contains all global variables allocated in the mjpeg.c file,
// and used by the threads of the MJPEG application.
// It defines also the debug directives.
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef MJPEG_GLOBALS_H
#define MJPEG_GLOBALS_H

#include <stdint.h>
#include <mwmr_channel.h>
#include <user_lock.h>

#define   MAX_IMAGES  64

////////////////////////////////////////////////////////////////////////////////////////
//  MWMMR channels depths (number of 32 bits words)
////////////////////////////////////////////////////////////////////////////////////////

#define   TG_2_DEMUX_DEPTH          256 
#define   DEMUX_2_VLD_DATA_DEPTH    256
#define   DEMUX_2_VLD_HUFF_DEPTH    256
#define   DEMUX_2_IQZZ_DEPTH        256
#define   VLD_2_IQZZ_DEPTH          256
#define   IQZZ_2_IDCT_DEPTH         256
#define   IDCT_2_LIBU_DEPTH         256 

////////////////////////////////////////////////////////////////////////////////////////
// debug variables 
// O : No trace 
// 1 : simple debug
// 2 : detailed debug
////////////////////////////////////////////////////////////////////////////////////////

#define DEBUG_TG      1
#define DEBUG_DEMUX   0
#define DEBUG_VLD     0
#define DEBUG_IQZZ    0
#define DEBUG_IDCT    0
#define DEBUG_LIBU    0

////////////////////////////////////////////////////////////////////////////////////////
//       Global variables
////////////////////////////////////////////////////////////////////////////////////////

extern uint32_t         fd;    // file descriptor for the file containing MJPEG stream

extern mwmr_channel_t*  tg_2_demux[256];         // one per cluster
extern mwmr_channel_t*  demux_2_vld_data[256];   // one per cluster
extern mwmr_channel_t*  demux_2_vld_huff[256];   // one per cluster
extern mwmr_channel_t*  demux_2_iqzz[256];       // one per cluster
extern mwmr_channel_t*  vld_2_iqzz[256];         // one per cluster
extern mwmr_channel_t*  iqzz_2_idct[256];        // one per cluster
extern mwmr_channel_t*  idct_2_libu[256];        // one per cluster

extern user_lock_t      tty_lock;                // lock protecting shared TTY

extern uint8_t*         cma_buf[256];            // CMA buffers (one per cluster)
extern void*            cma_sts[256];            // CMA buffers status

extern uint32_t         fbf_width;               // Frame Buffer width
extern uint32_t         fbf_height;              // Frame Buffer height

extern uint32_t         nblocks_h;               // number of blocks in a column
extern uint32_t         nblocks_w;               // number of blocks in a row   

extern uint32_t         date[MAX_IMAGES];        // date of completion in libu

#endif
