/* ------------------ */
/* --- nrarith0.h --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef __NRARITH0_H__
#define __NRARITH0_H__

#ifdef __cplusplus
#pragma message ("C++")
extern "C" {
#endif

#ifdef VERBOSE_PRAGMA
//#pragma message(" -include nrarith0.h")
#endif

/* ---------- */
/* -- Swap -- */
/* ---------- */

ROUTINE(void)   i8swap(int8    *a, int8    *b);
ROUTINE(void)  i16swap(int16   *a, int16   *b);
ROUTINE(void)  i32swap(int32   *a, int32   *b);
ROUTINE(void)  i64swap(int64   *a, int64   *b);
ROUTINE(void)  f32swap(float32 *a, float32 *b);
ROUTINE(void)  f64swap(float64 *a, float64 *b);
ROUTINE(void)  rgb8swap(rgb8   *a, rgb8    *b);
ROUTINE(void) rgbx8swap(rgbx8  *a, rgbx8   *b);

/* --------- */
/* -- Min -- */
/* --------- */

ROUTINE(float32) f32min (float32 x1, float32 x2);
ROUTINE(float32) f32min2(float32 x1, float32 x2);
ROUTINE(float32) f32min3(float32 x1, float32 x2, float32 x3);
ROUTINE(float32) f32min4(float32 x1, float32 x2, float32 x3, float32 x4);
ROUTINE(float32) f32min5(float32 x1, float32 x2, float32 x3, float32 x4, float32 x5);

ROUTINE(float64) f64min (float64 x1, float64 x2);
ROUTINE(float64) f64min2(float64 x1, float64 x2);
ROUTINE(float64) f64min3(float64 x1, float64 x2, float64 x3);
ROUTINE(float64) f64min4(float64 x1, float64 x2, float64 x3, float64 x4);
ROUTINE(float64) f64min5(float64 x1, float64 x2, float64 x3, float64 x4, float64 x5);

ROUTINE(byte)  bmin (byte x1, byte x2);
ROUTINE(byte)  bmin2(byte x1, byte x2);
ROUTINE(byte)  bmin3(byte x1, byte x2, byte x3);
ROUTINE(byte)  bmin4(byte x1, byte x2, byte x3, byte x4);
ROUTINE(byte)  bmin5(byte x1, byte x2, byte x3, byte x4, byte x5);

ROUTINE(uint16) ui16min (uint16 x1, uint16 x2);
ROUTINE(uint16) ui16min2(uint16 x1, uint16 x2);
ROUTINE(uint16) ui16min3(uint16 x1, uint16 x2, uint16 x3);
ROUTINE(uint16) ui16min4(uint16 x1, uint16 x2, uint16 x3, uint16 x4);
ROUTINE(uint16) ui16min5(uint16 x1, uint16 x2, uint16 x3, uint16 x4, uint16 x5);

ROUTINE(int32) i32min (int32 x1, int32 x2);
ROUTINE(int32) i32min2(int32 x1, int32 x2);
ROUTINE(int32) i32min3(int32 x1, int32 x2, int32 x3);
ROUTINE(int32) i32min4(int32 x1, int32 x2, int32 x3, int32 x4);
ROUTINE(int32) i32min5(int32 x1, int32 x2, int32 x3, int32 x4, int32 x5);

ROUTINE(rgb8) rgb8min (rgb8 x1, rgb8 x2);
ROUTINE(rgb8) rgb8min2(rgb8 x1, rgb8 x2);
ROUTINE(rgb8) rgb8min3(rgb8 x1, rgb8 x2, rgb8 x3);
ROUTINE(rgb8) rgb8min4(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4);
ROUTINE(rgb8) rgb8min5(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4, rgb8 x5);

/* --------- */
/* -- Max -- */
/* --------- */
ROUTINE(float32) f32max (float32 x1, float32 x2);
ROUTINE(float32) f32max2(float32 x1, float32 x2);
ROUTINE(float32) f32max3(float32 x1, float32 x2, float32 x3);
ROUTINE(float32) f32max4(float32 x1, float32 x2, float32 x3, float32 x4);
ROUTINE(float32) f32max5(float32 x1, float32 x2, float32 x3, float32 x4, float32 x5);

ROUTINE(float64) f64max (float64 x1, float64 x2);
ROUTINE(float64) f64max2(float64 x1, float64 x2);
ROUTINE(float64) f64max3(float64 x1, float64 x2, float64 x3);
ROUTINE(float64) f64max4(float64 x1, float64 x2, float64 x3, float64 x4);
ROUTINE(float64) f64max5(float64 x1, float64 x2, float64 x3, float64 x4, float64 x5);

ROUTINE(byte)  bmax (byte x1,  byte x2);
ROUTINE(byte)  bmax2(byte x1,  byte x2);
ROUTINE(byte)  bmax3(byte x1,  byte x2, byte x3);
ROUTINE(byte)  bmax4(byte x1,  byte x2, byte x3, byte x4);
ROUTINE(byte)  bmax5(byte x1,  byte x2, byte x3, byte x4, byte x5);

ROUTINE(uint16) ui16max (uint16 x1, uint16 x2);
ROUTINE(uint16) ui16max2(uint16 x1, uint16 x2);
ROUTINE(uint16) ui16max3(uint16 x1, uint16 x2, uint16 x3);
ROUTINE(uint16) ui16max4(uint16 x1, uint16 x2, uint16 x3, uint16 x4);
ROUTINE(uint16) ui16max5(uint16 x1, uint16 x2, uint16 x3, uint16 x4, uint16 x5);

ROUTINE(int32) i32max (int32 x1, int32 x2);
ROUTINE(int32) i32max2(int32 x1, int32 x2);
ROUTINE(int32) i32max3(int32 x1, int32 x2, int32 x3);
ROUTINE(int32) i32max4(int32 x1, int32 x2, int32 x3, int32 x4);
ROUTINE(int32) i32max5(int32 x1, int32 x2, int32 x3, int32 x4, int32 x5);

ROUTINE(rgb8) rgb8max (rgb8 x1, rgb8 x2);
ROUTINE(rgb8) rgb8max2(rgb8 x1, rgb8 x2);
ROUTINE(rgb8) rgb8max3(rgb8 x1, rgb8 x2, rgb8 x3);
ROUTINE(rgb8) rgb8max4(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4);
ROUTINE(rgb8) rgb8max5(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4, rgb8 x5);

/* ----------- */
/* -- Other -- */
/* ----------- */

ROUTINE(byte) ibit(int32 x, int n);
ROUTINE(int32) sym_int32(int32 x);
ROUTINE(int) myLog2(int x);
ROUTINE(int) next_power2(int x);
ROUTINE(int) myGCD(int u, int v);
ROUTINE(int) myLCM(int u, int v);

#ifdef __cplusplus
}
#endif

#else
//#pragma message(" Warning : attempt to re-include nrarith0.h") 
#endif

