/* ------------------------ */
/* --- ecc_generation.h --- */
/* ------------------------ */

#ifndef __ECC_GENERATION_H__
#define __ECC_GENERATION_H__

#ifdef __cplusplus
#pragma message ("C++")
extern "C" {
#endif

void generate_granularity_density_int  (uint8 **X, int i0, int i1, int j0, int j1, int granularity, int   density, int seed);
void generate_granularity_density_float(uint8 **X, int i0, int i1, int j0, int j1, int granularity, float density, int seed);
    
void generate_size_granularity_name            (char *name, int size, int granularity,                               char *filename);
void generate_granularity_density_name         (char *name,           int granularity, int density,                  char *filename);
void generate_granularity_density_ext_name     (char *name,           int granularity, int density, char *extension, char *filename);
    
void generate_size_granularity_density_name    (char *name, int size, int granularity, int density,                  char *filename);
void generate_size_granularity_density_ext_name(char *name, int size, int granularity, int density, char *extension, char *filename);

void generate_name100(char *name, int granularity, float density, char *filename);

int test_generation(int argc, char* argv[]);
int test_generation_HGH(int argc, char* argv[]);

int image_analysis_2014(int argc, char* argv[]); // segment, pixel, step, concavity ...

void test_generation_mt(void);

void spirale_simple(uint8 **X, int height, int width);
void spirale_double(uint8 **X, int height, int width);
void test_spirale(int argc, char* argv[]);
    
void image_duplication(int argc, char *argv[]);

#ifdef __cplusplus
}
#endif

#endif // __ECC_GENERATION_H__
