/* -------------------------*/
/* --- ecc_rosenfield.h --- */
/* ------------------------ */

#ifndef _ECC_ROSENFELD_H_
#define _ECC_ROSENFELD_H_

//#include "def.h"
////#include "nrc.h"
//#include "util.h"
//#include "ecc_common.h"
 
#ifdef __cplusplus
#pragma message ("C++")
extern "C" {
#endif
    
uint32 FindRoot(uint32 *T, uint32 e);
void SetRoot(uint32 *T, uint32 e, uint32 r);
uint32 Find(uint32 *T, uint32 e);
    
uint32 Union0(uint32 *T, uint32 ei, uint32 ej);
uint32 Union1(uint32 *T, uint32 ei, uint32 ej);
uint32 Union2(uint32 *T, uint32 ei, uint32 ej);
uint32 Union4(uint32 *T, uint32 e1, uint32 e2, uint32 e3, uint32 e4);

uint32 updateTable_Rosenfeld         (uint32 *T, uint32 e, uint32 epsillon);
uint32 updateTable_Features_Rosenfeld(uint32 *T, uint32 e, uint32 epsillon, RegionStats *Stats);
    
void Flatten(uint32 *T, int ne);
int FlattenL(uint32 *T, int ne);

uint32 solveTable_Rosenfeld(    uint32 *T, uint32 ne);
uint32 solvePackTable_Rosenfeld(uint32 *T, uint32 ne);
    
uint32 solveTable_Features_Rosenfeld    (uint32 *T, uint32 ne, RegionStats *Stats);
uint32 solvePackTable_Features_Rosenfeld(uint32 *T, uint32 ne, RegionStats *Stats);

    
void solveTableE_Rosenfeld_Montanvert(uint32 *T, uint32 ne);
void solveTableA_Rosenfeld_Montanvert(uint32 *T, uint32 ne);
void solveTable_Rosenfeld_Montanvert (uint32 *T, uint32 ne);
    
// ---------------------------
// -- line-labeling ----------
// ---------------------------
    
uint32 lineLabeling_Rosenfeld_UF_Org1_4C(uint8 **X, int i, int width, uint32 **E, uint32 *T, uint32 ne, uint32 nemax);
uint32 lineLabeling_Rosenfeld_UF_Org1_8C(uint8 **X, int i, int width, uint32 **E, uint32 *T, uint32 ne, uint32 nemax);
    
uint32 lineLabeling_Rosenfeld_UF_Org2_4C(uint8 **X, int i, int width, uint32 **E, uint32 *T, uint32 ne, uint32 nemax);

uint32 lineLabeling_Rosenfeld_UF_Org3_4C(uint8 **X, int i, int width, uint32 **E, uint32 *T, uint32 ne, uint32 nemax);
uint32 lineLabeling_Rosenfeld_UF_Org3_8C(uint8 **X, int i, int width, uint32 **E, uint32 *T, uint32 ne, uint32 nemax);
    
// ----------------------------
// -- image-labeling ----------
// ----------------------------
uint32 Rosenfeld_UF_Org1_4C_pass1(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 nemax, RegionStats *Stats);
uint32 Rosenfeld_UF_Org1_8C_pass1(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 nemax, RegionStats *Stats);

uint32 Rosenfeld_UF_Org2_4C_pass1(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 nemax, RegionStats *Stats);

uint32 Rosenfeld_UF_Org3_4C_pass1(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 nemax, RegionStats *Stats);
uint32 Rosenfeld_UF_Org3_8C_pass1(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 nemax, RegionStats *Stats);

// -----------------------------------------
// -- interface labeling function ----------
// -----------------------------------------
uint32 Rosenfeld_UF_Org1_4C(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 *A, uint32 nemax, RegionStats *Stats);
uint32 Rosenfeld_UF_Org1_8C(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 *A, uint32 nemax, RegionStats *Stats);
    
uint32 Rosenfeld_UF_Org2_4C(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 *A, uint32 nemax, RegionStats *Stats);
    
uint32 Rosenfeld_UF_Org3_4C(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 *A, uint32 nemax, RegionStats *Stats);  
uint32 Rosenfeld_UF_Org3_8C(uint8 **X, int height, int width, uint32 **E, uint32 *T, uint32 *A, uint32 nemax, RegionStats *Stats);

#ifdef __cplusplus
}
#endif

#endif /* _ECC_ROSENFELD_H_ */
