/* ----------------- */
/* --- nrbool1.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrbool1.h"

/*
 * -----------
 * --- Not ---
 * -----------
 */

/* -------------------------------------------------------------- */
IMAGE_EXPORT(void) not_bvector(byte *X, long ncl, long nch, byte *Y)
/* -------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) not_si8vector(sint8 *X, long ncl, long nch, sint8 *Y)
/* ------------------------------------------------------------------ */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) not_ui8vector(uint8 *X, long ncl, long nch, uint8 *Y)
/* ------------------------------------------------------------------ */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si16vector(sint16 *X, long ncl, long nch, sint16 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui16vector(uint16 *X, long ncl, long nch, uint16 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si32vector(sint32 *X, long ncl, long nch, sint32 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui32vector(uint32 *X, long ncl, long nch, uint32 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si64vector(sint64 *X, long ncl, long nch, sint64 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui64vector(uint64 *X, long ncl, long nch, uint64 *Y)
/* --------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Y[j] = ~X[j];
	}
}
/* ----------------------------------------------------------------- */
IMAGE_EXPORT(void) not_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 *Y)
/* ----------------------------------------------------------------- */
{
	long j;
    rgb8 x, y;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGB8_NOT(x,y);
		Y[j] = y;
	}
}
/* -------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 *Y)
/* -------------------------------------------------------------------- */
{
	long j;
    rgbx8 x, y;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGBX8_NOT(x,y);
		Y[j] = y;
	}
}
/*
 * -----------
 * --- Or ---
 * -----------
 */

/* ---------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_bvector(byte *X, long ncl, long nch, byte *Y, byte *Z)
/* ---------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* --------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si8vector(sint8 *X, long ncl, long nch, sint8 *Y, sint8 *Z)
/* --------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* --------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui8vector(uint8 *X, long ncl, long nch, uint8 *Y, uint8 *Z)
/* --------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si16vector(sint16 *X, long ncl, long nch, sint16 *Y, sint16 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui16vector(uint16 *X, long ncl, long nch, uint16 *Y, uint16 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si32vector(sint32 *X, long ncl, long nch, sint32 *Y, sint32 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui32vector(uint32 *X, long ncl, long nch, uint32 *Y, uint32 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si64vector(sint64 *X, long ncl, long nch, sint64 *Y, sint64 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui64vector(uint64 *X, long ncl, long nch, uint64 *Y, uint64 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | Y[j];
	}
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 *Y, rgb8 *Z)
/* ------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGB8_OR(x,y,z);
		Z[j] = z;
	}
}
/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 *Y, rgbx8 *Z)
/* ----------------------------------------------------------------------------- */
{
	long j;
    rgbx8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGBX8_OR(x,y,z);
		Z[j] = z;
	}
}
/* ---------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_bvector(byte *X, long ncl, long nch, byte y, byte *Z)
/* ---------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* --------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si8vector(sint8 *X, long ncl, long nch, sint8 y, sint8 *Z)
/* --------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* --------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui8vector(uint8 *X, long ncl, long nch, uint8 y, uint8 *Z)
/* --------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si16vector(sint16 *X, long ncl, long nch, sint16 y, sint16 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui16vector(uint16 *X, long ncl, long nch, uint16 y, uint16 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si32vector(sint32 *X, long ncl, long nch, sint32 y, sint32 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui32vector(uint32 *X, long ncl, long nch, uint32 y, uint32 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si64vector(sint64 *X, long ncl, long nch, sint64 y, sint64 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui64vector(uint64 *X, long ncl, long nch, uint64 y, uint64 *Z)
/* ------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] | y;
	}
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 y, rgb8 *Z)
/* ------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGB8_OR(x,y,z);
		Z[j] = z;
	}
}
/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 y, rgbx8 *Z)
/* ----------------------------------------------------------------------------- */
{
	long j;
    rgbx8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGBX8_OR(x,y,z);
		Z[j] = z;
	}
}
/*
 * -----------
 * --- XOR ---
 * -----------
 */
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_bvector(byte *X, long ncl, long nch, byte *Y, byte *Z)
/* ----------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si8vector(sint8 *X, long ncl, long nch, sint8 *Y, sint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui8vector(uint8 *X, long ncl, long nch, uint8 *Y, uint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si16vector(sint16 *X, long ncl, long nch, sint16 *Y, sint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui16vector(uint16 *X, long ncl, long nch, uint16 *Y, uint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si32vector(sint32 *X, long ncl, long nch, sint32 *Y, sint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui32vector(uint32 *X, long ncl, long nch, uint32 *Y, uint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si64vector(sint64 *X, long ncl, long nch, sint64 *Y, sint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui64vector(uint64 *X, long ncl, long nch, uint64 *Y, uint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ Y[j];
	}
}
/* -------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 *Y, rgb8 *Z)
/* -------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGB8_XOR(x,y,z);
		Z[j] = z;
	}
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) xor_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 *Y, rgbx8 *Z)
/* ------------------------------------------------------------------------------ */
{
	long j;
    rgbx8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGBX8_XOR(x,y,z);
		Z[j] = z;
	}
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_bvector(byte *X, long ncl, long nch, byte y, byte *Z)
/* ----------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si8vector(sint8 *X, long ncl, long nch, sint8 y, sint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui8vector(uint8 *X, long ncl, long nch, uint8 y, uint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si16vector(sint16 *X, long ncl, long nch, sint16 y, sint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui16vector(uint16 *X, long ncl, long nch, uint16 y, uint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si32vector(sint32 *X, long ncl, long nch, sint32 y, sint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui32vector(uint32 *X, long ncl, long nch, uint32 y, uint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si64vector(sint64 *X, long ncl, long nch, sint64 y, sint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui64vector(uint64 *X, long ncl, long nch, uint64 y, uint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] ^ y;
	}
}
/* -------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 y, rgb8 *Z)
/* -------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGB8_XOR(x,y,z);
		Z[j] = z;
	}
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) xorc_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 y, rgbx8 *Z)
/* ------------------------------------------------------------------------------ */
{
	long j;
    rgbx8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGBX8_XOR(x,y,z);
		Z[j] = z;
	}
}
/*
 * -----------
 * --- AND ---
 * -----------
 */
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_bvector(byte *X, long ncl, long nch, byte *Y, byte *Z)
/* ----------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si8vector(sint8 *X, long ncl, long nch, sint8 *Y, sint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui8vector(uint8 *X, long ncl, long nch, uint8 *Y, uint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si16vector(sint16 *X, long ncl, long nch, sint16 *Y, sint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui16vector(uint16 *X, long ncl, long nch, uint16 *Y, uint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si32vector(sint32 *X, long ncl, long nch, sint32 *Y, sint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui32vector(uint32 *X, long ncl, long nch, uint32 *Y, uint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si64vector(sint64 *X, long ncl, long nch, sint64 *Y, sint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui64vector(uint64 *X, long ncl, long nch, uint64 *Y, uint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & Y[j];
	}
}
/* -------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 *Y, rgb8 *Z)
/* -------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGB8_AND(x,y,z);
		Z[j] = z;
	}
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) and_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 *Y, rgbx8 *Z)
/* ------------------------------------------------------------------------------ */
{
	long j;
    rgbx8 x, y, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        y = Y[j];
        RGBX8_AND(x,y,z);
		Z[j] = z;
	}
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_bvector(byte *X, long ncl, long nch, byte y, byte *Z)
/* ----------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si8vector(sint8 *X, long ncl, long nch, sint8 y, sint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui8vector(uint8 *X, long ncl, long nch, uint8 y, uint8 *Z)
/* ---------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si16vector(sint16 *X, long ncl, long nch, sint16 y, sint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui16vector(uint16 *X, long ncl, long nch, uint16 y, uint16 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si32vector(sint32 *X, long ncl, long nch, sint32 y, sint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui32vector(uint32 *X, long ncl, long nch, uint32 y, uint32 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si64vector(sint64 *X, long ncl, long nch, sint64 y, sint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui64vector(uint64 *X, long ncl, long nch, uint64 y, uint64 *Z)
/* -------------------------------------------------------------------------------- */
{
	long j;
	
	for(j=ncl; j<=nch; j++) {
		Z[j] = X[j] & y;
	}
}
/* -------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_rgb8vector(rgb8 *X, long ncl, long nch, rgb8 y, rgb8 *Z)
/* -------------------------------------------------------------------------- */
{
	long j;
    rgb8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGB8_AND(x,y,z);
		Z[j] = z;
	}
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) andc_rgbx8vector(rgbx8 *X, long ncl, long nch, rgbx8 y, rgbx8 *Z)
/* ------------------------------------------------------------------------------ */
{
	long j;
    rgbx8 x, z;
	
	for(j=ncl; j<=nch; j++) {
        x = X[j];
        RGBX8_AND(x,y,z);
		Z[j] = z;
	}
}
