/* --------------- */
/* --- tools.c --- */
/* --------------- */

// Copyright (c) 2013-2014 Lionel Lacassagne, All Rights Reserved
// Laboratoire de Recherche en Informatique
// Universite Paris-Sud / CNRS

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <math.h>

#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif

#include "ecc_features.h"

#ifndef FREQ
#define FREQ 1
#endif

/* ---------------- */
/* --- routines --- */
/* ---------------- */

// ---------------------
uint32 i32log2(uint32 x)
// ---------------------
{
    int p = 0; // power of 2
    while (x > 0) {
        x = x >> 1;
        p = p + 1;
    }
    return p - 1;
}

/* ------------- */
uint8 ui8rand(void)
/* ------------- */
{
    static uint32 x = 0;
    x = (11 * x + 13) % 17;
    return  x;
}
/* --------------- */
uint32 ui32rand(void)
/* --------------- */
{
    static uint32 x = 0;
    x = (11 * x + 13) % 17;
    return x;
}
/* --------------- */
float32 f32rand(void)
/* --------------- */
{ 
    static float32 x = 0;
    x = (float32) fmod(11 * x + 13, 17);
    return x ;
}
/* --------------------------------------- */
void rand_ui8vector(uint8 * X, int i0, int i1)
/* --------------------------------------- */
{
    int i;

    for(i = i0; i <= i1; i++) {
        X[i] = ui8rand();
    }
}
/* ----------------------------------------- */
void rand_ui32vector(uint32 *X, int i0, int i1)
/* ----------------------------------------- */
{
    int i;

    for (i = i0; i <= i1; i++) {
        X[i] = ui32rand();
    }
}
/* ----------------------------------------- */
void rand_f32vector(float32 *X, int i0, int i1)
/* ----------------------------------------- */
{
    int i;

    for(i = i0; i <= i1; i++) {
        X[i] = f32rand();
    }
}
/* --------------- */
int getIter(int size)
/* --------------- */
{
    if (size <   32) return 1024;
    if (size <   64) return 64 ;
    if (size <  128) return 8;
    if (size <  256) return 2;
    if (size <  512) return 2;
    if (size < 1024) return 2;
    if (size < 2048) return 1;
    return 2;
}
/* ----------------- */
int getIterAV(int size)
/* ----------------- */
{
    return 3 * getIter(size);
}
/* --------------------------------- */
float32 gauss(float32 sigma, float32 x)
/* --------------------------------- */
{
    float64 pi = 3.1415927;
    float64 y;
    y = 1.0 / (sqrt(2 * pi) * sigma) * exp(-(x * x) / (2 * sigma * sigma));
    return (float32) y;
}

/* --------------------- */
double cpp(double t, int n)
/* --------------------- */
{
    double c = n;
    double cpp = t * FREQ / c;
    return cpp;
}
// --------------------------
void printf_split12(double x)
// --------------------------
{
    double x3, x2, x1, x0, t = x;
    
    x0 = fmod(x, 1000);
    x = floor(x / 1000);
    x1 = fmod(x, 1000);
    x = floor(x / 1000);
    x2 = fmod(x, 1000);
    x = floor(x / 1000);
    x3 = fmod(x, 1000);
    //printf("t = %14f\n", t);
    if (t < 1e3) {
        printf("%15.0f", x0);
        return;
    }
    if (t < 1e6) {
        printf("%11.0f,%03.0f", x1, x0);
        return;
    }
    if (t < 1e9) {
        printf("%7.0f,%03.0f,%03.0f", x2, x1, x0);
        return;
    }
    if (t < 1e12) {
        printf("%3.0f,%03.0f,%03.0f,%03.0f", x3, x2, x1, x0);
        return;
    }
    printf("");
}

// --------------------------
void printf_split15(double x)
// --------------------------
{
    double x4, x3, x2, x1, x0, t = x;
    
    x0 = fmod(x, 1000);
    x = floor(x / 1000);
    x1 = fmod(x, 1000);
    x = floor(x / 1000);
    x2 = fmod(x, 1000);
    x = floor(x / 1000);
    x3 = fmod(x, 1000);
    x = floor(x / 1000);
    x4 = fmod(x, 1000);
    //printf("t = %14f\n", t);
    if (t < 1e3) {
        printf("%19.0f", x0);
        return;
    }
    if (t < 1e6) {
        printf("%15.0f,%03.0f", x1, x0);
        return;
    }
    if (t < 1e9) {
        printf("%11.0f,%03.0f,%03.0f", x2, x1, x0);
        return;
    }
    if (t < 1e12) {
        printf("%7.0f,%03.0f,%03.0f,%03.0f", x3, x2, x1, x0);
        return;
    }
    if (t < 1e15) {
        printf("%3.0f,%3.0f,%03.0f,%03.0f,%03.0f", x4,x3, x2, x1, x0);
        return;
    }
    printf("");
}
// --------------------------
void printf_split18(double x)
// --------------------------
{
    double x5, x4, x3, x2, x1, x0, t = x;
    
    x0 = fmod(x, 1000);
    x = floor(x / 1000);
    x1 = fmod(x, 1000);
    x = floor(x / 1000);
    x2 = fmod(x, 1000);
    x = floor(x / 1000);
    x3 = fmod(x, 1000);
    x = floor(x / 1000);
    x4 = fmod(x, 1000);
    x = floor(x / 1000);
    x5 = fmod(x, 1000);
    //printf("t = %14f\n", t);
    if (t < 1e3)  {
        printf("%23.0f", x0);
        return;
    }
    if (t < 1e6)  {
        printf("%19.0f,%03.0f", x1, x0);
        return;
    }
    if (t < 1e9)  {
        printf("%15.0f,%03.0f,%03.0f", x2, x1, x0);
        return;
    }
    if (t < 1e12) {
        printf("%11.0f,%03.0f,%03.0f,%03.0f", x3, x2, x1, x0);
        return;
    }
    if (t < 1e15) {
        printf("%7.0f,%3.0f,%03.0f,%03.0f,%03.0f", x4, x3, x2, x1, x0);
        return;
    }
    if (t < 1e18) {
        printf("%3.0f,%3.0f,%3.0f,%03.0f,%03.0f,%03.0f", x5, x4, x3, x2, x1, x0);
        return;
    }
    printf("");
}
// ------------------------
void printf_split(double x)
// ------------------------
{
    printf_split12(x);
    //printf_split15(x);
    //printf_split18(x);
}
    
