/* --------------- */
/* --- bmpNR.h --- */
/* --------------- */

/*
 * Gestion des bmp
 */
/*
 * Copyright (c) 1997 Lionel Lacassagne EIA
 * Copyright (c) 2001 Lionel Lacassagne PARC-LIS-UPMC (Paris 6)
 * Init 97-09-30
 * Modif : 97-09-30
 * modif : 01-01-30 : integration into Foundation
 *                    Note that return code have been added without testing (right now)
 * modif : 03-05-05 : windows independant, stand-alone version ready for linux
 */

#ifndef __BMP_NR_H__
#define __BMP_NR_H__

#ifdef __cplusplus
#ifdef PRAGMA_VERBOSE
#pragma message ("C++")
#endif
extern "C" {
#endif

#define Warning 
#define Error 
  
#ifdef PRAGMA_VERBOSE
//#pragma message ("- include bmpio.h")
//#pragma message ("  MARCHE MEME POUR LES NON MULTIPLES DE 4")
#endif
/*
 * La structure RGBQuad est definie dans palette.h, donc a inclure
 * structure analogue a RGBQUAD, mais permet d'etre independant de windows
 */


  /*
   * Windows definition
   * WORD  = unsigned short = uint16
   * DWORD = unsigned long  = uint32
   * LONG  = unsigned long  = uint32
   */

//#include <windows.h>
//#include <wingdi.h>

#pragma pack(1)
    
#ifndef WIN32
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef unsigned long LONG;
#endif

#ifndef WIN32
typedef struct {
        WORD    bfType;
        DWORD   bfSize;
        WORD    bfReserved1;
        WORD    bfReserved2;
        DWORD   bfOffBits;
} BITMAPFILEHEADER;
#endif

#ifndef WIN32
typedef struct {
        DWORD      biSize;
        LONG       biWidth;
        LONG       biHeight;
        WORD       biPlanes;
        WORD       biBitCount;
        DWORD      biCompression;
        DWORD      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        DWORD      biClrUsed;
        DWORD      biClrImportant;
} BITMAPINFOHEADER;
#endif
    
typedef struct {
  uint16    bfType;      //  WORD
  uint32    bfSize;      // DWORD
  uint16    bfReserved1; //  WORD
  uint16    bfReserved2; //  WORD
  uint32    bfOffBits;   // DWORD
} BitmapFileHeader;

typedef struct {
  uint32    biSize;           // DWORD
  uint32    biWidth;          // LONG
  uint32    biHeight;         // LONG
  uint16    biPlanes;         // WORD
  uint16    biBitCount;       // WORD
  uint32    biCompression;    // DWORD
  uint32    biSizeImage;      // DWORD
  uint32    biXPelsPerMeter;  // LONG
  uint32    biYPelsPerMeter;  // LONG
  uint32    biClrUsed;        // DWORD
  uint32    biClrImportant;   // DWORD
} BitmapInfoHeader;

#pragma pack()
    
//IMAGE_EXPORT(int) SaveBMP0(Image *image, RGBQuad *palette_RGBQuad, char *filename); // windows dependant
IMAGE_EXPORT(int) SaveBMP2_ui8matrix (uint8 **m, int width, int height, RGBQuad *palette_RGBQuad, char *filename); // linux stand-alone 

//IMAGE_EXPORT(int) LoadBMP(char *filename, Image **image);

//IMAGE_EXPORT(int) MLoadBMP     (char *filename, Image *image);
//IMAGE_EXPORT(int) MLoadNextBMP (char *path, char *filename, int k, Image *Buff);
//IMAGE_EXPORT(int) MSaveNextBMP (Image *image, RGBQuad *palette, char *path, char *filename, int k);
//IMAGE_EXPORT(int) MSaveNextBMP2(Image *image, RGBQuad *palette, char *path, char *filename, int k, int l);

//IMAGE_EXPORT(int) MSaveNextBMP_ndigit (Image *image, RGBQuad *palette, char *path, char *filename, int k, int ndigit);
//IMAGE_EXPORT(int) MSaveNextBMP2_ndigit(Image *image, RGBQuad *palette, char *path, char *filename, int k, int l, int ndigit);


#ifdef __cplusplus
}
#endif

#endif /* __BMP_NR_H__ */
