/* ------------------ */
/* --- nrarith2.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
*/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs
// #include <memory.h> // memcpy

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrarith1.h"
#include "nrarith2.h"

/* ------------------ */
/* --- min_matrix --- */
/* ------------------ */

/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(sint8) min_si8matrix(sint8 **m, long nrl, long nrh, long ncl, long nch)
/* ----------------------------------------------------------------------------- */
{
	int i, j;
	sint8 minimum = m[nrl][ncl];
	    
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(uint8) min_ui8matrix(uint8 **m, long nrl, long nrh, long ncl, long nch)
/* ------------------------------------------------------------------------------ */
{
	int i, j;
	uint8 minimum = m[nrl][ncl];
	    
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint16) min_si16matrix(sint16 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint16 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint16) min_ui16matrix(uint16 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint16 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint32) min_si32matrix(sint32 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint32) min_ui32matrix(uint32 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint64) min_si64matrix(sint64 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint64) min_ui64matrix(uint64 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(float32) min_f32matrix(float32 **m, long nrl, long nrh, long ncl, long nch)
/* ---------------------------------------------------------------------------------- */
{
	int i, j;
	float32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(float64) min_f64matrix(float64 **m, long nrl, long nrh, long ncl, long nch)
/* ---------------------------------------------------------------------------------- */
{
	int i, j;
	float64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]<minimum) minimum = m[i][j];
		}
	}
	return minimum;
}

/* ------------------ */
/* --- max_matrix --- */
/* ------------------ */

/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(sint8) max_si8matrix(sint8 **m, long nrl, long nrh, long ncl, long nch)
/* ----------------------------------------------------------------------------- */
{
	int i, j;
	sint8 minimum = m[nrl][ncl];
	    
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(uint8) max_ui8matrix(uint8 **m, long nrl, long nrh, long ncl, long nch)
/* ------------------------------------------------------------------------------ */
{
	int i, j;
	uint8 minimum = m[nrl][ncl];
	    
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint16) max_si16matrix(sint16 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint16 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint16) max_ui16matrix(uint16 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint16 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint32) max_si32matrix(sint32 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint32) max_ui32matrix(uint32 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(sint64) max_si64matrix(sint64 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	sint64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(uint64) max_ui64matrix(uint64 **m, long nrl, long nrh, long ncl, long nch)
/* --------------------------------------------------------------------------------- */
{
	int i, j;
	uint64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(float32) max_f32matrix(float32 **m, long nrl, long nrh, long ncl, long nch)
/* ---------------------------------------------------------------------------------- */
{
	int i, j;
	float32 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(float64) max_f64matrix(float64 **m, long nrl, long nrh, long ncl, long nch)
/* ---------------------------------------------------------------------------------- */
{
	int i, j;
	float64 minimum = m[nrl][ncl];
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(m[i][j]>minimum) minimum = m[i][j];
		}
	}
	return minimum;
}

/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_si8matrix(sint8 **X, long nrl,long nrh, long ncl, long nch, sint8 **Y, sint8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}

/* ------------------ */
/* --- Add Matrix --- */
/* ------------------ */

/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_ui8matrix(uint8 **X, long nrl,long nrh, long ncl, long nch, uint8 **Y, uint8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_si16matrix(sint16 **X, long nrl,long nrh, long ncl, long nch, sint16 **Y, sint16 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_ui16matrix(uint16 **X, long nrl,long nrh, long ncl, long nch, uint16 **Y, uint16 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_si32matrix(sint32 **X, long nrl,long nrh, long ncl, long nch, sint32 **Y, sint32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_ui32matrix(uint32 **X, long nrl,long nrh, long ncl, long nch, uint32 **Y, uint32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_si64matrix(sint64 **X, long nrl,long nrh, long ncl, long nch, sint64 **Y, sint64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) add_ui64matrix(uint64 **X, long nrl,long nrh, long ncl, long nch, uint64 **Y, uint64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_f32matrix(float32 **X, long nrl,long nrh, long ncl, long nch, float32 **Y, float32 **Z)
/* -------------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_f64matrix(float64 **X, long nrl,long nrh, long ncl, long nch, float64 **Y, float64 **Z)
/* -------------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] + Y[i][j];
		}
	}
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y, rgb8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
	long i, j;
	rgb8 x, y, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = Y[i][j];
			//z = x + y;
			RGB8_ADD(x,y,z);
			Z[i][j] = z;
		}
	}
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) add_rgbx8matrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y, rgbx8 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
	long i, j;
	rgbx8 x, y, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = Y[i][j];
			//z = x + y;
			RGBX8_ADD(x,y,z);
			Z[i][j] = z;
		}
	}
}

/* -------------------- */
/* --- Add constant --- */
/* -------------------- */

/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) addc_si8matrix(sint8 **X,long nrl,long nrh, long ncl, long nch, sint8 y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) addc_ui8matrix(uint8 **X,long nrl,long nrh, long ncl, long nch, uint8 y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_si16matrix(sint16 **X,long nrl,long nrh, long ncl, long nch, sint16 y, sint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_ui16matrix(uint16 **X,long nrl,long nrh, long ncl, long nch, uint16 y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_si32matrix(sint32 **X,long nrl,long nrh, long ncl, long nch, sint32 y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_ui32matrix(uint32 **X,long nrl,long nrh, long ncl, long nch, uint32 y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_si64matrix(sint64 **X,long nrl,long nrh, long ncl, long nch, sint64 y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_ui64matrix(uint64 **X,long nrl,long nrh, long ncl, long nch, uint64 y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) addc_f32matrix(float32 **X,long nrl,long nrh, long ncl, long nch, float32 y, float32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) addc_f64matrix(float64 **X,long nrl,long nrh, long ncl, long nch, float64 y, float64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] + y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_rgb8matrix(rgb8 **X,long nrl,long nrh, long ncl, long nch, rgb8 y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgb8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGB8_ADD(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) addc_rgbx8matrix(rgbx8 **X,long nrl,long nrh, long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgbx8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGBX8_ADD(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* ------------------ */
/* --- Add Matrix --- */
/* ------------------ */

/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) sub_ui8matrix(uint8 **X, long nrl,long nrh, long ncl, long nch, uint8 **Y, uint8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_si16matrix(sint16 **X, long nrl,long nrh, long ncl, long nch, sint16 **Y, sint16 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_ui16matrix(uint16 **X, long nrl,long nrh, long ncl, long nch, uint16 **Y, uint16 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_si32matrix(sint32 **X, long nrl,long nrh, long ncl, long nch, sint32 **Y, sint32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_ui32matrix(uint32 **X, long nrl,long nrh, long ncl, long nch, uint32 **Y, uint32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_si64matrix(sint64 **X, long nrl,long nrh, long ncl, long nch, sint64 **Y, sint64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) sub_ui64matrix(uint64 **X, long nrl,long nrh, long ncl, long nch, uint64 **Y, uint64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) sub_f32matrix(float32 **X, long nrl,long nrh, long ncl, long nch, float32 **Y, float32 **Z)
/* -------------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) sub_f64matrix(float64 **X, long nrl,long nrh, long ncl, long nch, float64 **Y, float64 **Z)
/* -------------------------------------------------------------------------------------------------------- */
{
	long i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			Z[i][j] = X[i][j] - Y[i][j];
		}
	}
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) sub_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y, rgb8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
	long i, j;
	rgb8 x, y, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = Y[i][j];
			RGB8_SUB(x,y,z);
			Z[i][j] = z;
		}
	}
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) sub_rgbx8matrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y, rgbx8 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
	long i, j;
	rgbx8 x, y, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = Y[i][j];
			RGBX8_SUB(x,y,z);
			Z[i][j] = z;
		}
	}
}

/* -------------------- */
/* --- Sub constant --- */
/* -------------------- */

/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) subc_si8matrix(sint8 **X,long nrl,long nrh, long ncl, long nch, sint8 y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) subc_ui8matrix(uint8 **X,long nrl,long nrh, long ncl, long nch, uint8 y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_si16matrix(sint16 **X,long nrl,long nrh, long ncl, long nch, sint16 y, sint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_ui16matrix(uint16 **X,long nrl,long nrh, long ncl, long nch, uint16 y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_si32matrix(sint32 **X,long nrl,long nrh, long ncl, long nch, sint32 y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_ui32matrix(uint32 **X,long nrl,long nrh, long ncl, long nch, uint32 y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_si64matrix(sint64 **X,long nrl,long nrh, long ncl, long nch, sint64 y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_ui64matrix(uint64 **X,long nrl,long nrh, long ncl, long nch, uint64 y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) subc_f32matrix(float32 **X,long nrl,long nrh, long ncl, long nch, float32 y, float32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) subc_f64matrix(float64 **X,long nrl,long nrh, long ncl, long nch, float64 y, float64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] - y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_rgb8matrix(rgb8 **X,long nrl,long nrh, long ncl, long nch, rgb8 y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgb8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGB8_SUB(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) subc_rgbx8matrix(rgbx8 **X,long nrl,long nrh, long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgbx8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGBX8_SUB(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* -------------------- */
/* --- Mul constant --- */
/* -------------------- */

/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulc_si8matrix(sint8 **X,long nrl,long nrh, long ncl, long nch, sint8 y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulc_ui8matrix(uint8 **X,long nrl,long nrh, long ncl, long nch, uint8 y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_si16matrix(sint16 **X,long nrl,long nrh, long ncl, long nch, sint16 y, sint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_ui16matrix(uint16 **X,long nrl,long nrh, long ncl, long nch, uint16 y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_si32matrix(sint32 **X,long nrl,long nrh, long ncl, long nch, sint32 y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_ui32matrix(uint32 **X,long nrl,long nrh, long ncl, long nch, uint32 y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_si64matrix(sint64 **X,long nrl,long nrh, long ncl, long nch, sint64 y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_ui64matrix(uint64 **X,long nrl,long nrh, long ncl, long nch, uint64 y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulc_f32matrix(float32 **X,long nrl,long nrh, long ncl, long nch, float32 y, float32 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulc_f64matrix(float64 **X,long nrl,long nrh, long ncl, long nch, float64 y, float64 **Z)
/* ------------------------------------------------------------------------------------------------------ */
{
	long i,j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            Z[i][j] = X[i][j] * y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_rgb8matrix(rgb8 **X,long nrl,long nrh, long ncl, long nch, rgb8 y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgb8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGB8_MUL(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulc_rgbx8matrix(rgbx8 **X,long nrl,long nrh, long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
	long i,j;
    rgbx8 x, z;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
            x = X[i][j];
            RGBX8_MUL(x,y,z);
            Z[i][j] = z;
		}
	}
}
/* --------------- */
/* --- MulFrac --- */
/* --------------- */

// Y=(a*X)/b

/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_si8matrix(sint8 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, sint8 **Y)
/* -------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
            Y[i][j] = (sint8) y;
		}
	}
}
/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_ui8matrix(uint8 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, uint8 **Y)
/* -------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
			Y[i][j] = (uint8) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_si16matrix(sint16 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, sint16 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
            Y[i][j] = (sint16) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_ui16matrix(uint16 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, uint16 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
			Y[i][j] = (uint16) y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulfrac_si32matrix(sint32 **X, long nrl, long nrh, long ncl, long nch, int32  a, int32 b, sint32 **Y)
/* ------------------------------------------------------------------------------------------------------------------ */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
            Y[i][j] = (sint16) y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulfrac_ui32matrix(uint32 **X, long nrl, long nrh, long ncl, long nch, int32  a, int32 b, uint32 **Y)
/* ------------------------------------------------------------------------------------------------------------------ */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
			Y[i][j] = (uint16) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_si64matrix(sint64 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, sint64 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	sint64 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
            Y[i][j] = (sint64) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_ui64matrix(uint64 **X, long nrl, long nrh, long ncl, long nch, int32 a, int32 b, uint64 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	uint64 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) / b;
			Y[i][j] = (uint64) y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulfrac_rgb8matrix(rgb8 **X, long nrl,long nrh, long ncl, long nch, rgb32 a, rgb32 b, rgb8 **Y)
/* ------------------------------------------------------------------------------------------------------------ */
{
	int i, j;
	rgb32 y32;
	rgb8 x8, y8;

	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x8 = X[i][j];
			RGB8_MULFRAC(x8,a,b,y32);
			RGB32CAST8(y32,y8);
			Y[i][j] = y8;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulfrac_rgb8xmatrix(rgbx8 **X, long nrl,long nrh, long ncl, long nch, rgbx32 a, rgbx32 b, rgbx8 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	rgbx32 y32;
	rgbx8 x8, y8;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x8 = X[i][j];
			RGBX8_MULFRAC(x8,a,b,y32);
			RGBX32CAST8(y32,y8);
			Y[i][j] = y8;
		}
	}
}

/* ---------------- */
/* --- MulShift --- */
/* ---------------- */

// m3 = (a*m1)>>s

/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_si8matrix(sint8 **X, long nrl, long nrh,long ncl, long nch, int32 a, int32 s, sint8 **Y)
/* -------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (sint8) y;
		}
	}
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, int32  a, int32  s, uint8 **Y)
/* --------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (uint8) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_si16matrix(sint16 **X, long nrl, long nrh,long ncl, long nch, int32 a, int32 s, sint16 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (sint16) y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulshift_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, int32  a, int32  s, uint16 **Y)
/* ------------------------------------------------------------------------------------------------------------------ */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (uint16) y;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_si32matrix(sint32 **X, long nrl, long nrh,long ncl, long nch, int32 a, int32 s, sint32 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (sint32) y;
		}
	}
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) mulshift_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, int32  a, int32  s, uint32 **Y)
/* ------------------------------------------------------------------------------------------------------------------ */
{
	int i, j;
	int32 x, y;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x = X[i][j];
			y = (a * x) >> s;
			Y[i][j] = (uint32) y;
		}
	}
}
/* ---------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb32  a, rgb32  s, rgb8 **Y)
/* ---------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	rgb32 y32;
	rgb8 x8, y8;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x8 = X[i][j];
			RGB8_MULSHIFT(x8,a,s,y32);
			RGB32CAST8(y32,y8);
			Y[i][j] = y8;
		}
	}
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) mulshift_rgbx8matrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx32 a, rgbx32 s, rgbx8 **Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
	int i, j;
	rgbx32 y32;
	rgbx8 x8, y8;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			x8 = X[i][j];
			RGBX8_MULSHIFT(x8,a,s,y32);
			RGBX32CAST8(y32,y8);
			Y[i][j] = y8;
		}
	}
}
