/* ----------------- */
/* --- palette.h --- */
/* ----------------- */

/*
 * Copyright (c) 1997 Lionel Lacassagne EIA
 * Copyright (c) 2001 Lionel Lacassagne PARC-LIS-UPMC (Paris6)
 * Init 98-03-04
 * Modif : 98-06-09 : ajout des demi-palettes n-colors + gray
 *                    PackGrayLower PackGrayUpper
 * modif : 01-01-30 : integration into Foundation
 *                    Note that return code have been added without testing (right now)

 */

/*
 * Redefinition de RGBQUAD en RGBQuad, permet de ne pas inclure les .h de windows partout
 */

#ifndef __PALETTE_H__
#define __PALETTE_H__

#ifdef __cplusplus
#ifdef PRAGMA_VERBOSE
//#pragma message ("C++")
MESSAGE("C++")
#endif
extern "C" {
#endif

#ifdef PRAGMA_VERBOSE
#pragma message ("- include palette.h")
/MESSAGE("- include palette.h")
#endif

typedef struct {
  uint8 blue;
  uint8 green;
  uint8 red;
  uint8 reserved;
} RGBQuad;       /* must be zero */
// RGBQuad redefinition for windows independance

#ifdef _WINDOWS_
#pragma message("_WINDOWS_ is defined")
//MESSAGE("_WINDOWS_ is defined")
#endif

#ifdef _WINGDI_
#pragma message("_WINGDI_ is defined")
//MESSAGE("_WINGDI_ is defined")
#endif

#if (!defined(WIN32) && !defined(_WINDOWS_) && !defined(_WINGDI_))
//#pragma message("palette.h no WINDOWS echo")
//MESSAGE("palette.h no WINDOWS echo")

typedef  struct {
  byte rgbBlue;
  byte rgbGreen;
  byte rgbRed;
  byte rgbReserved;
} RGBQUAD;
#endif

typedef RGBQuad PaletteRGB256;

IMAGE_EXPORT(void) Palette_Display(RGBQuad *palette);
//IMAGE_EXPORT(void) Palette_Save   (RGBQuad *palette,        char *filename);
//IMAGE_EXPORT(void) Palette_SaveSub(RGBQuad *palette, int n, char *filename);
IMAGE_EXPORT(void) Palette_GrayBlue2Red(RGBQuad *palette);
/*
 *   0..127 niveaux de gris
 * 128..255 blue -> rouge
 */
IMAGE_EXPORT(void) Palette_Gray   (RGBQuad *palette);
IMAGE_EXPORT(void) Palette_Classic(RGBQuad *palette);
/*
 * niveaux de gris
 */
IMAGE_EXPORT(void) Palette_Pseudo1   (RGBQuad *palette);
IMAGE_EXPORT(void) Palette_Pseudo2   (RGBQuad *palette);

IMAGE_EXPORT(void) Palette_Hue        (RGBQuad *palette); // jolie palette
IMAGE_EXPORT(void) Palette_HueBW      (RGBQuad *palette); // jolie palette
IMAGE_EXPORT(void) Palette_RandomHue  (RGBQuad *palette); // jolie palette
IMAGE_EXPORT(void) Palette_RandomHueBW(RGBQuad *palette); // jolie palette

/* --- palettes cycliques --- */
IMAGE_EXPORT(void) Palette_2Colors (RGBQuad *palette);  // palette binaire pour PNG
IMAGE_EXPORT(void) Palette_4Colors (RGBQuad *palette);  // palette binaire pour PNG en cours
IMAGE_EXPORT(void) Palette_16Colors(RGBQuad *palette);  // palette binaire pour PNG en cours

IMAGE_EXPORT(void) Palette_3Colors   (RGBQuad *palette); /* cycle a  3 couleurs */
IMAGE_EXPORT(void) Palette_6Colors   (RGBQuad *palette); /* cycle a  6 couleurs */
IMAGE_EXPORT(void) Palette_18Colors  (RGBQuad *palette); /* cycle a 18 couleurs */

IMAGE_EXPORT(void) Palette_3Colors_Red (RGBQuad *palette); /* cycle a  3-1 couleurs - rouge (palette[0] = rouge) */
IMAGE_EXPORT(void) Palette_6Colors_Red (RGBQuad *palette); /* cycle a  6-1 couleurs - rouge (palette[0] = rouge)*/
IMAGE_EXPORT(void) Palette_18Colors_Red(RGBQuad *palette); /* cycle a 18-1 couleurs - rouge (palette[0] = rouge)*/

IMAGE_EXPORT(void) Palette_3ColorsBW (RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_6ColorsBW (RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_18ColorsBW(RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_64ColorsBW(RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_256ColorsBW(RGBQuad *palette); /* + Black & White */

IMAGE_EXPORT(void) Palette_18ColorsBW_Red         (RGBQuad *palette);
IMAGE_EXPORT(void) Palette_18ColorsBW_RedGreenBlue(RGBQuad *palette);
/* --- palettes cycliques + gris --- */

IMAGE_EXPORT(void) Palette_3ColorsGray   (RGBQuad *palette); /* cycle a  3 couleurs [0..127] + gris [128..255] */
IMAGE_EXPORT(void) Palette_6ColorsGray   (RGBQuad *palette); /* cycle a  6 couleurs [0..127] + gris [128..255] */
IMAGE_EXPORT(void) Palette_18ColorsGray  (RGBQuad *palette); /* cycle a 18 couleurs [0..127] + gris [128..255] */

IMAGE_EXPORT(void) Palette_3ColorsGrayBW (RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_6ColorsGrayBW (RGBQuad *palette); /* + Black & White */
IMAGE_EXPORT(void) Palette_18ColorsGrayBW(RGBQuad *palette); /* + Black & White */

//IMAGE_EXPORT(void) Palette_PackGrayLower(Image *src, Lut *lut, Image *dst);
//IMAGE_EXPORT(void) Palette_PackGrayUpper(Image *src, Lut *lut, Image *dst);

#ifdef __cplusplus
}
#endif

#endif /* __PALETTE_H__ */
