/* ----------------- */
/* --- nrbool2.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_BOOL2_H_
#define _NR_BOOL2_H_

#ifdef __cplusplus
#ifdef PRAGMA_VERBOSE
#pragma message ("C++")
#endif
extern "C" {
#endif

#ifdef PRAGMA_VERBOSE
//#pragma message("- include nrbool2.h")
#endif

IMAGE_EXPORT(int) cmpeq_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y);
IMAGE_EXPORT(int) cmpeq_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y);
IMAGE_EXPORT(int) cmpeq_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 **Y);
IMAGE_EXPORT(int) cmpeq_si16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y);
IMAGE_EXPORT(int) cmpeq_ui16matrix(uint16 **X, long nrl, long nrh, long ncl, long nch, uint16 **Y);
IMAGE_EXPORT(int) cmpeq_si32matrix(sint32 **X, long nrl, long nrh, long ncl, long nch, sint32 **Y);
IMAGE_EXPORT(int) cmpeq_ui32matrix(uint32 **X, long nrl, long nrh, long ncl, long nch, uint32 **Y);


/*
 * -----------
 * --- Not ---
 * -----------
 */

IMAGE_EXPORT(void) not_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   **Y);
IMAGE_EXPORT(void) not_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  **Y);
IMAGE_EXPORT(void) not_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  **Y);
IMAGE_EXPORT(void) not_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y);
IMAGE_EXPORT(void) not_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y);
IMAGE_EXPORT(void) not_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y);
IMAGE_EXPORT(void) not_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y);
IMAGE_EXPORT(void) not_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y);
IMAGE_EXPORT(void) not_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y);
IMAGE_EXPORT(void) not_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   **Y);
IMAGE_EXPORT(void) not_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  **Y);

/*
 * ----------
 * --- Or ---
 * ----------
 */

IMAGE_EXPORT(void) or_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   **Y, byte    **Z);
IMAGE_EXPORT(void) or_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  **Y, sint8   **Z);
IMAGE_EXPORT(void) or_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  **Y, uint8   **Z);
IMAGE_EXPORT(void) or_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16  **Z);
IMAGE_EXPORT(void) or_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16  **Z);
IMAGE_EXPORT(void) or_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32  **Z);
IMAGE_EXPORT(void) or_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32  **Z);
IMAGE_EXPORT(void) or_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64  **Z);
IMAGE_EXPORT(void) or_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64  **Z);
IMAGE_EXPORT(void) or_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   **Y, rgb8    **Z);
IMAGE_EXPORT(void) or_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  **Y, rgbx8   **Z);

IMAGE_EXPORT(void) orc_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   y, byte    **Z);
IMAGE_EXPORT(void) orc_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  y, sint8   **Z);
IMAGE_EXPORT(void) orc_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  y, uint8   **Z);
IMAGE_EXPORT(void) orc_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16  **Z);
IMAGE_EXPORT(void) orc_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16  **Z);
IMAGE_EXPORT(void) orc_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32  **Z);
IMAGE_EXPORT(void) orc_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32  **Z);
IMAGE_EXPORT(void) orc_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64  **Z);
IMAGE_EXPORT(void) orc_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64  **Z);
IMAGE_EXPORT(void) orc_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   y, rgb8    **Z);
IMAGE_EXPORT(void) orc_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  y, rgbx8   **Z);

/*
 * -----------
 * --- Xor ---
 * -----------
 */

IMAGE_EXPORT(void) xor_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   **Y, byte    **Z);
IMAGE_EXPORT(void) xor_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  **Y, sint8   **Z);
IMAGE_EXPORT(void) xor_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  **Y, uint8   **Z);
IMAGE_EXPORT(void) xor_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16  **Z);
IMAGE_EXPORT(void) xor_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16  **Z);
IMAGE_EXPORT(void) xor_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32  **Z);
IMAGE_EXPORT(void) xor_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32  **Z);
IMAGE_EXPORT(void) xor_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64  **Z);
IMAGE_EXPORT(void) xor_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64  **Z);
IMAGE_EXPORT(void) xor_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   **Y, rgb8    **Z);
IMAGE_EXPORT(void) xor_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  **Y, rgbx8   **Z);

IMAGE_EXPORT(void) xorc_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   y, byte    **Z);
IMAGE_EXPORT(void) xorc_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  y, sint8   **Z);
IMAGE_EXPORT(void) xorc_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  y, uint8   **Z);
IMAGE_EXPORT(void) xorc_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16  **Z);
IMAGE_EXPORT(void) xorc_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16  **Z);
IMAGE_EXPORT(void) xorc_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32  **Z);
IMAGE_EXPORT(void) xorc_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32  **Z);
IMAGE_EXPORT(void) xorc_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64  **Z);
IMAGE_EXPORT(void) xorc_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64  **Z);
IMAGE_EXPORT(void) xorc_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   y, rgb8    **Z);
IMAGE_EXPORT(void) xorc_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  y, rgbx8   **Z);

/*
 * -----------
 * --- And ---
 * -----------
 */

IMAGE_EXPORT(void) and_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   **Y, byte    **Z);
IMAGE_EXPORT(void) and_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  **Y, sint8   **Z);
IMAGE_EXPORT(void) and_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  **Y, uint8   **Z);
IMAGE_EXPORT(void) and_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16  **Z);
IMAGE_EXPORT(void) and_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16  **Z);
IMAGE_EXPORT(void) and_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32  **Z);
IMAGE_EXPORT(void) and_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32  **Z);
IMAGE_EXPORT(void) and_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64  **Z);
IMAGE_EXPORT(void) and_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64  **Z);
IMAGE_EXPORT(void) and_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   **Y, rgb8    **Z);
IMAGE_EXPORT(void) and_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  **Y, rgbx8   **Z);

IMAGE_EXPORT(void) andc_bmatrix    (byte   **X, long nrl,long nrh,long ncl, long nch, byte   y, byte    **Z);
IMAGE_EXPORT(void) andc_si8matrix  (sint8  **X, long nrl,long nrh,long ncl, long nch, sint8  y, sint8   **Z);
IMAGE_EXPORT(void) andc_ui8matrix  (uint8  **X, long nrl,long nrh,long ncl, long nch, uint8  y, uint8   **Z);
IMAGE_EXPORT(void) andc_si16matrix (sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16  **Z);
IMAGE_EXPORT(void) andc_ui16matrix (uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16  **Z);
IMAGE_EXPORT(void) andc_si32matrix (sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32  **Z);
IMAGE_EXPORT(void) andc_ui32matrix (uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32  **Z);
IMAGE_EXPORT(void) andc_si64matrix (sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64  **Z);
IMAGE_EXPORT(void) andc_ui64matrix (uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64  **Z);
IMAGE_EXPORT(void) andc_rgb8matrix (rgb8   **X, long nrl,long nrh,long ncl, long nch, rgb8   y, rgb8    **Z);
IMAGE_EXPORT(void) andc_rgbx8matrix(rgbx8  **X, long nrl,long nrh,long ncl, long nch, rgbx8  y, rgbx8   **Z);

#ifdef __cplusplus
}
#endif

#endif // _NR_BOOL2_H_
