/* ----------------- */
/* --- nrbool2.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrbool1.h"
#include "nrbool2.h"

/* ----------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y)
/* ----------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* --------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y)
/* --------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_ui8matrix(uint8 **X, long nrl, long nrh, long ncl, long nch, uint8 **Y)
/* ----------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_si16matrix(sint16 **X, long nrl ,long nrh, long ncl, long nch, sint16 **Y)
/* -------------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_ui16matrix(uint16 **X, long nrl, long nrh, long ncl, long nch, uint16 **Y)
/* -------------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_si32matrix(sint32 **X, long nrl, long nrh, long ncl, long nch, sint32 **Y)
/* -------------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(int) cmpeq_ui32matrix(uint32 **X, long nrl, long nrh, long ncl, long nch, uint32 **Y)
/* -------------------------------------------------------------------------------------------- */
{
	int i, j;
	
	for(i=nrl; i<=nrh; i++) {
		for(j=ncl; j<=nch; j++) {
			if(X[i][j] != Y[i][j]) return 1;
		}
	}
	return 0;
}

/*
 * -----------
 * --- Not ---
 * -----------
 */

/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y)
/* ---------------------------------------------------------------------------------- */
{
	long i;
	
	for(i=nrl; i<=nrh; i++) {
		not_bvector(X[i], ncl, nch, Y[i]);
	}
}
/* -------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y)
/* -------------------------------------------------------------------------------------- */
{
	long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_si8vector(X[i], ncl, nch, Y[i]);
    }
}
/* -------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 **Y)
/* -------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_ui8vector(X[i], ncl, nch, Y[i]);
    }
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y)
/* ----------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_si16vector(X[i], ncl, nch, Y[i]);
    }
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y)
/* ----------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_ui16vector(X[i], ncl, nch, Y[i]);
    }
}
/* ---------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_si32matrix(int32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y)
/* ---------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_si32vector(X[i], ncl, nch, Y[i]);
    }
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y)
/* ----------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_ui32vector(X[i], ncl, nch, Y[i]);
    }
}
/* --------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) not_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y)
/* --------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_rgb8vector(X[i], ncl, nch, Y[i]);
    }
}
/* ------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) not_rgbx8matrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y)
/* ------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        not_rgbx8vector(X[i], ncl, nch, Y[i]);
    }
}

/*
 * ----------
 * --- Or ---
 * ----------
 */

/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y, byte **Z)
/* ------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_bvector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) or_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_si8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) or_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 **Y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_ui8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_si16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_ui16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_si32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_ui32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_si64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_ui64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_rgb8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) or_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        or_rgbx8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) orc_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte y, byte **Z)
/* ------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_bvector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 y, sint8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_si8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 y, uint8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_ui8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_i16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_si16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_ui16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_si32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_ui32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_si64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64 **Z)

/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_ui64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 y, rgb8 **Z)
/* --------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_rgb8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) orc_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* ------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        orc_rgbx8vector(X[i], ncl, nch, y, Z[i]);
    }
}

/*
 * -----------
 * --- Xor ---
 * -----------
 */

/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y, byte **Z)
/* -------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_bvector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_si8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 **Y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_ui8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_si16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_ui16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_si32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_ui32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_si64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_ui64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y, rgb8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_rgb8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xor_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y, rgbx8 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xor_rgbx8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte y, byte **Z)
/* ------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_bvector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) xorc_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_si8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) xorc_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_ui8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_i16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_si16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_ui16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_si32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_ui32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_si64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_ui64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_rgb8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) xorc_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        xorc_rgbx8vector(X[i], ncl, nch, y, Z[i]);
    }
}


/*
 * ----------
 * --- And ---
 * ----------
 */

/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte **Y, byte **Z)
/* -------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_bvector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 **Y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_si8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 **Y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_ui8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 **Y, sint16 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_si16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 **Y, uint16 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_ui16vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 **Y, sint32 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_si32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 **Y, uint32 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_ui32vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 **Y, sint64 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_si64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 **Y, uint64 **Z)
/* ----------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_ui64vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 **Y, rgb8 **Z)
/* ----------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_rgb8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) and_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 **Y, rgbx8 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        and_rgbx8vector(X[i], ncl, nch, Y[i], Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_bmatrix(byte **X, long nrl,long nrh,long ncl, long nch, byte y, byte **Z)
/* ------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_bvector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) andc_si8matrix(sint8 **X, long nrl,long nrh,long ncl, long nch, sint8 y, sint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_si8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) andc_ui8matrix(uint8 **X, long nrl,long nrh,long ncl, long nch, uint8 y, uint8 **Z)
/* ------------------------------------------------------------------------------------------------ */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_ui8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* --------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_i16matrix(sint16 **X, long nrl,long nrh,long ncl, long nch, sint16 y, sint16 **Z)
/* --------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_si16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui16matrix(uint16 **X, long nrl,long nrh,long ncl, long nch, uint16 y, uint16 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_ui16vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si32matrix(sint32 **X, long nrl,long nrh,long ncl, long nch, sint32 y, sint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_si32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui32matrix(uint32 **X, long nrl,long nrh,long ncl, long nch, uint32 y, uint32 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_ui32vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_si64matrix(sint64 **X, long nrl,long nrh,long ncl, long nch, sint64 y, sint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_si64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_ui64matrix(uint64 **X, long nrl,long nrh,long ncl, long nch, uint64 y, uint64 **Z)
/* ---------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_ui64vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* ---------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_rgb8matrix(rgb8 **X, long nrl,long nrh,long ncl, long nch, rgb8 y, rgb8 **Z)
/* ---------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_rgb8vector(X[i], ncl, nch, y, Z[i]);
    }
}
/* -------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) andc_rgb8xmatrix(rgbx8 **X, long nrl,long nrh,long ncl, long nch, rgbx8 y, rgbx8 **Z)
/* -------------------------------------------------------------------------------------------------- */
{
    long i;
    
    for(i=nrl; i<=nrh; i++) {
        andc_rgbx8vector(X[i], ncl, nch, y, Z[i]);
    }
}
