/* --------------- */
/* --- nrio2.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nralloc2.h"
#include "nrio0.h"
#include "nrio1.h"
#include "nrio2.h"

/*
 * ----------------------
 * --- display_matrix ---
 * ----------------------
 */

/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8matrix(uint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8matrix(sint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16matrix(sint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16matrix(uint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si32matrix(sint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix(uint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si64matrix(sint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* --------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix(uint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32matrix(float32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f64matrix(float64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8matrix(rgb8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgbx8matrix(rgbx8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(i=nrl; i<=nrh; i++) {
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
}
/*
 * ----------------------
 * --- display_matrix ---
 * ----------------------
 */

/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8matrix_T(sint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8matrix_T(uint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si16matrix_T(sint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui16matrix_T(uint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si32matrix_T(sint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix_T(uint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si64matrix_T(sint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui64matrix_T(uint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f32matrix_T(float32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f64matrix_T(float64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j]);
        }
        printf("\n");
    }
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8matrix_T(rgb8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_rgbx8matrix_T(rgbx8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
    long i,j;
    
    if(name != NULL) printf(name);
    
    for(j=ncl; j<=nch; j++) {
        for(i=nrl; i<=nrh; i++) {           
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
}

/*
 * ------------------------
 * --- display_matrix_T ---
 * ------------------------
 */

/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8matrix_number(sint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8matrix_number(uint8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16matrix_number(sint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16matrix_number(uint16 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si32matrix_number(sint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix_number(uint32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si64matrix_number(sint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui64matrix_number(uint64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32matrix_number(float32 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f64matrix_number(float64 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8matrix_number(rgb8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
    printf("\n");
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgbx8matrix_number(rgbx8 **m,long nrl,long nrh,long ncl, long nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    int i,j;
    
    if(name != NULL) printf(name);
    
    // 1ere ligne
    printf("%5c", '#');
    for(j=ncl; j<=nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for(i=nrl; i<=nrh; i++) {
        printf("[%3d]", i);
        for(j=ncl; j<=nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
    printf("\n");
}

/*
 * -------------------------------
 * --- display_matrix_positive ---
 * -------------------------------
 */

// ------------------------------------------------------------------------------------------------
void display_si8matrix_positive(sint8 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// ------------------------------------------------------------------------------------------------
{
    int i, j;
    
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// ------------------------------------------------------------------------------------------------
void display_ui8matrix_positive(uint8 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// ------------------------------------------------------------------------------------------------
{
    int i, j;
    
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_si16matrix_positive(sint16 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_ui16matrix_positive(uint16 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_si32matrix_positive(sint32 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_ui32matrix_positive(uint32 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_si64matrix_positive(sint64 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
// --------------------------------------------------------------------------------------------------
void display_ui64matrix_positive(uint64 **m, int i0, int i1, int j0, int j1, int iformat, char *name)
// --------------------------------------------------------------------------------------------------
{
    int i, j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        for(j=j0; j<=j1; j++) {
            if(m[i][j]) {
                printf(format, m[i][j]);
            } else {
                printf("%s", str);
            }
        }
        printf("\n");
    }    
}
