/* ---------------- */
/* --- nrset2.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset1.h"
#include "nrset2.h"

/*
 * ------------
 * --- Zero ---
 * ------------
 */

/* ---------------------------------------------------------------------- */
IMAGE_EXPORT(void) zero_si8matrix(sint8 **m, int i0, int i1, int j0, int j1)
/* ---------------------------------------------------------------------- */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_si8vector(m[i], j0, j1);
    }
}
/* ---------------------------------------------------------------------- */
IMAGE_EXPORT(void) zero_ui8matrix(uint8 **m, int i0, int i1, int j0, int j1)
/* ---------------------------------------------------------------------- */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_ui8vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_si16matrix(sint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_si16vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_ui16matrix(uint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_ui16vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_si32matrix(sint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_si32vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_ui32matrix(uint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_ui32vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_si64matrix(sint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_si64vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_ui64matrix(uint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_ui64vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_f32matrix(float32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_f32vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_f64matrix(float64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_f64vector(m[i], j0, j1);
    }
}
/* ---------------------------------------------------------------------- */
IMAGE_EXPORT(void) zero_rgb8matrix(rgb8 **m, int i0, int i1, int j0, int j1)
/* ---------------------------------------------------------------------- */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_rgb8vector(m[i], j0, j1);
    }
}
/* ------------------------------------------------------------------------ */
IMAGE_EXPORT(void) zero_rgbx8matrix(rgbx8 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------ */
{
	int i;
    for(i=i0; i<=i1; i++) {
        zero_rgbx8vector(m[i], j0, j1);
    }
}
/*
 * ------------------
 * --- set_matrix ---
 * ------------------
 */

/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_si8matrix(sint8 **m, int i0, int i1, int j0, int j1, sint8 x)
/* ------------------------------------------------------------------------------ */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_si8vector(m[i], j0, j1, x);
}
/* ------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_ui8matrix(uint8 **m, int i0, int i1, int j0, int j1, uint8 x)
/* ------------------------------------------------------------------------------ */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_ui8vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16matrix(sint16 **m, int i0, int i1, int j0, int j1, sint16 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_si16vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16matrix(uint16 **m, int i0, int i1, int j0, int j1, uint16 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_ui16vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32matrix(sint32 **m, int i0, int i1, int j0, int j1, sint32 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_si32vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32matrix(uint32 **m, int i0, int i1, int j0, int j1, uint32 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_ui32vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32matrix(float32 **m, int i0, int i1,int j0, int j1, float32 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_f32vector(m[i], j0, j1, x);
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64matrix(float64 **m,int i0, int i1, int j0, int j1, float64 x)
/* --------------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_f64vector(m[i], j0, j1, x);
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8matrix(rgb8 **m,int i0, int i1, int j0, int j1, rgb8 x)
/* ---------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_rgb8vector(m[i], j0, j1, x);
}
/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8matrix(rgbx8 **m,int i0,int i1,int j0, int j1, rgbx8 x)
/* ----------------------------------------------------------------------------- */
{
	int i;
	for(i=i0; i<=i1; i++)
		set_rgbx8vector(m[i], j0, j1, x);
}
/*
 * ----------------
 * set_matrix_param
 * ----------------
 */
/* ------------------------------------------------------------------------------------------------ */
void set_ui8matrix_param(uint8 **m, int i0, int i1, int j0, int j1, uint8 x, uint8 xstep, uint8 ystep)
/* ------------------------------------------------------------------------------------------------ */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_ui8vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* -------------------------------------------------------------------------------------------------- */
void set_si8matrix_param(sint8 **m, int i0, int i1, int j0, int j1, sint8 x, sint8 xstep, sint8 ystep)
/* -------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_si8vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_ui16matrix_param(uint16 **m, int i0, int i1, int j0, int j1, uint16 x, uint16 xstep, uint16 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_ui16vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_si16matrix_param(sint16 **m, int i0, int i1, int j0, int j1, sint16 x, sint16 xstep, sint16 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_si16vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_ui32matrix_param(uint32 **m, int i0, int i1, int j0, int j1, uint32 x, uint32 xstep, uint32 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_ui32vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_si32matrix_param(sint32 **m, int i0, int i1, int j0, int j1, sint32 x, sint32 xstep, sint32 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_si32vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_ui64matrix_param(uint64 **m, int i0, int i1, int j0, int j1, uint64 x, uint64 xstep, uint64 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_ui64vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* ----------------------------------------------------------------------------------------------------- */
void set_si64matrix_param(sint64 **m, int i0, int i1, int j0, int j1, sint64 x, sint64 xstep, sint64 ystep)
/* ----------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_si64vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* -------------------------------------------------------------------------------------------------------- */
void set_f32matrix_param(float32 **m, int i0, int i1, int j0, int j1, float32 x, float32 xstep, float32 ystep)
/* -------------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_f32vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* -------------------------------------------------------------------------------------------------------- */
void set_f64matrix_param(float64 **m, int i0, int i1, int j0, int j1, float64 x, float64 xstep, float64 ystep)
/* -------------------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_f64vector_param(m[i], j0, j1, x, xstep);
        x += ystep;
    }
}
/* --------------------------------------------------------------------------------------------- */
void set_rgb8matrix_param(rgb8 **m, int i0, int i1, int j0, int j1, rgb8 x, rgb8 xstep, rgb8 ystep)
/* --------------------------------------------------------------------------------------------- */
{
    int i;
    for(i=i0; i<=i1; i++) {
        set_rgb8vector_param(m[i], j0, j1, x, xstep);
        x.r += ystep.r;
        x.g += ystep.g;
        x.b += ystep.b;
    }
}
/* -------------------------------------------------------------------------------------------------- */
void set_rgbx8matrix_param(rgbx8 **m, int i0, int i1, int j0, int j1, rgbx8 x, rgbx8 xstep, rgbx8 ystep)
/* -------------------------------------------------------------------------------------------------- */
{
    int i;
    
    x.x = 0;
    for(i=i0; i<=i1; i++) {
        set_rgbx8vector_param(m[i], j0, j1, x, xstep);
        x.r += ystep.r;
        x.g += ystep.g;
        x.b += ystep.b;
		x.x += ystep.x;
    }
}
/*
 * --------------------
 * --- set_matrix_i ---
 * --------------------
 */
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8matrix_i(sint8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    set_si8matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8matrix_i(uint8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    set_ui8matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16matrix_i(sint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si16matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16matrix_i(uint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui16matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32matrix_i(sint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si32matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32matrix_i(uint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui32matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si64matrix_i(sint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si64matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui64matrix_i(uint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui64matrix_param(m, i0, i1, j0, j1, i0,0, 1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32matrix_i(float32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_f32matrix_param(m, i0, i1, j0, j1, (float32) i0, (float32)0, (float32)1);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64matrix_i(float64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_f64matrix_param(m, i0, i1, j0, j1, i0,(float64)0, (float64)1);
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8matrix_i(rgb8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    rgb8 x0, xstep, ystep;

    x0.r    = x0.g    = x0.b    = i0;
    xstep.r = xstep.g = xstep.b = 0;
    ystep.r = ystep.g = ystep.b = 1;

    set_rgb8matrix_param(m, i0, i1, j0, j1, x0, xstep, ystep);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8matrix_i(rgbx8 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    rgbx8 x, xstep, ystep;

    x.r     = x.g     = x.b     = i0; x.x     = 255;
    xstep.r = xstep.g = xstep.b = 0;  xstep.x = 255;
    ystep.r = ystep.g = ystep.b = 1;  ystep.x = 255;

    set_rgbx8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}
/*
 * --------------------
 * --- set_matrix_j ---
 * --------------------
 */
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8matrix_j(sint8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    set_si8matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8matrix_j(uint8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    set_ui8matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16matrix_j(sint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si16matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16matrix_j(uint16 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui16matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32matrix_j(sint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si32matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32matrix_j(uint32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui32matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si64matrix_j(sint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_si64matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui64matrix_j(uint64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_ui64matrix_param(m, i0, i1, j0, j1, j0, 1, 0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32matrix_j(float32 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_f32matrix_param(m, i0, i1, j0, j1, (float32)j0,(float32)1, (float32)0);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64matrix_j(float64 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    set_f64matrix_param(m, i0, i1, j0, j1, j0,(float64)1, (float64)0);
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8matrix_j(rgb8 **m, int i0, int i1, int j0, int j1)
/* ----------------------------------------------------------------------- */
{
    rgb8 x, xstep, ystep;

    x.r     = x.g     = x.b    = j0;
    xstep.r = xstep.g = xstep.b = 1;
    ystep.r = ystep.g = ystep.b = 0;

    set_rgb8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}
/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8matrix_j(rgbx8 **m, int i0, int i1, int j0, int j1)
/* ------------------------------------------------------------------------- */
{
    rgbx8 x, xstep, ystep;

    x.r     = x.g     = x.b     = j0; x.x     = 255;
    xstep.r = xstep.g = xstep.b = 1;  xstep.x = 255;
    ystep.r = ystep.g = ystep.b = 0;  ystep.x = 255;

    set_rgbx8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}/*
 * --------------
 * --- autres ---
 * --------------
 */
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_ui8matrix_border1(uint8 **m,int i0, int i1, int j0, int j1, uint8 x)
/* ------------------------------------------------------------------------------------- */
{
	int i;
	
	set_ui8vector(m[i0], j0, j1, x);
	
	for(i=i0+1; i<=i1-1; i++) {
		m[i][j0] = x;
		m[i][j1] = x;
	}
	
	set_ui8vector(m[i0], j0, j1, x);
}
/* --------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8matrix_border(uint8 **m,int i0,int i1,int j0, int j1, int n, uint8 x)
/* --------------------------------------------------------------------------------------- */
{
	int i, j;
	uint8 *Xi=NULL;
	
	for(i=i0; i<i0+n; i++) {
		Xi = m[i];
		for(j=j0; j<=j1; j++) {
			Xi[j] = x;
		}
	}
	
	for(i=i0+n; i<i1; i++) {
		Xi = m[i];
		for(j=0; j<n; j++) {
			Xi[j0+j] = x;
			Xi[j1-j] = x;
		}
	}
	
	for(i=i1-n+1; i<=i1; i++) {
		Xi = m[i];
		for(j=j0; j<=j1; j++) {
			Xi[j] = x;
		}
	}
}
