// -------------------- //
// --- ecc_features --- //
// -------------------- //


/*
 * Copyright (c) 2012 - 2014, Lionel Lacassagne, All rights reserved
 * University of Paris Sud, Laboratoire de Recherche en Informatique 
 */

//
// Caracteristiques d'une region / label
//

#ifndef __ECC_FEATURES_H__
#define __ECC_FEATURES_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef VERBOSE_PRAGMA
//#pragma message("- include ecc_features.h")
#endif

#define REGION_STATS1

//#define REGION_STATS2
//#define REGION_STATS3
//#define REGION_STATS4

#define Warning 
#define Error 

// ------------------------------------------------------------------------
// --- RegionStats --------------------------------------------------------
// ------------------------------------------------------------------------

typedef struct {

  uint16  xmin;
  uint16  xmax;
  uint16  ymin;
  uint16  ymax;

  uint32  S;

  uint16  x;       // abscisse du centre d'inertie x = Sx / S
  uint16  y;       // ordonnee du centre d'inertie y = Sy / S

  uint32  Sx;
  uint32  Sy;

#ifdef REGION_STATS2
  //uint64  Sx2;
  //uint64  Sxy;
  //uint64  Sy2;

  //uint32  Mx2;
  //uint32  Mxy;
  //uint32  My2;

  double teta; // direction principale
#endif

#ifdef REGION_STATS3
  //uint64  Sx3;
  //uint64  Sx2y;
  //uint64  Sxy2;
  //uint64  Sy3;

  //uint64  Mx3;
  //uint64  Mx2y;
  //uint64  Mxy2;
  //uint64  My3;
#endif
} RegionStats;


/*
 * ATTENTION x != (xmin+xmax)/2
 *           y != (ymin+ymax)/2
             S != (xmax-xmin)(ymax-ymin)
 */

/*
 * n = S = phi0(x1) - phi0(x0-1) = x1 - x0 + 1
 * Sx    = phi1(x1) - phi1(x0-1)
 * Sx2   = phi2(x1) - phi2(x0-1)
 * Sx3   = phi3(x1) - phi3(x0-1)
 * Sy    = nY
 * Sy2   = nY2
 * Sxy   = Y.Sx
 * Sx2y  = Y.Sx2
 * Sxy2  = Y2.Sx
 * Sy3   = nY3
 *
 * phi1(x  ) = x(x+1)/2
 * phi1(x-1) = x(x-1)/2
 * phi2(x  ) = x(x+1)(2x+1)/6
 * phi2(x-1) = x(x-1)(2x-1)/6
 * phi3(x  ) = Phi1(x).Phi1(x)
 * 
 * Mx2 = Sx2 - Sx.Sx / n
 * My2 = Sy2 - Sy.Sy / n
 * Mxy = Sxy - Sx.Sy / n
 *
 * Mx3  = Sx3  - 3.Sx.Sx2 / n + 2.Sx.Sx.Sx / n2
 * Mx2y = Sx2y - Sx2.Sy / n - 2.Sx.Sxy / n + 2.Sx.Sx.Sy / n2
 * Mxy2 = Sxy2 - Sy2.Sx / n - 2.Sy.Sxy / n + 2.Sx.Sy.Sy / n2
 * My3  = Sy3  - 3.Sy.Sy2 / n + 2.Sy.Sy.Sy / n2
 */

/* ------------------------------ */
/* --- RegionStats after 2009 --- */
/* ------------------------------ */
// pas mieux que les fonctions precedentes -> a supprimer a terme (LL 2014)

RegionStats* RegionStatsVector                 (int i0, int i1);
RegionStats* RegionStatsVector0                (int i0, int i1);
void    free_RegionStatsVector (RegionStats *v, int i0, int i1);

RegionStats** RegionStatsMatrix                 (int i0, int i1, int j0, int j1);
RegionStats** RegionStatsMatrix0                (int i0, int i1, int j0, int j1);
void     free_RegionStatsMatrix(RegionStats **m, int i0, int i1, int j0, int j1);

void zero_RegionStats      (RegionStats  *x);
void zero_RegionStatsVector(RegionStats  *v, int i0, int i1);
void zero_RegionStatsMatrix(RegionStats **m, int i0, int i1, int j0, int j1);

void display_RegionStats      (RegionStats  *x,                                 char *name);
void display_RegionStatsVector(RegionStats  *v, int i0, int i1,                 char *name);
void display_RegionStatsMatrix(RegionStats **m, int i0, int i1, int j0, int j1, char *name);

void save_RegionStats      (RegionStats *x,                                  char *name);
void save_RegionStatsVector(RegionStats  *v, int i0, int i1,                 char *name);
void save_RegionStatsMatrix(RegionStats **m, int i0, int i1, int j0, int j1, char *name);

/* ----------------------------------------- */
/* --- RegionStats functions before 2009 --- */
/* ----------------------------------------- */

void         RegionStats_Constructor (RegionStats **Stats, uint32 nemax);
RegionStats* RegionStats_pConstructor(                     uint32 nemax);
void         RegionStats_Destructor  (RegionStats **Stats, uint32 nemax);
void         RegionStats_pDestructor (RegionStats  *Stats, uint32 nemax);
void         RegionStats_Clear       (RegionStats  *Stats, uint32 nemax);

int  RegionStats_Create_File (char *filename); // for read
int  RegionStats_Open_File  (char *filename); // for write
void RegionStats_Close_File (int fd);

int  RegionStats_Read_Header (        int fd); // return ne
void RegionStats_Write_Header(int ne, int fd);

void RegionStats_Read_Stats1 (int fd, int ne, RegionStats *stats);
void RegionStats_Read_Stats2 (int fd, int ne, RegionStats *stats);

void RegionStats_Write_Stats1(RegionStats *Stats, int ne, int fd);
void RegionStats_Write_Stats2(RegionStats *Stats, int ne, int fd);
    
void RegionStats_Write_Stats1_Sparse(RegionStats *Stats, uint32 *EQ, uint32 ne0, uint32 ne1, int fd);

void RegionStats_Load_Stats1 (char *filename, int *ne, RegionStats **Stats); 
void RegionStats_Load_Stats2 (char *filename, int *ne, RegionStats **Stats); 
            
void RegionStats_MLoad_Stats1(char *filename, int *ne, RegionStats  *Stats); // Stats must have been allocated
void RegionStats_MLoad_Stats2(char *filename, int *ne, RegionStats  *Stats); // Stats must have been allocated

void RegionStats_Save_Stats1(RegionStats *Stats, int ne, char *filename);
void RegionStats_Save_Stats2(RegionStats *Stats, int ne, char *filename);
  
void RegionStats_Display_Stats1(RegionStats *Stats, int ne, char *name);
void RegionStats_Display_Stats2(RegionStats *Stats, int ne, char *name);

//void RegionStats_Rectangle_Computation(RegionStats *Stats, Image *imageL);
void RegionStats_SetRectangle         (RegionStats *Stats, int e, int ymin, int ymax, int xmin, int xmax);

// pointeur de tableau de Stats (ECC: pour LSL parallel

void RegionStats_Save_pStats1(RegionStats **pStats, int ne, char *filename);
void RegionStats_Save_pStats2(RegionStats **pStats, int ne, char *filename);

void RegionStats_Display_pStats1(RegionStats **pStats, int ne, char *name);
void RegionStats_Display_pStats2(RegionStats **pStats, int ne, char *name);

void Region32_Calc1_Features_1Pass(RegionStats *Stats, uint32 e, int i, int j);
// faire une version pointFeaturesComputation (cf line et image)
// ------------------------
// --- RegionStats 2013 ---
// ------------------------
void   RegionStats_Calc_Rectangle_Moment1(uint32 **E, int height, int width, RegionStats *Stats);
void   RegionStats_calc_Status(RegionStats *Stats, uint32 ne, uint32 min_height, uint32 min_width, uint32 min_area, uint8 *status);
uint32 RegionStats_UpdateEQ_with_Status(uint8 *status, uint32 ne, uint32 *EQ);
void   RegionStats_UpdateStats_with_EQ(uint32 *EQ, uint32 ne, RegionStats *Stats);

    
// RegioStats 2014 (Laurent Cabaret)
void featuresComputation(uint32 **E, int height,int width,RegionStats *Stats); // ne plus utiliser

void pointFeaturesComputation_Dummy(uint32 **E, int i, int j, RegionStats *Stats);
void pointFeaturesComputation      (uint32 **E, int i, int j, RegionStats *Stats);
    
void lineFeaturesComputation_Dummy(uint32 **E, int i, int width, RegionStats *Stats);
void lineFeaturesComputation      (uint32 **E, int i, int width, RegionStats *Stats);

void bandFeaturesComputation_Dummy(uint32 **E, int i0, int i1, int width, RegionStats *Stats);
void bandFeaturesComputation      (uint32 **E, int i0, int i1, int width, RegionStats *Stats);    
    
void imageFeaturesComputation_Dummy(uint32 **E, int height, int width, RegionStats *Stats);
void imageFeaturesComputation      (uint32 **E, int height, int width, RegionStats *Stats);
      
// ------------------------
// --- RegionStats 2014 ---
// ------------------------

void RegionStats_Copy_Stats1_From_Index(RegionStats *Stats, int dst_index, int src_index);
void RegionStats_Accumulate_Stats1_From_Index(RegionStats *Stats, int dst_index, int src_index);
   
void RegionStats_Save_Stats1_Sparse(RegionStats *Stats, uint32 *EQ, uint32 ne0, uint32 ne1, char *filename);
void RegionStats_DisplayStats_Sparse(uint32 *EQ, uint32 ne0, uint32 ne1, RegionStats *Stats, char *name);
// affichage des Stats pour les etiquettes roots/ancetres de leur composante (pour algo Suzuki)

void RegionStats_DisplayStats_Range(uint32 *EQ, uint32 ne0, uint32 ne1, RegionStats *Stats, char *name);
    
// nb de composantes connexes pour Suzuki MK2
uint32 RegionStats_Count_Roots_Sparse1(RegionStats *Stats, uint32 *EQ, uint32 nemax);
uint32 RegionStats_Count_Roots_Sparse (RegionStats *Stats, uint32 *EQ, uint32 ne0, uint32 ne1);

uint32 RegionStats_Count_Labels_Sparse1(RegionStats *Stats, uint32 *EQ, uint32 nemax);
uint32 RegionStats_Count_Labels_Sparse (RegionStats *Stats, uint32 *EQ, uint32 ne0, uint32 ne1);

void copy_features_ui32matrix(RegionStats *Stats, uint32 ne, uint32 **m);
void copy_ui32matrix_features(uint32 **m, uint32 ne, RegionStats *Stats);
void sortv_ui32matrix_col(uint32 **m, int i0, int i1, int j0, int j1, int col);
void RegionStats_SortFeatures(RegionStats *Stats, uint32 nemax);
    
// version paralleles avec OpenMP2 ou OpenMP4
void imageFeaturesComputation_omp0(uint32 **E, int height, int width, RegionStats *Stats); // wrong
void imageFeaturesComputation_omp2(uint32 **E, int height, int width, RegionStats *Stats); // OpenMP 2.0 critical
void imageFeaturesComputation_omp3(uint32 **E, int height, int width, RegionStats *Stats); // OpenMP 2.0 critical + atomic
void imageFeaturesComputation_omp4(uint32 **E, int height, int width, RegionStats *Stats); // OpenMP 3.0 task + OpenMP 4.0 depend
void imageFeaturesComputation_omp5(uint32 **E, int height, int width, uint16* Xmin, uint16* Xmax, uint16* Ymin, uint16* Ymax, uint32* S, uint32* Sx, uint32* Sy);
    
int RegionStats_Compare(RegionStats *S1, RegionStats *S2);
int RegionStatsVector_Compare(RegionStats *S1, int i0, int i1, RegionStats *S2);
int RegionStatsVector_Match  (RegionStats *S1, int i0, int i1, RegionStats *S2, int j0, int j1);

#ifdef __cplusplus
}
#endif

#endif /* __FEATURES_H__ */
