/* ---------------- */
/* --- nrio1x.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdlib.h>
#include <stdio.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrkernel.h"
#include "nrmacro.h"

#include "nralloc1.h"
#include "nrio1x.h"

/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bvector_circular(byte *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16vector_circular(sint16 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name); 

  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32vector_circular(uint32 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32vector_circular(float32 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f64vector_circular(float64 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bvector_circular_number(byte *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  putchar('#');
  for(i=c0; i<=c1; i++) {
    printf(format,   i%n+nl);
  }
  putchar('\n');
  putchar(' ');
  for(i=c0; i<=c1; i++) {
    printf(format, v[i%n+nl]);
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si16vector_circular_number(sint16 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  putchar('#'); for(i=c0; i<=c1; i++) { printf(format,   i%n+nl); } putchar('\n');
  putchar(' ');  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32vector_circular_number(uint32 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  putchar('#'); for(i=c0; i<=c1; i++) { printf(format,   i%n+nl); } putchar('\n');
  putchar(' '); for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32vector_circular_number(float32 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  putchar('#'); for(i=c0; i<=c1; i++) { printf(format,   i%n+nl); } putchar('\n');
  putchar(' ');  for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_dvector_circular_number(float64 *v,long nl,long nh, long c0, long c1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------- */
{
  long i, n=nh-nl+1;

  if(name != NULL) puts(name);

  putchar('#'); for(i=c0; i<=c1; i++) { printf(format,   i%n+nl); } putchar('\n');
  putchar(' '); for(i=c0; i<=c1; i++) { printf(format, v[i%n+nl]);} putchar('\n');
}

/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bvector_cycle(byte *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
  long i;
  uint8 first, next;
  uint8 *displayed;

  if(name != NULL) printf("%s", name);

  displayed = ui8vector0(nl, nh);
  
  for(i=nl; i<=nh; i++) {
    if(!displayed[i]) {
      displayed[i] = 1;
      printf(format, i);
      first = (byte) i;
      next = v[i];
      while(first != next) {
        displayed[next] = 1;
        printf(format, next);
        next = v[next];
      }
      putchar('\n');
    }
  }
  putchar('\n');
  free_ui8vector(displayed, nl, nh);
}
/* -------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16vector_cycle(sint16 *v,long nl,long nh, char *format, char *name)
/* -------------------------------------------------------------------------------------- */
{
  long i;
  uint16 first, next;
  uint8 *displayed;

  if(name != NULL) printf("%s", name);

  displayed = ui8vector0(nl, nh);
  
  for(i=nl; i<=nh; i++) {
    if(!displayed[i]) {
      displayed[i] = 1;
      printf(format, i);
      first = (sint16) i;
      next = v[i];
      while(first != next) {
        displayed[next] = 1;
        printf(format, next);
        next = v[next];
      }
      putchar('\n');
    }
  }
  putchar('\n');
  free_ui8vector(displayed, nl, nh);
}
/* ---------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16vector_cycle(uint16 *v,long nl,long nh, char *format, char *name)
/* ---------------------------------------------------------------------------------------- */
{
  long i;
  uint16 first, next;
  uint8 *displayed;

  if(name != NULL) printf("%s", name);

  displayed = ui8vector0(nl, nh);
  
  for(i=nl; i<=nh; i++) {
    if(!displayed[i]) {
      displayed[i] = 1;
      printf(format, i);
      first = (uint16) i;
      next = v[i];
      while(first != next) {
        displayed[next] = 1;
        printf(format, next);
        next = v[next];
      }
      putchar('\n');
    }
  }
  putchar('\n');
  free_ui8vector(displayed, nl, nh);
}
