/* ----------------- */
/* --- nrio1fx.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdlib.h>
#include <stdio.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrkernel.h"
#include "nrmacro.h"

#include "nralloc1.h"
#include "nrio1xf.h"


/* --------------------------- */
/* -- write_vector_circular -- */
/* --------------------------- */
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) write_bvector_circular(byte *v,long nl,long nh, long c0, long c1, char *format, char *filename)
/* ------------------------------------------------------------------------------------------------------------ */
{
  long i, n=nh-nl+1;
  FILE *f;

  f = fopen(filename, "wt");
  if(f == NULL) { nrerror("Can't open file in write_bvector_circular"); }

  for(i=c0; i<=c1; i++) { fprintf(f, format, v[i%n+nl]);} fputc('\n', f);
  fclose(f);
}
