/* ---------------- */
/* --- nrio2x.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrio0.h"
#include "nralloc1.h"
#include "nralloc2.h"
#include "nrio1.h"
#include "nrio2.h"
#include "nrio2x.h"

/* ------------------------------ */
/* --- display_matrix_endline --- */
/* ------------------------------ */
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_matrix_endline(byte **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  byte *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16matrix_endline(int16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  int16 *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16matrix_endline(uint16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  uint16 *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32matrix_endline(int32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  int32 *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix_endline(uint32 **m, long i0, long i1, long j0, long j1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  uint32 *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* -------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix_endline(int64 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* -------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  int64 *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_imatrix_endline(int **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int n = (i1-i0+1) * (j1-j0+1);
  int *p = &m[i0][j0];

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j0+n; j++) {
      printf(format, *p++);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------- */
/* --- display_matrix_endline0 --- */
/* ------------------------------- */
/* ------------------------------------------------------------------------------------------------------------ */
//IMAGE_EXPORT(void) display_bmatrix_endline0(byte **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bmatrix_endline0(byte **m,long i0, long i1,char *format, char *name)
/* ----------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------- */
//IMAGE_EXPORT(void) display_i16matrix_endline0(int16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* --------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16matrix_endline0(int16 **m,long i0, long i1, char *format, char *name)
/* --------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------- */
//IMAGE_EXPORT(void) display_ui16matrix_endline0(uint16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------- */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16matrix_endline0(uint16 **m,long i0, long i1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------- */
//IMAGE_EXPORT(void) display_i32matrix_endline0(int32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* --------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32matrix_endline0(int32 **m,long i0, long i1, char *format, char *name)
/* --------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------- */
//IMAGE_EXPORT(void) display_ui32matrix_endline0(uint32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------- */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* ----------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix_endline0(uint32 **m,long i0, long i1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix_endline0(int64 **m,long i0, long i1, char *format, char *name)
/* --------------------------------------------------------------------------------------------- */
{
  int i, j;
  int64 n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------- */
//IMAGE_EXPORT(void) display_imatrix_endline0(int **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------- */
/*{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}*/
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_imatrix_endline0(int **m,long i0, long i1, char *format, char *name)
/* ----------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d] ", i);
    n = m[i][0];
    for(j=1; j<=+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------- */
/* --- display_matrix_endline1 --- */
/* ------------------------------- */
/* ------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_bmatrix_endline1(byte **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16matrix_endline1(int16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16matrix_endline1(uint16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32matrix_endline1(int32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32matrix_endline1(uint32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix_endline1(int64 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int64 n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_imatrix_endline1(int **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* -------------------------------------- */
/* --- display_matrix_number_endline0 --- */
/* -------------------------------------- */
/* ------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bmatrix_number_endline0(byte **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16matrix_number_endline0(int16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui16matrix_number_endline0(uint16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32matrix_number_endline0(int32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui32matrix_number_endline0(uint32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix_number_endline0(int64 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int64 n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_imatrix_number_endline0(int **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0];
    for(j=j0; j<=j0+n; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* -------------------------------------- */
/* --- display_matrix_number_endline1 --- */
/* -------------------------------------- */
/* ------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bmatrix_number_endline1(byte **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16matrix_number_endline1(int16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui16matrix_number_endline1(uint16 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32matrix_number_endline1(int32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui32matrix_number_endline1(uint32 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ---------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i64matrix_number_endline1(int64 **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
  int i, j;
  int64 n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_imatrix_number_endline1(int **m,long i0, long i1, long j0, long j1, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  int i, j, n;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    printf("[%3d]", i);
    n = m[i][j0-1];
    for(j=j0; j<=j0+n-1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
  }
  putchar('\n');
}
/* ------------------------- */
/* --- display_trimatrix --- */
/* ------------------------- */
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_btrimatrix(byte **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  int i, j;
  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i16trimatrix(int16 **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------------- */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16trimatrix(uint16 **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------------- */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* ----------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_itrimatrix(int **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* --------------------------------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_i32trimatrix(int32 **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* --------------------------------------------------------------------------------------------------------------------- */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f32trimatrix(float32 **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
/* ------------------------------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f64trimatrix(float64 **m, long i0, long i1, long j0, long j1, long step, char *format, char *name)
/* ------------------------------------------------------------------------------------------------------------------ */
{
  int i, j;

  if(name != NULL) puts(name);

  for(i=i0; i<=i1; i++) {
    for(j=j0; j<=j1; j++) {
      printf(format, m[i][j]);
    }
    putchar('\n');
    j1 += step;
  }
  putchar('\n');
}
