/* ------------------ */
/* --- ppalette.c --- */
/* ------------------ */

// Copyright (c) 2013-2014 Lionel Lacassagne, All Rights Reserved
// Laboratoire de Recherche en Informatique
// Universite Paris-Sud / CNRS

// ajout des demi-palettes n-colors + gray
// PackGrayLower PackGrayUpper


#include <stdio.h>
#include <stdlib.h>
#include <math.h>


#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif

#include "palette.h"

/*
 * Modif : 98-11-18 ajout de Save
 */

/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_Display(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;
    printf("Palette");
    for (i = 0; i < 256; i++) {
        printf("%4d:%4d%4d%4d\n", i,palette[i].red, palette[i].green, palette[i].blue);
    }
}
/* ----------------------------------------------------------- */
//IMAGE_EXPORT(void) Palette_Save(RGBQuad *palette, char *filename)
/* ----------------------------------------------------------- */
/*{
  int i, j;
  int k = 32;
  int hauteur = k, largeur = k*256;
  uint8  **X;
  Image *image;


  IConstructor(&image, hauteur, largeur, 0);
  X = (uint8**) Image_Get_Data(image);
  for(i=0; i<hauteur; i++) {
  for(j=0; j<largeur; j++) {
  X[i][j] = j/k;
  }
  }
//SaveBMP(image, palette, filename);
IDestructor(&image);
}*/
/* --------------------------------------------------------------------- */
//IMAGE_EXPORT(void) Palette_SaveSub(RGBQuad *palette, int n, char *filename)
/* --------------------------------------------------------------------- */
/*{
  int i, j;
  int hauteur = 8, largeur = 8*n;
  uint8  **X;
  Image *image;


  IConstructor(&image, largeur, hauteur, 0);
  X = (uint8**) Image_Get_Data(image);
  for(i=0; i<hauteur; i++) {
  for(j=8; j<=largeur; j++) {
  X[i][j] = j/8;
  }
  }
//SaveBMP(image, palette, filename);
IDestructor(&image);
}*/
/* --------------------------------------------------- */
IMAGE_EXPORT(void) Palette_GrayBlue2Red(RGBQuad *palette)
    /* --------------------------------------------------- */
    /* ancien SetupPalette */
{
    int i;

    /*
     * Partie basse : image en niveau de gris
     */
    for(i=0; i<128; i++) {
        palette[i].blue     = 2*i;
        palette[i].green    = 2*i;
        palette[i].red      = 2*i;
        palette[i].reserved = 0;
    }
    /*
     * Partie haute : couleurs additionnelles
     * degrade de bleus puis degrade de rouges
     */
    for(i=0; i<128; i++) {
        palette[i+128].blue     = 255 - 2*i;
        palette[i+128].green    = 0;
        palette[i+128].red      = 2*i+1;
        palette[i+128].reserved = 0;
    }
    palette[128].blue     = 255;
    palette[128].green    = 0;
    palette[128].red      = 0;
    palette[128].reserved = 0;

    palette[255].blue     = 0;
    palette[255].green    = 0;
    palette[255].red      = 255;
    palette[255].reserved = 0;

    /*for(i=0; i<256; i++) {
      palette[i].rgbBlue     = i;
      palette[i].rgbGreen    = i;
      palette[i].rgbRed      = i;
      palette[i].rgbReserved = 0;
      }*/

    /*if(verbose) {
      for(i=0; i<256; i++) {
      printf("%d %3d %3d %3d\n", i, Palette[i].rgbRed, Palette[i].rgbGreen, Palette[i].rgbBlue);
      }
      }*/
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_Classic(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;

    for(i=0; i<256; i++) {
        palette[i].blue     = (uint8) i;
        palette[i].green    = (uint8) i;
        palette[i].red      = (uint8) i;
        palette[i].reserved = (uint8) 0;
    }
}
/* ------------------------------------------- */
IMAGE_EXPORT(void) Palette_Gray(RGBQuad *palette)
    /* ------------------------------------------- */
{
    int i;

    for(i=0; i<256; i++) {
        palette[i].blue     = (uint8) i;
        palette[i].green    = (uint8) i;
        palette[i].red      = (uint8) i;
        palette[i].reserved = (uint8) 0;
    }
}

/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_Pseudo1(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;
    for(i=0; i<255; i++) {
        palette[i].blue     = (uint8) ((3*i)%256);
        palette[i].green    = (uint8) ((87*i)%256);
        palette[i].red      = (uint8) ((117*i)%256);
        palette[i].reserved = 0;
    }
    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_Pseudo2(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;
    for(i=0; i<255; i++) {
        palette[i].blue     = (uint8) ((     257*i)%256); /* nextprime(256) */
        palette[i].green    = (uint8) ((   65537*i)%256); /* nextprime(256^2) */
        palette[i].red      = (uint8) ((16777259*i)%256); /* nextprime(256^3) */
        palette[i].reserved = 0;
    }
    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ------------------------------------------ */
IMAGE_EXPORT(void) Palette_Hue(RGBQuad *palette)
    /* ------------------------------------------ */
{
    int i;
    double k, r, g, b; /* alpha rgb */
    for(i=0; i<255; i++) {

        k = (double) i / 256;

        r = 2.0 * k * PI;
        g = 2.0 * k * PI - (2.0*PI/3.0);
        b = 2.0 * k * PI  - (4.0*PI/3.0);

        palette[i].blue     = (uint8) (128.0 * (1.0 + cos(b)));
        palette[i].green    = (uint8) (128.0 * (1.0 + cos(g)));
        palette[i].red      = (uint8) (128.0 * (1.0 + cos(r)));
        palette[i].reserved = 0;
    }
}
/* ------------------------------------------------ */
IMAGE_EXPORT(void) Palette_RandomHue(RGBQuad *palette)
    /* ------------------------------------------------ */
{
    int i, ii;
    double k, r, g, b; /* alpha rgb */
    for(i=0; i<255; i++) {

        ii = (3*i)%256;
        k = (double) (ii / 256);

        r = 2.0 * k * PI;
        g = 2.0 * k * PI - (2.0*PI/3.0);
        b = 2.0 * k * PI  - (4.0*PI/3.0);

        palette[i].blue     = (uint8) (128.0 * (1.0 + cos(b)));
        palette[i].green    = (uint8) (128.0 * (1.0 + cos(g)));
        palette[i].red      = (uint8) (128.0 * (1.0 + cos(r)));
        palette[i].reserved = 0;
    }
}
/* -------------------------------------------- */
IMAGE_EXPORT(void) Palette_HueBW(RGBQuad *palette)
    /* -------------------------------------------- */
{
    int i;
    double k, r, g, b; /* alpha rgb */
    for(i=0; i<255; i++) {

        k = (double) i / 256;

        r = 2.0 * k * PI;
        g = 2.0 * k * PI - (2.0*PI/3.0);
        b = 2.0 * k * PI  - (4.0*PI/3.0);

        palette[i].blue     = (uint8) (128.0 * (1.0 + cos(b)));
        palette[i].green    = (uint8) (128.0 * (1.0 + cos(g)));
        palette[i].red      = (uint8) (128.0 * (1.0 + cos(r)));
        palette[i].reserved = 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* -------------------------------------------------- */
IMAGE_EXPORT(void) Palette_RandomHueBW(RGBQuad *palette)
    /* -------------------------------------------------- */
{
    int i, ii, im;
    double k, r, g, b; /* alpha rgb */
    for(i=0; i<255; i++) {

        ii = (7*i)%256;
        k = (double) ii / 256;

        r = 2.0 * k * PI;
        g = 2.0 * k * PI - (2.0*PI/3.0);
        b = 2.0 * k * PI  - (4.0*PI/3.0);

        im = (i-27)%255;
        im = i;
        palette[im].blue     = (uint8) (128.0 * (1.0 + cos(b)));
        palette[im].green    = (uint8) (128.0 * (1.0 + cos(g)));
        palette[im].red      = (uint8) (128.0 * (1.0 + cos(r)));
        palette[im].reserved = 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ------------------------------------------------ */
IMAGE_EXPORT(void) Palette_3ColorsBW(RGBQuad *palette)
    /* ------------------------------------------------ */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[3];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    for(i=0; i<255; i++) {
        palette[1+i].red      = pattern[i%3].red;
        palette[1+i].green    = pattern[i%3].green;
        palette[1+i].blue     = pattern[i%3].blue;
        palette[1+i].reserved = (uint8) 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_3Colors(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[3];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%3].red;
        palette[i].green    = pattern[i%3].green;
        palette[i].blue     = pattern[i%3].blue;
        palette[i].reserved = (uint8) 0;
    }
}
/* -------------------------------------------------- */
IMAGE_EXPORT(void) Palette_3Colors_Red(RGBQuad *palette)
    /* -------------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[3];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    /* rouge en 0 */
    palette[0].red   = pattern[0].red;
    palette[0].green = pattern[0].green;
    palette[0].blue  = pattern[0].blue;

    for(i=0; i<255; i++) {
        palette[1+i].red      = pattern[1+i%2].red;
        palette[1+i].green    = pattern[1+i%2].green;
        palette[1+i].blue     = pattern[1+i%2].blue;
        palette[1+i].reserved = (uint8) 0;
    }
}
/* ------------------------------------------------ */
IMAGE_EXPORT(void) Palette_6ColorsBW(RGBQuad *palette)
    /* ------------------------------------------------ */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[6];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    for(i=0; i<255; i++) {
        palette[1+i].red      = pattern[i%6].red;
        palette[1+i].green    = pattern[i%6].green;
        palette[1+i].blue     = pattern[i%6].blue;
        palette[1+i].reserved = (uint8) 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_6Colors(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[6];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%6].red;
        palette[i].green    = pattern[i%6].green;
        palette[i].blue     = pattern[i%6].blue;
        palette[i].reserved = (uint8) 0;
    }
}
/* -------------------------------------------------- */
IMAGE_EXPORT(void) Palette_6Colors_Red(RGBQuad *palette)
    /* -------------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    RGBQuad pattern[6];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    /* rouge en 0 */
    palette[0].red   = pattern[0].red;
    palette[0].green = pattern[0].green;
    palette[0].blue  = pattern[0].blue;

    for(i=0; i<255; i++) {
        palette[1+i].red      = pattern[1+i%5].red;
        palette[1+i].green    = pattern[1+i%5].green;
        palette[1+i].blue     = pattern[1+i%5].blue;
        palette[1+i].reserved = (uint8) 0;
    }
}
/* ------------------------------------------------- */
IMAGE_EXPORT(void) Palette_18ColorsBW(RGBQuad *palette)
    /* ------------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    uint8  r  =127, g = 127,  b = 127;

    RGBQuad pattern[18];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    pattern[6].red   = r;
    pattern[6].green = 0;
    pattern[6].blue  = 0;

    pattern[7].red   = 0;
    pattern[7].green = g;
    pattern[7].blue  = 0;

    pattern[8].red   = 0;
    pattern[8].green = 0;
    pattern[8].blue  = b;

    pattern[9].red   = r;
    pattern[9].green = g;
    pattern[9].blue  = 0;

    pattern[10].red   = r;
    pattern[10].green = 0;
    pattern[10].blue  = b;

    pattern[11].red   = 0;
    pattern[11].green = g;
    pattern[11].blue  = b;

    pattern[12].red   = rr;
    pattern[12].green = g;
    pattern[12].blue  = 0;

    pattern[13].red   = rr;
    pattern[13].green = 0;
    pattern[13].blue  = b;

    pattern[14].red   = 0;
    pattern[14].green = gg;
    pattern[14].blue  = b;

    pattern[15].red   = r;
    pattern[15].green = gg;
    pattern[15].blue  = 0;

    pattern[16].red   = r;
    pattern[16].green = 0;
    pattern[16].blue  = bb;

    pattern[17].red   = 0;
    pattern[17].green = g;
    pattern[17].blue  = bb;

    for(i=0; i<255; i++) {
        palette[1+i].red      = pattern[i%18].red;
        palette[1+i].green    = pattern[i%18].green;
        palette[1+i].blue     = pattern[i%18].blue;
        palette[1+i].reserved = (uint8) 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ----------------------------------------------- */
IMAGE_EXPORT(void) Palette_18Colors(RGBQuad *palette)
    /* ----------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    uint8  r  =127, g = 127,  b = 127;

    RGBQuad pattern[18];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    pattern[6].red   = r;
    pattern[6].green = 0;
    pattern[6].blue  = 0;

    pattern[7].red   = 0;
    pattern[7].green = g;
    pattern[7].blue  = 0;

    pattern[8].red   = 0;
    pattern[8].green = 0;
    pattern[8].blue  = b;

    pattern[9].red   = r;
    pattern[9].green = g;
    pattern[9].blue  = 0;

    pattern[10].red   = r;
    pattern[10].green = 0;
    pattern[10].blue  = b;

    pattern[11].red   = 0;
    pattern[11].green = g;
    pattern[11].blue  = b;

    pattern[12].red   = rr;
    pattern[12].green = g;
    pattern[12].blue  = 0;

    pattern[13].red   = rr;
    pattern[13].green = 0;
    pattern[13].blue  = b;

    pattern[14].red   = 0;
    pattern[14].green = gg;
    pattern[14].blue  = b;

    pattern[15].red   = r;
    pattern[15].green = gg;
    pattern[15].blue  = 0;

    pattern[16].red   = r;
    pattern[16].green = 0;
    pattern[16].blue  = bb;

    pattern[17].red   = 0;
    pattern[17].green = g;
    pattern[17].blue  = bb;

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%18].red;
        palette[i].green    = pattern[i%18].green;
        palette[i].blue     = pattern[i%18].blue;
        palette[i].reserved = (uint8) 0;
    }
}
/* ------------------------------------------------- */
IMAGE_EXPORT(void) Palette_64ColorsBW(RGBQuad *palette)
    /* ------------------------------------------------- */
{
    int r, g, b;
    int i, m;
    //uint8 x1 = 64, x2 = 128, x3 = 192, x4 = 255;
    uint8 X[4];
    //RGBQuad pattern[64];

    X[0] = 255;
    X[1] = 192;
    X[2] = 128;
    X[3] =  64;

    m = 1;
    for(r=0; r<4; r++) {
        for(g=0; g<4; g++) {
            for(b=0; b<4; b++) {
                palette[m].red   = X[r];
                palette[m].green = X[g];
                palette[m].blue  = X[b];
                m++;
            }
        }
    }

    for(i=0; i<255-(1+m); i++) {
        palette[1+m+i].red      = palette[i%m].red;
        palette[1+m+i].green    = palette[i%m].green;
        palette[1+m+i].blue     = palette[i%m].blue;
        palette[1+m+i].reserved = (uint8) 0;
    }
    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ------------------------------------------------- */
IMAGE_EXPORT(void) Palette_256ColorsBW(RGBQuad *palette)
    /* ------------------------------------------------- */
{
    int r, g, b;
    int m;
    //uint8 x1 = 64, x2 = 128, x3 = 192, x4 = 255;
    uint8 X[8], xr, xg, xb;
    //RGBQuad pattern[64];

    X[0] = 255;
    X[1] = 224;
    X[2] = 192;
    X[3] = 160;
    X[4] = 128;
    X[5] =  96;
    X[6] =  64;
    X[7] =  32;

    m = 1;
    for(r=0; r<8; r++) {
        for(g=0; g<8; g++) {
            for(b=0; b<8; b++) {
                if(m<255) {
                    xr = X[r]; xg = X[g]; xb = X[b];
                    palette[m].red   = xr;
                    palette[m].green = xg;
                    palette[m].blue  = xb;
                    if((xr!=255) && (xg!=255) && (xb!=255)) m++;
                    if((xr!=000) && (xg!=000) && (xb!=000)) m++;
                }
            }
        }
    }

    palette[0].blue     = (uint8) 0;
    palette[0].green    = (uint8) 0;
    palette[0].red      = (uint8) 0;
    palette[0].reserved = (uint8) 0;

    palette[255].blue     = (uint8) 255;
    palette[255].green    = (uint8) 255;
    palette[255].red      = (uint8) 255;
    palette[255].reserved = (uint8) 0;
}
/* ----------------------------------------------------- */
IMAGE_EXPORT(void) Palette_18ColorsBW_Red(RGBQuad *palette)
    /* ----------------------------------------------------- */
{
    int i;
    uint8 rr = 255,gg = 255, bb = 255;
    uint8  r  =127, g = 127,  b = 127;

    RGBQuad pattern[18];

    pattern[0].red   = rr;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    pattern[1].red   = 0;
    pattern[1].green = gg;
    pattern[1].blue  = 0;

    pattern[2].red   = 0;
    pattern[2].green = 0;
    pattern[2].blue  = bb;

    pattern[3].red   = rr;
    pattern[3].green = gg;
    pattern[3].blue  = 0;

    pattern[4].red   = rr;
    pattern[4].green = 0;
    pattern[4].blue  = bb;

    pattern[5].red   = 0;
    pattern[5].green = gg;
    pattern[5].blue  = bb;

    pattern[6].red   = r;
    pattern[6].green = 0;
    pattern[6].blue  = 0;

    pattern[7].red   = 0;
    pattern[7].green = g;
    pattern[7].blue  = 0;

    pattern[8].red   = 0;
    pattern[8].green = 0;
    pattern[8].blue  = b;

    pattern[9].red   = r;
    pattern[9].green = g;
    pattern[9].blue  = 0;

    pattern[10].red   = r;
    pattern[10].green = 0;
    pattern[10].blue  = b;

    pattern[11].red   = 0;
    pattern[11].green = g;
    pattern[11].blue  = b;

    pattern[12].red   = rr;
    pattern[12].green = g;
    pattern[12].blue  = 0;

    pattern[13].red   = rr;
    pattern[13].green = 0;
    pattern[13].blue  = b;

    pattern[14].red   = 0;
    pattern[14].green = gg;
    pattern[14].blue  = b;

    pattern[15].red   = r;
    pattern[15].green = gg;
    pattern[15].blue  = 0;

    pattern[16].red   = r;
    pattern[16].green = 0;
    pattern[16].blue  = bb;

    pattern[17].red   = 0;
    pattern[17].green = g;
    pattern[17].blue  = bb;

    for(i=0; i<254; i++) {
        palette[2+i].red      = pattern[1+i%17].red;
        palette[2+i].green    = pattern[1+i%17].green;
        palette[2+i].blue     = pattern[1+i%17].blue;
        palette[2+i].reserved = (uint8) 0;
    }
    /* noir en 0 */
    palette[0].red   = 0;
    palette[0].green = 0;
    palette[0].blue  = 0;
    /* rouge en 1 */
    palette[1].red   = rr;
    palette[1].green = 0;
    palette[1].blue  = 0;
    /* blanc en 255 */
    palette[255].red   = rr;
    palette[255].green = gg;
    palette[255].blue  = gg;
}
/* -------------------------------------------------------------- */
IMAGE_EXPORT(void) Palette_18ColorsBW_RedGreenBlue(RGBQuad *palette)
    /* -------------------------------------------------------------- */
{
    int i;
    uint8 i0 = 255;
    uint8 i1 = 127;
    //uint8 i2 = 63;

    RGBQuad pattern[18];

    /* 0+0 */
    pattern[0].red   = i0;
    pattern[0].green = i0;
    pattern[0].blue  = 0;

    pattern[1].red   = i0;
    pattern[1].green = 0;
    pattern[1].blue  = i0;

    pattern[2].red   = 0;
    pattern[2].green = i0;
    pattern[2].blue  = i0;

    /* 1 */
    pattern[3].red   = i1;
    pattern[3].green = 0;
    pattern[3].blue  = 0;

    pattern[4].red   = 0;
    pattern[4].green = i1;
    pattern[4].blue  = 0;

    pattern[5].red   = 0;
    pattern[5].green = 0;
    pattern[5].blue  = i1;

    /* 1+1 */
    pattern[6].red   = i1;
    pattern[6].green = i1;
    pattern[6].blue  = 0;

    pattern[7].red   = i1;
    pattern[7].green = 0;
    pattern[7].blue  = i1;

    pattern[8].red   = 0;
    pattern[8].green = i1;
    pattern[8].blue  = i1;

    /* 0+1 */
    pattern[9].red   = i0;
    pattern[9].green = i1;
    pattern[9].blue  = 0;

    pattern[10].red   = i0;
    pattern[10].green = 0;
    pattern[10].blue  = i1;

    pattern[11].red   = 0;
    pattern[11].green = i0;
    pattern[11].blue  = i1;

    pattern[12].red   = i1;
    pattern[12].green = i0;
    pattern[12].blue  = 0;

    pattern[13].red   = i1;
    pattern[13].green = 0;
    pattern[13].blue  = i0;

    pattern[14].red   = 0;
    pattern[14].green = i1;
    pattern[14].blue  = i0;

    for(i=0; i<=250; i++) {
        palette[4+i].red      = pattern[i%14].red;
        palette[4+i].green    = pattern[i%14].green;
        palette[4+i].blue     = pattern[i%14].blue;
        palette[4+i].reserved = (uint8) 0;
    }

    /* noir en 0 */
    palette[0].red   = 0;
    palette[0].green = 0;
    palette[0].blue  = 0;

    /* rouge en 1 */
    palette[1].red   = i0;
    palette[1].green = 0;
    palette[1].blue  = 0;

    /* vert en 2 */
    palette[2].red   = 0;
    palette[2].green = i0;
    palette[2].blue  = 0;

    /* bleu en 3 */
    palette[2].red   = 0;
    palette[2].green = i0;
    palette[2].blue  = 0;

    /* blanc en 255 */
    palette[255].red   = i0;
    palette[255].green = i0;
    palette[255].blue  = i0;
}
/* ---------------------------------------------------- */
IMAGE_EXPORT(void) Palette_3ColorsGrayBW(RGBQuad *palette)
    /* ---------------------------------------------------- */
{
    int i;

    Palette_3ColorsBW(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
    /* palette[255] = blanc <- OK */
}
/* -------------------------------------------------- */
IMAGE_EXPORT(void) Palette_3ColorsGray(RGBQuad *palette)
    /* -------------------------------------------------- */
{
    int i;

    Palette_3Colors(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
}
/* ---------------------------------------------------- */
IMAGE_EXPORT(void) Palette_6ColorsGrayBW(RGBQuad *palette)
    /* ---------------------------------------------------- */
{
    int i;

    Palette_6ColorsBW(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
}
/* -------------------------------------------------- */
IMAGE_EXPORT(void) Palette_6ColorsGray(RGBQuad *palette)
    /* -------------------------------------------------- */
{
    int i;

    Palette_6Colors(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
}
/* ----------------------------------------------------- */
IMAGE_EXPORT(void) Palette_18ColorsGrayBW(RGBQuad *palette)
    /* ----------------------------------------------------- */
{
    int i;

    Palette_18ColorsBW(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
}
/* --------------------------------------------------- */
IMAGE_EXPORT(void) Palette_18ColorsGray(RGBQuad *palette)
    /* --------------------------------------------------- */
{
    int i;

    Palette_18Colors(palette);

    for(i=128; i<256; i++) {
        palette[i].red      = 1 + 2*(i-128);
        palette[i].green    = 1 + 2*(i-128);
        palette[i].blue     = 1 + 2*(i-128);
        palette[i].reserved = (uint8) 0;
    }
}
/* -------------------------------------------------------------------- */
//IMAGE_EXPORT(void) Palette_PackGrayLower(Image *src, Lut *lut, Image *dst)
/* -------------------------------------------------------------------- */
/*{
  int k;
  uint8 *l = (uint8*) Lut_Get_Data(lut);

  for(k=0; k<256; k++) {
  l[k] = (uint8) (k >> 1);
  }

  Lut_Apply(src, lut, dst);
  }*/
/* -------------------------------------------------------------------- */
//IMAGE_EXPORT(void) Palette_PackGrayUpper(Image *src, Lut *lut, Image *dst)
/* -------------------------------------------------------------------- */
/*{
  int k;
  uint8 *l = (uint8*) Lut_Get_Data(lut);

  for(k=0; k<256; k++) {
  l[k] = (uint8) 128 + (k >> 1);
  }

  Lut_Apply(src, lut, dst);
  }*/
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_2Colors(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i, level;

    RGBQuad pattern[2];

    pattern[0].red   = 0;
    pattern[0].green = 0;
    pattern[0].blue  = 0;

    level = 255;

    pattern[1].red   = level;
    pattern[1].green = level;
    pattern[1].blue  = level;

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%2].red;
        palette[i].green    = pattern[i%2].green;
        palette[i].blue     = pattern[i%2].blue;
        palette[i].reserved = (uint8) 0;
    }
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_4Colors(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i, level;

    RGBQuad pattern[4];

    for(i=0; i<2; i++) {
        level = (i<<8) - 1;
        pattern[i].red   = level;
        pattern[0].green = level;
        pattern[0].blue  = level;
    }

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%2].red;
        palette[i].green    = pattern[i%2].green;
        palette[i].blue     = pattern[i%2].blue;
        palette[i].reserved = (uint8) 0;
    }
}
/* ---------------------------------------------- */
IMAGE_EXPORT(void) Palette_16Colors(RGBQuad *palette)
    /* ---------------------------------------------- */
{
    int i, level;

    RGBQuad pattern[16];

    for(i=0; i<4; i++) {
        level = (i<<8) - 1;
        pattern[i].red   = level;
        pattern[0].green = level;
        pattern[0].blue  = level;
    }

    for(i=0; i<256; i++) {
        palette[i].red      = pattern[i%2].red;
        palette[i].green    = pattern[i%2].green;
        palette[i].blue     = pattern[i%2].blue;
        palette[i].reserved = (uint8) 0;
    }
}
