//////////////////////////////////////////////////////////////////////////////////
// File     : stdlib.h 
// Date     : 05/12/2013
// Author   : Clément DEVIGNE
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#include <stdarg.h>

#ifndef _STDLIB_H
#define _STDLIB_H

////////////////////////////////////////////////////////////////////////////////////////
// This function translates a character string to a signed integer.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
int atoi ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function translate a character string to a double.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
double atof ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function copies size bytes from the src source buffer 
// to the dst destination buffer.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void* memcpy( void*         dst, 
              const void*   src, 
              unsigned int  size );

////////////////////////////////////////////////////////////////////////////////////////
// This function initializes size bytes in the dst destination buffer, 
// with the value defined by (char)s.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void* memset( void*        dst,
              int          s,
              unsigned int size );


///////////////////////////////////////////////////////////////////////////////////////
// This user function build a formated string.
// It analyse the <format> argument and uses the other arguments to returns 
// a formated string in the <string> buffer. 
// The <length> define the destination buffer size (bytes).
// It returns the number of written characters in case of success.
// It returns 0xFFFFFFFF in case of error (illegal format, or buffer overflow).
///////////////////////////////////////////////////////////////////////////////////////
unsigned int snprintf( char*        string,
                       unsigned int length,
                       char*        format, ... );

///////////////////////////////////////////////////////////////////////////////////////
// This service function is called by:
// - giet_fat_fprintf()
// - giet_tty_printf()
// - snprintf()
///////////////////////////////////////////////////////////////////////////////////////
unsigned int xprintf( char*        string,
                      unsigned int length,
                      char*        format,
                      va_list*     args );
                


#endif


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
