//////////////////////////////////////////////////////////////////////////////////
// File     : string.h 
// Date     : 23/05/2013
// Author   : Alexandre JOANNOU, Laurent LAMBERT
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _STRING_H
#define _STRING_H

////////////////////////////////////////////////////////////////////////////////////////
// This function copies the source string to the dest string, including the NUL 
// terminating character.
// It returns a pointer on the dest string.
////////////////////////////////////////////////////////////////////////////////////////
char * strcpy(char * destination, const char * source);

////////////////////////////////////////////////////////////////////////////////////////
// The strncpy() function is similar to strcpy, except that at most n bytes of src
// are copied. If there is no null byte among the first n bytes of src, the string
// placed in dest will not be null terminated.
////////////////////////////////////////////////////////////////////////////////////////
char * strncpy(char * dest, const char * src, int n);

////////////////////////////////////////////////////////////////////////////////////////
// The strcmp() function compares the two strings s1 and s2.  It returns an integer 
// less than, equal to, or greater than zero if s1 is found, respectively, to be smaller
// to match, or be greater than s2.
////////////////////////////////////////////////////////////////////////////////////////
int strcmp(const char * str1, const char * str2);

////////////////////////////////////////////////////////////////////////////////////////
// This function returns the number of characters in a string.
// The terminating NULL character is not taken into account.
////////////////////////////////////////////////////////////////////////////////////////
int strlen(const char * str);

////////////////////////////////////////////////////////////////////////////////////////
// The strchr() function returns a pointer to the first occurrence of the character c
// in the string s.
////////////////////////////////////////////////////////////////////////////////////////
char * strchr(const char * str, int c);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
