//////////////////////////////////////////////////////////////////////////////////
// File     : string.c 
// Date     : 23/05/2013
// Author   : Alexandre JOANNOU, Laurent LAMBERT
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////
char * strcpy (char * destination, const char * source)
{
    if (!destination || !source) return destination;

    char* src = source;
    char* dst = destination;
    do 
    {
        *dst = *src;
        dst++;
        src++;
    }  while (*src);

    *dst = 0;

    return destination;
}


////////////////////////////////////////////////////
char * strncpy(char * dest, const char * src, int n)
{
    int i;
    for (i = 0; i < n && src[i] != '\0'; i++) 
    {
        dest[i] = src[i];
    }
    for (; i < n ; i++) 
    {
        dest[i] = '\0';
    }

    return dest;
}


/////////////////////////////////////////////////
int strcmp (const char * str1, const char * str2)
{
    if (!str1 || !str2) 
    {
        return -123456;     // return a value out of the char's bounds
    }

    while (*str1 && *str1 == *str2) 
    {
        str1++;
        str2++;
    }

    return (*str1 - *str2);
}

/////////////////////////////
int strlen (const char * str)
{
    const char * s = str;

    while (*s) 
    {
        s++;
    }
    return (s - str);
}


//////////////////////////////////////
char * strchr(const char * str, int c)
{
    const char * s = str;
    const char ch = c;
    while (*s != ch && *s != '\0') 
    {
        s++;
    }

    return (char *) s;
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
