/* ---------------------- */
/* --- ecc_examples.c --- */
/* ---------------------- */

// fonction de test de Lionel Lacassagne
// version 2014-2015

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif

#include "palette.h"
#include "bmpNR.h"
#include "histogramNR.h"

#include "ecc_common.h"
#include "ecc_features.h"
#include "ecc_generation.h"


// --------------------------------------------------------------
void init_forme1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{
    uint8 **X;
    int i = 0;
    int h = 8;
    int w = 8;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 012345678
    set_ui8vector_str(X[i++], 0, w-1, "111.11.1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "11.11.11"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.11.111"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111.1111"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "...11111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "11111111"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "11111111"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "11111111"); // 7
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme1");
    printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme1.txt");
}
// --------------------------------------------------------------
void init_forme2(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h = 10;
    int w = 17;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "................1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "....1.......1...1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1...1.....1.1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1.1...1.11111"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "11111.1.1.1...1.."); // 4
    set_ui8vector_str(X[i++], 0, w-1, "..1...11111...1.."); // 5
    set_ui8vector_str(X[i++], 0, w-1, "..1.....1.....1.."); // 6
    set_ui8vector_str(X[i++], 0, w-1, "..1111111111111.."); // 7
    set_ui8vector_str(X[i++], 0, w-1, "........1........"); // 8
    set_ui8vector_str(X[i++], 0, w-1, "........1........"); // 9
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme2"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme2.txt");
}
// --------------------------------------------------------------
void init_forme3(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h = 10;
    int w = 17;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001111111
    //                                 01234567890123456
    set_ui8vector_str(X[i++], 0, w-1, "................."); // 0
    set_ui8vector_str(X[i++], 0, w-1, "....1.......1...1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1...1.....1.1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1.1...1.11111"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "11111.1.1.1...1.."); // 4
    set_ui8vector_str(X[i++], 0, w-1, "..1...11111...1.."); // 5
    set_ui8vector_str(X[i++], 0, w-1, "..1.....1.....1.."); // 6
    set_ui8vector_str(X[i++], 0, w-1, "..1111111111111.."); // 7
    set_ui8vector_str(X[i++], 0, w-1, "........1........"); // 8
    set_ui8vector_str(X[i++], 0, w-1, "........1........"); // 9    
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme3"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme3.txt");
}
// --------------------------------------------------------------
void init_forme4(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  8;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                  00000000001
    //                                  01234567890
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1 1.1.1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "111.111.111"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "..........."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1 1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111.111.111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "..........."); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1 1.1.1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "111.111.111"); // 7
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme4"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme4.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  5;
    int w =  7;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000
    //                                 01234567
    set_ui8vector_str(X[i++], 0, w-1, "1.....1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1..1.11"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.1111."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111...."); // 3
    set_ui8vector_str(X[i++], 0, w-1, "......."); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor1"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor1.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor2(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  5;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;

    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, "1........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1.....1.11"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1111."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.1111...."); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor2"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor2.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor3(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 13;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001111
    //                                 01234567890123
    set_ui8vector_str(X[i++], 0, w-1, "1           1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1        1 11"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1     1.1111."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1  1 1111    "); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1111       "); // 4
    set_ui8vector_str(X[i++], 0, w-1, "111          "); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor3"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor3.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor1b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    // backdoor1b = 8C(backdoor1)

    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  9;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000
    //                                 0123456789
    set_ui8vector_str(X[i++], 0, w-1, "1.......1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1...1.111"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.11111.."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111......"); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor1b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor1b.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor2b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    // backdoor2b = 8C(backdoor2)
    
    uint8 **X;
    int i =  0;
    int h =  5;
    int w = 13;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001111
    //                                 01234567890123
    set_ui8vector_str(X[i++], 0, w-1, "1...........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1.......1.111"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1...1.11111.."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 11111......"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111.........."); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor2b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor2b.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor3b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    // backdoor3b = 8C(backdoor3)
    
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 17;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "1...............1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1...........1.111"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.......1.11111.."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1...1.11111......"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 11111.........."); // 4
    set_ui8vector_str(X[i++], 0, w-1, "111.............."); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor3b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor3b.txt");
}
// ----------------------------------------------------------------------------
void init_forme_LSL_backdoor1b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ----------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  5;
    int w =  8;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000
    //                                 012345678
    set_ui8vector_str(X[i++], 0, w-1, "1      1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1    1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1  1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 "); // 3
    set_ui8vector_str(X[i++], 0, w-1, " 1      "); // 4

    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor1b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor1b.txt");
}
// ----------------------------------------------------------------------------
void init_forme_LSL_backdoor2b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ----------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, "1        1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1      1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1    1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1  1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 "); // 4
    set_ui8vector_str(X[i++], 0, w-1, " 1        "); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor2b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor2b.txt");
}
// ----------------------------------------------------------------------------
void init_forme_LSL_backdoor3b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ----------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, "1       1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1  1 1 1 "); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1      "); // 4
    set_ui8vector_str(X[i++], 0, w-1, " 1       "); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor3b"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_LSL_backdoor3b.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor7(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, ".........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".......1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, ".....1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1.11111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor7"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor8.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor8(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  7;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, ".........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".......1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1....1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1.11111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1.1......."); // 5
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 6
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor8"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor8.txt");
}
// -----------------------------------------------------------------------
void init_forme_backdoor9(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  7;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, ".........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".......1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, ".....1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1.11111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1.1......."); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1.1......."); // 6
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 7
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor9"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor9.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor10(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  9;
    int w = 11;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011
    //                                 012345678901
    set_ui8vector_str(X[i++], 0, w-1, "1         1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1       1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1.1 1 1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1 1 1"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "111 111 1 1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "      111 1"); // 7
    set_ui8vector_str(X[i++], 0, w-1, "        111"); // 8
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor10"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor10.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor11(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  9;
    int w = 11;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011
    //                                 012345678901
    set_ui8vector_str(X[i++], 0, w-1, "1         1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1       1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1 1 1"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1 1 111 1 1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "111   111 1"); // 7
    set_ui8vector_str(X[i++], 0, w-1, "        111"); // 8
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor11"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor11.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor12(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  9;
    int w = 11;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011
    //                                 012345678901
    set_ui8vector_str(X[i++], 0, w-1, "1         1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1       1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1 1 1"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1 1 111 1 1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "1 1   111 1"); // 7
    set_ui8vector_str(X[i++], 0, w-1, "111     111"); // 8
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor12"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor12.txt");
}
// ------------------------------------------------------------------------
void init_forme_backdoor13(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h = 11;
    int w = 13;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001123
    //                                 01234567890123
    set_ui8vector_str(X[i++], 0, w-1, "1           1"); //  0
    set_ui8vector_str(X[i++], 0, w-1, "1         1 1"); //  1
    set_ui8vector_str(X[i++], 0, w-1, "1       1 1 1"); //  2
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1 1 1"); //  3 
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1 1 1"); //  4 
    set_ui8vector_str(X[i++], 0, w-1, "1 1.1 1 1 1 1"); //  5 
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1 1 1 1"); //  6
    set_ui8vector_str(X[i++], 0, w-1, "111 111 1 1 1"); //  7
    set_ui8vector_str(X[i++], 0, w-1, "      111 1 1"); //  8
    set_ui8vector_str(X[i++], 0, w-1, "        111 1"); //  9
    set_ui8vector_str(X[i++], 0, w-1, "          111"); // 10
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor13"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor13.txt");
}
// -------------------------------------------------------------------------
void init_selkow_backdoor41(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -------------------------------------------------------------------------
{
    // plus petite forme qui fait planter Selkow1
    // avec un graphe de profondeur 4
    
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  6;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000
    //                                 0123456
    set_ui8vector_str(X[i++], 0, w-1, "1....1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.1111"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111..."); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor41"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor41.txt");
}
// -------------------------------------------------------------------------
void init_selkow_backdoor42(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -------------------------------------------------------------------------
{
    // plus petite forme qui fait planter Selkow2
    
    uint8 **X;
    int i =  0;
    int h =  5;
    int w =  8;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000
    //                                 012345678
    set_ui8vector_str(X[i++], 0, w-1, "1......1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1... 1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.111111"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111....."); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor42"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor42.txt");
}
// -------------------------------------------------------------------------
void init_selkow_backdoor43(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -------------------------------------------------------------------------
{
    // plus petite forme qui fait planter Selkow3
    
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, "1........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1......1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1... 1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1.11111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor43"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_selkow_backdoor43.txt");
}
// -----------------------------------------------------------------------------
void init_forme_backdoor_rampe4(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  5;
    int w =  9;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000
    //                                 0123456789
    set_ui8vector_str(X[i++], 0, w-1, ".......1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".... 1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.111111"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111....."); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor_ramp4"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor_ramp4.txt");
}
// -----------------------------------------------------------------------------
void init_forme_backdoor_rampe5(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------------
{
    // backdoor6 = 8C(backdoor3)
    
    uint8 **X;
    int i =  0;
    int h =  6;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001
    //                                 01234567890
    set_ui8vector_str(X[i++], 0, w-1, ".........1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".......1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, ".....1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1..1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1.11111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "111......."); // 5
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_backdoor_ramp6"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_backdoor_ramp6.txt");
}

// --------------------------------------------------------------
void init_formeM(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  8;
    int w = 10;
    
    X = ui8matrix(    0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000
    //                                 0123456789
    set_ui8vector_str(X[i++], 0, w-1, "........."); // 0
    set_ui8vector_str(X[i++], 0, w-1, ".11...11."); // 1
    set_ui8vector_str(X[i++], 0, w-1, ".111.111."); // 2
    set_ui8vector_str(X[i++], 0, w-1, ".111.111."); // 3
    set_ui8vector_str(X[i++], 0, w-1, "11.111.11"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "11.111.11"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "11..1..11"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "11.....11"); // 7
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_M"); printf("");
    write_ui8matrix_positive  (X, 0, h-1, 0, w-1, 4, "forme_M.txt");
}
// --------------------------------------------------------------
void init_formeU(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  5;
    int w = 12;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1111....1111"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "...1... 1..."); // 1
    set_ui8vector_str(X[i++], 0, w-1, "...1....1..."); // 2
    set_ui8vector_str(X[i++], 0, w-1, "...111111..."); // 3
    set_ui8vector_str(X[i++], 0, w-1, "............"); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "formeU"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "formeU.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i = 0;
    int h = 2;
    int w = 5;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "11111"); // 1
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey1"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey1.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey2(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i = 0;
    int h = 5;
    int w = 7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "......1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "....1.1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "..1.1.1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1.1.1.1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1111111"); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey2"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey2.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey3(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i = 0;
    int h = 7;
    int w = 7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1       1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1     1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1111111"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1  1     "); // 5 
    set_ui8vector_str(X[i++], 0, w-1, "1111     "); // 6
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey3"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey3.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey4(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i = 0;
    int h = 8;
    int w = 9;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 111"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1  1 "); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1111 "); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1  1   "); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 1111   "); // 5 
    set_ui8vector_str(X[i++], 0, w-1, "1  1     "); // 6 
    set_ui8vector_str(X[i++], 0, w-1, "1111     "); // 7 
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey4"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey4.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey5(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  8;
    int w = 17;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1   1 1 1 1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 11111 1 1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1  1 1  1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1111 1111 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1  1     1  1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 1111     1111 1"); // 5 
    set_ui8vector_str(X[i++], 0, w-1, "1  1         1  1"); // 6 
    set_ui8vector_str(X[i++], 0, w-1, "1111         1111"); // 7 
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey5"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey5.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey6(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{
    // a priori plus difficile que Bailey7
    uint8 **X;
    int i =  0;
    int h = 11;
    int w = 17;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "1               1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 1           1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1       1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1   1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 11111 1 1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1  1 1  1 1 1"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1111 1111 1 1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "1 1  1     1  1 1"); // 7
    set_ui8vector_str(X[i++], 0, w-1, "1 1111     1111 1"); // 8 
    set_ui8vector_str(X[i++], 0, w-1, "1  1         1  1"); // 9 
    set_ui8vector_str(X[i++], 0, w-1, "1111         1111"); // 10 
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey6"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey6.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey6b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{
    // a priori plus difficile que Bailey7
    uint8 **X;
    int i =  0;
    int h =  8;
    int w = 17;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "1               1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 1           1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1       1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1   1 1 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 11111 1 1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 1 111   111 1 1"); // 5
    set_ui8vector_str(X[i++], 0, w-1, "1 111       111 1"); // 6
    set_ui8vector_str(X[i++], 0, w-1, "111           111"); // 7
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey6"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey6.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey7(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{
    // a priori plus facile que Bailey6
    uint8 **X;
    int i =  0;
    int h =  8;
    int w = 17;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, "      1   1      "); // 0
    set_ui8vector_str(X[i++], 0, w-1, "    1 11111 1    "); // 1 
    set_ui8vector_str(X[i++], 0, w-1, "  1 1  1 1  1 1  "); // 2
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1111 1111 1 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "1 1  1     1  1 1"); // 4
    set_ui8vector_str(X[i++], 0, w-1, "1 1111     1111 1"); // 5 
    set_ui8vector_str(X[i++], 0, w-1, "1  1         1  1"); // 6 
    set_ui8vector_str(X[i++], 0, w-1, "1111         1111"); // 7 
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey7"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey7.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey8(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  3;
    int w = 19;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000001111111111
    //                                 01234567890123456789
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 1 1 1 1 1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "111 111 111 111 111"); // 1 
    set_ui8vector_str(X[i++], 0, w-1, "  111 111 111 111  "); // 2
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey8"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey8.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey9(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  4;
    int w = 24;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111112222
    //                                 012345678901234567890123
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 1 1 1 1 1 1 1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "111 111 111 111 111 111"); // 1 
    set_ui8vector_str(X[i++], 0, w-1, "  111 111     111 111  "); // 2
    set_ui8vector_str(X[i++], 0, w-1, "        1111111        "); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey9"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey9.txt");
}
// -----------------------------------------------------------------------
void init_forme_Bailey10a(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    uint8 **X;
    int i =  0;
    int h =  5;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000
    //                                 01234567
    set_ui8vector_str(X[i++], 0, w-1, "1     1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1"); // 2 
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey10a"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey10a.txt");
}
// -----------------------------------------------------------------------
void init_forme_Bailey10b(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    // 10b = skrink(10a)
    
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000
    //                                 01234567
    set_ui8vector_str(X[i++], 0, w-1, "1     1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1   1 1"); // 2 
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1"); // 3
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 4
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey10b"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey10b.txt");
}
// -----------------------------------------------------------------------
void init_forme_Bailey10c(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{
    // 10c = skrink(10b)
    
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 00000000
    //                                 01234567
    set_ui8vector_str(X[i++], 0, w-1, "1     1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 2
    
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey10c"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey10c.txt");
}
// ------------------------------------------------------------------------
void init_forme_Bailey4_v1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ------------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  4;
    int w = 11;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "  111111111"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "  1   1   1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111 111 111"); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey4"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey4.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey5_(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1      "); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1     1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey5"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey5.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey6_(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "      1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1     1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 111 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey6"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey6.txt");
}
// ---------------------------------------------------------------------
void init_forme_Bailey7_(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{   
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  7;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000000111
    //                                 0123456789012
    set_ui8vector_str(X[i++], 0, w-1, "1      "); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 111  "); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1 1 1"); // 2
    set_ui8vector_str(X[i++], 0, w-1, "111 111"); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey7"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey7.txt");
}
// -----------------------------------------------------------------------
void init_forme_Bailey_10(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// -----------------------------------------------------------------------
{  
    // 8-connexe
    uint8 **X;
    int i =  0;
    int h =  4;
    int w = 17;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000011111111
    //                                 012345678901234567
    set_ui8vector_str(X[i++], 0, w-1, ".111.111.111.111."); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1...1...1...1...1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1.11..11..11..11."); // 2
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_Bailey2"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_Bailey2.txt");
}
// --------------------------------------------------------------------
void init_forme_ipvs_1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------------
{  
    // 8-connexe
    uint8 **X;
    int i =  0;
    int h =  3;
    int w =  8;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000
    //                                 012345678
    set_ui8vector_str(X[i++], 0, w-1, "1      1"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 11111 "); // 1
    set_ui8vector_str(X[i++], 0, w-1, " 1  1   "); // 2
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_ipvs_1"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_ipvs_1.txt");
}
// --------------------------------------------------------------------
void init_forme_ipvs_2(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// --------------------------------------------------------------------
{  
    // 8-connexe
    uint8 **X;
    int i =  0;
    int h =  4;
    int w =  8;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 000000000
    //                                 012345678
    set_ui8vector_str(X[i++], 0, w-1, "1 111111"); // 0
    set_ui8vector_str(X[i++], 0, w-1, "1 1    1"); // 1
    set_ui8vector_str(X[i++], 0, w-1, "1 1  111"); // 2
    set_ui8vector_str(X[i++], 0, w-1, " 1  1   "); // 3
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_ipvs_2"); printf("");
    write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_ipvs_2.txt");
}
// ---------------------------------------------------------------------
void init_forme_boulon1(uint8 ***X0, int *i0, int *i1, int *j0, int *j1)
// ---------------------------------------------------------------------
{  
    uint8 **X;
    int i =   0;
    int h =  28;
    int w =  30;
    
    X = ui8matrix(0, h-1, 0, w-1);
    zero_ui8matrix(X, 0, h-1, 0, w-1);
    
    *X0 = X;
    *i0 = 0; *i1 = h-1;
    *j0 = 0; *j1 = w-1;
    
    //                                 0000000001111111111122222222223
    //                                 0123456789012345678901234567890
    set_ui8vector_str(X[i++], 0, w-1, "                         111  "); // 00
    set_ui8vector_str(X[i++], 0, w-1, "                        11111 "); // 01
    set_ui8vector_str(X[i++], 0, w-1, "                      1111111 "); // 02
    set_ui8vector_str(X[i++], 0, w-1, "                     11111111 "); // 03
    set_ui8vector_str(X[i++], 0, w-1, "                    1111111111"); // 04
    set_ui8vector_str(X[i++], 0, w-1, "                   11111111111"); // 05
    set_ui8vector_str(X[i++], 0, w-1, "                 1111111111111"); // 06
    set_ui8vector_str(X[i++], 0, w-1, "               11111111111111 "); // 07
    set_ui8vector_str(X[i++], 0, w-1, "              11111111111111  "); // 08
    set_ui8vector_str(X[i++], 0, w-1, "             11111111111111   "); // 09
    set_ui8vector_str(X[i++], 0, w-1, "     11    11111111111111     "); // 10
    set_ui8vector_str(X[i++], 0, w-1, "    111   11111111111111      "); // 11
    set_ui8vector_str(X[i++], 0, w-1, "   11111111111111111111       "); // 12
    set_ui8vector_str(X[i++], 0, w-1, " 11111111111111111111         "); // 13
    set_ui8vector_str(X[i++], 0, w-1, "1111111111111111111           "); // 14
    set_ui8vector_str(X[i++], 0, w-1, " 11111111111111111            "); // 15
    set_ui8vector_str(X[i++], 0, w-1, " 1111111111111111             "); // 16
    set_ui8vector_str(X[i++], 0, w-1, " 111111111111111              "); // 17
    set_ui8vector_str(X[i++], 0, w-1, "  111111111111                "); // 18
    set_ui8vector_str(X[i++], 0, w-1, "  1111111111                  "); // 29
    set_ui8vector_str(X[i++], 0, w-1, "  1111111111                  "); // 20
    set_ui8vector_str(X[i++], 0, w-1, "   111111111                  "); // 21
    set_ui8vector_str(X[i++], 0, w-1, "   111111111                  "); // 22
    set_ui8vector_str(X[i++], 0, w-1, "    11111111                  "); // 23
    set_ui8vector_str(X[i++], 0, w-1, "    1111111                   "); // 24
    set_ui8vector_str(X[i++], 0, w-1, "     11111                    "); // 25
    set_ui8vector_str(X[i++], 0, w-1, "     111                      "); // 26
    set_ui8vector_str(X[i++], 0, w-1, "                              "); // 27
    
    display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_boulon1");
    printf("");
    write_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_boulon1.txt");
}
