/* -------------------------------- */
/* --- ecc_main_rosenfeld_sa.c ---- */
/* -------------------------------- */

// main pour rosenfeld standalone
// version 2014 - 2016

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif

// fichiers generalistes
#include "palette.h"
#include "bmpNR.h"
#include "histogramNR.h"

// fichiers communs pour ecc
#include "ecc_common.h"
#include "ecc_features.h"
#include "ecc_examples.h"
#include "ecc_generation.h"

// algorithme d'ecc
#include "ecc_rosenfeld.h"

// --------------------
void ecc_info_omp(void)
// --------------------
{
#ifdef OPENMP
    printf("OPENMP is ON");
#else
    printf("OPENMP is OFF");
#endif

#ifdef OPENMP2
    printf("OPENMP2 is ON");
#else
    printf("OPENMP2 is OFF");
#endif
    
#ifdef OPENMP4
    printf("OPENMP4 is ON");
#else
    printf("OPENMP4 is OFF");
#endif
}
// --------------------------------------
void main_rosenfeld_forme(char *dst_path)
// --------------------------------------
{
    char *filename;
    
    uint8 **X0, **X;
    uint8 **E8;
    
    uint32 **E32;
    uint32 *S; // Stack for Bailey algorithm
    
    uint32 *T;
    uint32 *A;
    uint32 *N;
    //uint32 *SNE; // memorisation de la somme des ne: sne
    
    int i0, i1, j0, j1;
    int height, width, border = 1;
    uint32 nermax, nemax;
    int na;

    RegionStats *Stats;
    
    RGBQuad palette[256];
    char complete_filename[1024];
    
    
    printf("[----------------------------]");
    printf("[--- main_rosenfeld_forme ---]");
    printf("[----------------------------]");
    
    Palette_18ColorsBW(palette);
    
    // fonction d'init choisir dans ecc_examples.c
    // init et allocation de X0
    //init_forme_backdoor1b(&X0, &i0, &i1, &j0, &j1);
    //init_forme_backdoor2b(&X0, &i0, &i1, &j0, &j1);
    //init_forme_backdoor3b(&X0, &i0, &i1, &j0, &j1);
    init_forme_boulon1(&X0, &i0, &i1, &j0, &j1);

    // allocation memoire
    X   = ui8matrix (i0-border, i1+border, j0-border, j1+border);
    E8  = ui8matrix (i0-border, i1+border, j0-border, j1+border);
    E32 = ui32matrix(i0-border, i1+border, j0-border, j1+border);
 
    // initialisation de la memoire
    zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border);
    zero_ui8matrix (E8,  i0-border, i1+border, j0-border, j1+border);
    zero_ui8matrix (X,   i0-border, i1+border, j0-border, j1+border);

    // pre-traitements
    binarisation_ui8matrix(X0, i0, i1, j0, j1, 1, 1, X);    // pour le traitement
    binarisation_ui8matrix(X0, i0, i1, j0, j1, 1, 255, X0); // pour la verif visuelle
    generate_path_filename(dst_path, "verif.pgm", complete_filename, 1024);
    SavePGM_ui8matrix(X0, i0, i1, j0, j1, complete_filename);
    display_ui8matrix_positive(X, i0, i1, j0, j1, 3, "X");
    
    height = i1 - i0 + 1;
    width = j1 - j0 + 1;
    
    nemax = ((height + 1) * (width + 1)) / 2; // majorant strict
    nermax = (width + 1) / 2;
    
    // alloc init des tables d'equivalences pour UF, Suzuki et Bailey
    T = ui32vector(0, nemax);
    A = ui32vector(0, nemax);
    N = ui32vector(0, nemax);
    
    S = ui32vector(0, 2*nermax);
    
    initT(T, nemax);
    initT(A, nemax);
    initZ(N, nemax);
    
    Stats = RegionStatsVector(0, nemax);
    zero_RegionStatsVector(Stats, 0, nemax);

    // traitement: desactiver FlattenL dans Rosenfeld
    // pour voir l'image d'etiquettes  sans re-etiquetage
    na = Rosenfeld_UF_Org1_4C(X, height, width, E32, T, A, nemax, Stats); ECC_VERBOSE(printf("na = %d\n", na)); filename = "Rosenfeld_UF_Org1_4C.bmp"; mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8); generate_path_filename(dst_path, filename, complete_filename, 1024); SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename); display_ui32matrix_positive(E32,i0, i1, j0, j1, 3, "E1"); zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); display_RegionStatsVector(Stats, 1, na, "Stats"); zero_RegionStatsVector(Stats, 0, nemax);


    na = Rosenfeld_UF_Org1_8C(X, height, width, E32, T, A, nemax, Stats); ECC_VERBOSE(printf("na = %d\n", na)); filename = "Rosenfeld_UF_Org1_8C.bmp"; mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8); generate_path_filename(dst_path, filename, complete_filename, 1024); SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename); display_ui32matrix_positive(E32,i0, i1, j0, j1, 3, "E1"); zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); display_RegionStatsVector(Stats, 1, na, "Stats"); zero_RegionStatsVector(Stats, 0, nemax);


    na = Rosenfeld_UF_Org2_4C(X, height, width, E32, T, A, nemax, Stats); ECC_VERBOSE(printf("na = %d\n", na)); filename = "Rosenfeld_UF_Org2_4C.bmp"; mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8); generate_path_filename(dst_path, filename, complete_filename, 1024); SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename); display_ui32matrix_positive(E32,i0, i1, j0, j1, 3, "E1"); zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); display_RegionStatsVector(Stats, 1, na, "Stats"); zero_RegionStatsVector(Stats, 0, nemax);
    
    // free
    free_ui8matrix (X0,  i0,        i1,        j0,        j1);
    free_ui8matrix (X,   i0-border, i1+border, j0-border, j1+border);
    free_ui8matrix (E8,  i0-border, i1+border, j0-border, j1+border);
    free_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border);
    
    free_ui32vector(T, 0, nemax);
    free_ui32vector(A, 0, nemax);
    free_ui32vector(N, 0, nemax);
    
    free_ui32vector(S, 0, 2*nermax);

    free_RegionStatsVector(Stats, 0, nemax);

    return;
}
// ---------------------------------------------------------------------
void main_rosenfeld_file(char *src_path, char *filename, char *dst_path)
// ---------------------------------------------------------------------
{
    printf("[---------------------------]");
    printf("[--- main_rosenfeld_file ---]");
    printf("[---------------------------]");
    
    char *pathSrc = src_path;
    char *pathDst = dst_path;
    
    uint8 **X0, **X;
    uint8 **E8;
    
    uint32 **E32;
    uint32 *S; // Stack for Bailey algorithm
    
    uint32 *T;
    uint32 *A;
    uint32 *N;
    //uint32 *SNE; // memorisation de la somme des ne: sne

    int i0, i1, j0, j1;
    int height, width, border=1;
    uint32 nemax, nermax;
    int na;
    
    RegionStats * Stats = NULL;

    RGBQuad palette[256];
    char complete_filename[1024];
    
    Palette_18ColorsBW(palette);
    generate_path_filename(pathSrc, filename, complete_filename, 1024);

    // chargement d'une image depuis le disque
    //X0 = LoadPGM_ui8matrix(complete_filename, &i0, &i1, &j0, &j1);
    init_forme_boulon1(&X0, &i0, &i1, &j0, &j1);
    
    // allocation memoire
    X   = ui8matrix (i0 - border, i1 + border, j0 - border, j1 + border);
    E8  = ui8matrix (i0 - border, i1 + border, j0 - border, j1 + border);
    E32 = ui32matrix(i0 - border, i1 + border, j0 - border, j1 + border); 

    // initialisation de la memoire
    zero_ui32matrix(E32, i0 - border, i1 + border, j0 - border, j1 + border);
    zero_ui8matrix (E8,  i0 - border, i1 + border, j0 - border, j1 + border);
    zero_ui8matrix (X,   i0 - border, i1 + border, j0 - border, j1 + border);

    // pre-traitements
    binarisation_ui8matrix(X0, i0, i1, j0, j1, 20, 1, X); // pour le traitement
    //binarisation_ui8matrix(X0, i0, i1, j0, j1, 20, 255, X0); // pour la verif visuelle
    //generate_path_filename(pathDst, "verif.pgm", complete_filename, 1024);
    //SavePGM_ui8matrix(X0, i0, i1, j0, j1, complete_filename);

    height = i1 - i0 + 1;
    width  = j1 - j0 + 1;
    
    nemax = ((height + 1) * (width + 1)) / 2; // majorant strict
    nermax = (width + 1) / 2;
    
    // alloc init des tables d'equivalences pour UF, Suzuki et Bailey
    T = ui32vector(0, nemax);
    A = ui32vector(0, nemax);
    N = ui32vector(0, nemax);
    
    S = ui32vector(0, 2 * nermax);

    initT(T, nemax);
    initT(A, nemax);
    initZ(N, nemax);

    Stats = RegionStatsVector(0, nemax);
    zero_RegionStatsVector(Stats, 0, nemax);

    // traitement: desactiver FlattenL dans Rosenfeld
    // pour voir l'image d'etiquettes  sans re-etiquetage
    /*na = Rosenfeld_UF_Org1_4C    (X, height, width, E32, T, A, nemax, Stats); ECC_VERBOSE(printf("na = %d\n", na)); filename = "Rosenfeld_UF_Org1_4C.bmp";     mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8); generate_path_filename(pathDst, filename, complete_filename); SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename); zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); display_RegionStatsVector(Stats, 1, na, "Stats"); zero_RegionStatsVector(Stats, 0, nemax);*/

    na = Rosenfeld_UF_Org1_8C(X, height, width, E32, T, A, nemax, Stats);
    printf("na = %d\n", na);
    //filename = "Rosenfeld_UF_Org1_8C.bmp";
    mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8);
    //generate_path_filename(pathDst, filename, complete_filename, 1024);
    //SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename);
    zero_ui32matrix(E32, i0 - border, i1 + border, j0 - border, j1 + border);
    display_RegionStatsVector(Stats, 1, na, "Stats");
    zero_RegionStatsVector(Stats, 0, nemax);

    /*na = Rosenfeld_UF_Org2_4C    (X, height, width, E32, T, A, nemax, Stats); ECC_VERBOSE(printf("na = %d\n", na)); filename = "Rosenfeld_UF_Org2_4C.bmp";     mod_ui32matrix_ui8matrix(E32, i0, i1, j0, j1, E8); generate_path_filename(pathDst, filename, complete_filename); SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename); zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); display_RegionStatsVector(Stats, 1, na, "Stats"); zero_RegionStatsVector(Stats, 0, nemax);*/

    free_ui8matrix (X0,  i0,        i1,        j0,        j1);
    free_ui8matrix (X,   i0-border, i1+border, j0-border, j1+border);
    free_ui8matrix (E8,  i0-border, i1+border, j0-border, j1+border);
    free_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border); 
    
    free_ui32vector(T, 0, nemax);
    free_ui32vector(A, 0, nemax);
    free_ui32vector(N, 0, nemax);
    
    free_ui32vector(S, 0, 2*nermax);

    return;
}
// ---------------------------------------
int main_rosenfeld(int argc, char* argv[])
// ---------------------------------------
{
    char *src_path;
    char *filename;
    char *dst_path;
    
    printf("[======================]");
    printf("[=== main_rosenfeld ===]");
    printf("[======================]");
    
    src_path = "./"; // ne pas oublier le / a la fin
    dst_path = "";
    
    filename = "boulons.pgm";
    
    //main_rosenfeld_forme(dst_path);
    main_rosenfeld_file(src_path, filename, dst_path);

    return 0;
}
// -------------------------------------
void display_arg(int argc, char* argv[])
// -------------------------------------
{
    int i;
    
    printf("=================");
    printf("== display_arg ==");
    printf("=================");
    printf("");
    
    printf("argc = %d\n", argc);
    
    for (i = 0; i < argc; i++) {
        printf("%s ", argv[i]);
    }
    printf("");
}
// -----------------------
void ecc_info_define(void)
// -----------------------
{
    printf("=====================");
    printf("== ecc_info_define ==");
    printf("=====================");
    printf("");
    ecc_info_omp();
    //Label_Display_Info();
    printf("");
}
// -----------------------------
int main(int argc, char* argv[])
// -----------------------------
{
#if TARGET_OS==GIET_VM
    giet_tty_alloc(1);
#endif
    display_arg(argc, argv);
    ecc_info_define();
    main_rosenfeld(argc, argv);
    printf("[main]: bye");
    return 0;
}
