/* ------------------------ */
/* --- ecc_generation.c --- */
/* ------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>


#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif


#include "lutNR.h" // pour conversion 0,1 <-> 0,255 

#include "ecc_common.h"
#include "ecc_features.h"

#include "mt19937.h" // Mersenne Twister generator
#include "ecc_generation.h"


// -------------------------------------------------------------------------------------------------------------------------
void generate_granularity_density_float(uint8 **X, int i0, int i1, int j0, int j1, int granularity, float density, int seed)
// -------------------------------------------------------------------------------------------------------------------------
{
    uint8 x;
    int i, j;
    int di, dj;
    
    double r;

    //srand(seed); // pour toujours generer les meme sequences
    init_genrand(seed);

    for(i=i0; i<=i1; i+=granularity) {
        for(j=j0; j<=j1; j+=granularity) {

            //r = 100.0*(double)rand() / rmax;
            //r = 100.0*(double)rand() / rmax;
            r = 100.0*(double)genrand_real2();
            if(r <= density) x = 1; else x = 0;

            for(di=0; di<granularity; di++) {
                for(dj=0; dj<granularity; dj++) {
                    if ((i+di<=i1) && (j+dj<=j1)) X[i+di][j+dj] = x;
                } // dj
            } // di

        } //j
    } // i
}
// ---------------------------------------------------------------------------------------------------------------------
void generate_granularity_density_int(uint8 **X, int i0, int i1, int j0, int j1, int granularity, int density, int seed)
// ---------------------------------------------------------------------------------------------------------------------
{
    generate_granularity_density_float(X, i0, i1, j0, j1, granularity, (float) density, seed);
}
// ---------------------------------------------------------------------------------------------------------
void generate_granularity_density_name(char *name, int granularity, int density, char *filename, int maxlen)
// ---------------------------------------------------------------------------------------------------------
{
    snprintf(filename, maxlen, "%s_%02d_%03d.pgm", name, granularity, density);
}
// ------------------------------------------------------------------------------------------------------------------------------
void generate_granularity_density_ext_name(char *name, int granularity, int density, char *extension, char *filename, int maxlen)
// ------------------------------------------------------------------------------------------------------------------------------
{
    snprintf(filename, maxlen, "%s_%02d_%03d.%s", name, granularity, density, extension);
}
// ------------------------------------------------------------------------------------------------------------------------
void generate_size_granularity_density_name(char *name, int size, int granularity, int density, char *filename, int maxlen)
// ------------------------------------------------------------------------------------------------------------------------
{
    snprintf(filename, maxlen, "%s_%d_%02d_%03d.pgm", name, size, granularity, density);
}
// ---------------------------------------------------------------------------------------------------------------------------------------------
void generate_size_granularity_density_ext_name(char *name, int size, int granularity, int density, char *extension, char *filename, int maxlen)
// ---------------------------------------------------------------------------------------------------------------------------------------------
{
    snprintf(filename, maxlen, "%s_%d_%02d_%03d.%s", name, size, granularity, density, extension);
}
// ---------------------------------------------------------------------------------------------------
void generate_size_granularity_name(char *name, int size, int granularity, char *filename, int maxlen)
// ---------------------------------------------------------------------------------------------------
{
    snprintf(filename, maxlen, "%s_%d_%02d.pgm", name, size, granularity);
}// -----------------------------------------------------------------------------------------
void generate_name100(char *name, int granularity, float density, char *filename, int maxlen)
// ------------------------------------------------------------------------------------------
{
    // density en pourcentage: 0:100
    // mais aussi <1, par exe 0.01
    int d = (int) ceil(100 * density);
    snprintf(filename, maxlen, "%s_%02d_%05d.pgm", name, granularity, d);
}
// ----------------------------------------
int test_generation(int argc, char* argv[])
// ----------------------------------------
{
    uint8 **X;
    uint8 **X255;
    char filename[32];

    int n = 1024;
    int border = 2;

    int d; // density
    int dmin = 5;
    int dmax = 95;
    int dstep = 5;

    int g; // granularity
    int gmin = 1;
    int gmax = 16;

    int seed = 0;

    n = 256;
    n = 2048;
    n = 4096;
    
    X    = ui8matrix(0-border, n-1+border, 0-border, n-1+border);
    X255 = ui8matrix(0-border, n-1+border, 0-border, n-1+border);

    for(g=gmin; g<=gmax; g*=2) {
        for(d=dmin; d<=dmax; d+=dstep) {
            generate_granularity_density_int(X, 0, n-1, 0, n-1, g, d, seed);
            generate_granularity_density_name("I", g, d, filename, 32);
            printf(filename);
            bin2gray_ui8matrix(X, 0, n-1, 0, n-1, X255);
            SavePGM_ui8matrix(X255, 0, n-1, 0, n-1, filename); 
        }
    }
    free_ui8matrix(X,    0-border, n-1+border, 0-border, n-1+border);
    free_ui8matrix(X255, 0-border, n-1+border, 0-border, n-1+border);

    return 0;
}
// -----------------------------------------
void hline(uint8 **X, int i, int j0, int j1)
// -----------------------------------------
{
    int j;
    for(j=j0; j<=j1; j++) X[i][j] = 1;
}
// -----------------------------------------
void vline(uint8 **X, int i0, int i1, int j)
// -----------------------------------------
{
    int i;
    for(i=i0; i<=i1; i++) X[i][j] = 1;
}
// -----------------------------------------------------------
void draw_rectangle(uint8 **X, int i0, int i1, int j0, int j1)
// -----------------------------------------------------------
{
    hline(X, i0, j0, j1);
    vline(X, i0, i1, j0);
    vline(X, i0, i1, j1);
    hline(X, i1, j0, j1);
}
// --------------------------------------------------
void spirale_simple(uint8 **X, int height, int width)
// --------------------------------------------------
{
    int i0, j0; // point de depart haut
    int i1, j1; //point de depart haut
    int c, nc;  // nombre de carres
    int n;      //min(height, width)
    
    zero_ui8matrix(X, 0, height-1, 0, width-1);
    
    if(height<width) {
        n = height;
    } else {
        n = width;
    }
    
    // sans correction
    
    
    // avec correction
    i0 = 0; i1 = 2*(n/2)-1;
    j0 = 0; j1 = 2*(n/2)-1;
    
    nc = n / 4;
    
    for(c=0; c<nc; c++) {
        draw_rectangle(X, i0+2*c, i1-2*c, j0+2*c, j1-2*c);
        X[1+2*c  ][0+2*c  ] = 0;
        X[1+2*c+1][0+2*c+1] = 1;
    }
    
    // centre
    //X[n/2][n/2] = 1;
    for(c=i0+2*nc; c<=i1-2*nc; c++) {
        hline(X, c, j0+2*nc, j1-2*nc);
    }
}
// --------------------------------------------------
void spirale_double(uint8 **X, int height, int width)
// --------------------------------------------------
{
    int i0, j0; // point de depart haut
    int i1, j1; //point de depart haut
    int c, nc;  // nombre de carres
    int n;      //min(height, width)
    
    zero_ui8matrix(X, 0, height-1, 0, width-1);
    
    if(height<width) {
        n = height;
    } else {
        n = width;
    }
    
    // correction
    //n = ((n-1) & (~0x3))+1;
    
    i0 = 0; i1 = 2*(n/2)-1;
    j0 = 0; j1 = 2*(n/2)-1;
    
    nc = n / 4;
    
    for(c=0; c<nc; c++) {
        draw_rectangle(X, i0+2*c, i1-2*c, j0+2*c, j1-2*c);
    }
    for(c=0; c<nc; c++) {
        X[(i0+1)+(2*c  )][(j0)+(2*c  )] = 0;
        X[(i0+1)+(2*c+1)][(j0)+(2*c+1)] = 1;
        
        X[(i1-1)-(2*c  )][(j1)-(2*c  )] = 0;
        X[(i1-1)-(2*c+1)][(j1)-(2*c+1)] = 1;
    }
    // centre
    //X[n/2][n/2] = 1;
    for(c=i0+2*nc; c<=i1-2*nc; c++) {
        hline(X, c, j0+2*nc, j1-2*nc);
    }
}
// ------------------------
void routine_spirale(int n)
// ------------------------
{
    uint8 **X;
    uint8 **X255;
    char filename[128];
    //char *ptr = (char*) filename;
    
    int h, w;
    h = w = n;
    
    X    = ui8matrix(0, h-1, 0, w-1);
    X255 = ui8matrix(0, h-1, 0, w-1);
    
    snprintf(filename, 128, "spirale_simple_%d.pgm", n);
    spirale_simple(X, h, w);
    bin2gray_ui8matrix(X,   0, h-1, 0, w-1, X255);
    SavePGM_ui8matrix(X255, 0, h-1, 0, w-1, filename); 
    
    snprintf(filename, 128, "spirale_double_%d.pgm", n);
    spirale_double(X, h, w);
    bin2gray_ui8matrix(X,   0, h-1, 0, w-1, X255);
    SavePGM_ui8matrix(X255, 0, h-1, 0, w-1, filename);/**/
    
    free_ui8matrix(X,    0, h-1, 0, w-1);
    free_ui8matrix(X255, 0, h-1, 0, w-1);
}
// --------------------------------------
void test_spirale(int argc, char* argv[])
// --------------------------------------
{
    routine_spirale(128);
    routine_spirale(127);
    routine_spirale(126);
    routine_spirale(125);
    
    routine_spirale(256);
    routine_spirale(512);
    routine_spirale(1024);
}
// --------------------------------------------
int test_generation_HGH(int argc, char* argv[])
// --------------------------------------------
{
    uint8 **X;
    uint8 **X255;
    char filename[32];

    int h = 1280;
    int w = 90*1024;

    int border = 2;

    float d = 0.01; // density
    int g = 4; // granularity

    int seed = 0;

    //w = h;

    X    = ui8matrix(0-border, h-1+border, 0-border, w-1+border);
    X255 = ui8matrix(0-border, h-1+border, 0-border, w-1+border);

    generate_granularity_density_float(X, 0, h-1, 0, w-1, g, d, seed);
    generate_granularity_density_name("HGH", g, d, filename, 32);
    printf(filename);
    bin2gray_ui8matrix(X,   0, h-1, 0, w-1, X255);
    SavePGM_ui8matrix(X255, 0, h-1, 0, w-1, filename); 

    free_ui8matrix(X,    0-border, h-1+border, 0-border, w-1+border);
    free_ui8matrix(X255, 0-border, h-1+border, 0-border, w-1+border);

    return 0;
}
// --------------------------------------------
int image_analysis_2014(int argc, char* argv[])
// --------------------------------------------
{
    // uint8 **X;
    // uint8 **X255;

    // char filename[32];

    // uint32 **E32; //algo pixel
    // uint32 **E4; // algo LSL

    // uint32 *T, *A; // tables equivalence

    // // Label *label;

    // uint32 nemax = NEMAX;

    // int neamax = nemax;
    // int ncmax = 10;
    
    // int n = 1024;
    // int height, width;
    // int border = 2;
    // long i0, i1, j0, j1;

    // int d; // density
    // int dmin = 1;
    // int dmax = 99;
    // int dstep = 1;

    // int g; // granularity
    // int gmin = 1;
    // int gmax = 2;
    // int seed = 1;

    // uint32 na;
    // uint32 np_pixel, ne_pixel, na_pixel;
    // uint32 ns_segment, ne_segment, na_segment;
    // uint32 nb_step, nb_concavity;

    // n = 256;
    // n = 1024;
    // //n = 2048;
    // X    = ui8matrix(0-border, n-1+border, 0-border, n-1+border);
    // X255 = ui8matrix(0-border, n-1+border, 0-border, n-1+border);

    // i0 = 0; i1 = n-1; j0 = 0; j1 = n-1;
    // height = n; width = n;     

    // E32 = ui32matrix(i0-border, i1+border, j0-border, j1+border); 
    // E4  = ui32matrix(i0-border, i1+border, j0-border, j1+border); 
    // zero_ui32matrix(E32, i0-border, i1+border, j0-border, j1+border);
    // zero_ui32matrix(E4,  i0-border, i1+border, j0-border, j1+border);

    // T = ui32vector(0, nemax);
    // A = ui32vector(0, nemax);

    // initT(T, nemax);
    // initT(A, nemax);

    // // label = Label_pConstructor_Empty();
    // // Label_Set_ImageB(label, X);
    // // Label_Set_ImageL(label, E4);

    // // Label_Set_Parameters           (label, width, height, neamax, ncmax);
    // // Label_Set_AlgorithmicParameters(label, 32, 8, LABEL_STDZ, LABEL_SELKOW);
    // // Label_Set_Optimisation(label, LABEL_RLEZ);
    // // Label_Initialize(label);
    // //Label_Enable_SecondLabeling(label);

    // printf("image %d x %d\n", n, n);

    // for(g=gmin; g<=gmax; g*=2) {
        
    //     printf("----------------\n");
    //     printf("granulariry = %d\n", g);
    //     printf("----------------\n");

    //     printf("%3s",  "d");

    //     printf("%8s", "np");
    //     printf("%8s", "ne");
    //     printf("%8s", "na");
        
    //     printf("%6s", "");

    //     printf("%8s", "ns");
    //     printf("%8s", "ne");
    //     printf("%8s", "na");

    //     printf("%6s", "");

    //     printf("%8s", "nc");
    //     printf("%8s", "ns");

    //     printf("");
        
    //     for(d=dmin; d<=dmax; d+=dstep) {

    //         zero_ui8matrix(X, 0, n-1, 0, n-1);
    //         zero_ui32matrix(E32, 0, n-1, 0, n-1);
    //         zero_ui32matrix(E4,  0, n-1, 0, n-1);
    //         initT(T, nemax);
    //         initT(A, nemax);
    //         //printf("seed = %d\n", seed);
    //         generate_granularity_density_int(X, 0, n-1, 0, n-1, g, d, seed);

    //         //na = Rosenfeld_Analysis_8C(X, height, width, E32, T, A, nemax, Stats);
    //         na = Rosenfeld_Analysis_8C(X, height, width, E32, T, A, nemax, &np_pixel, &ne_pixel, &na_pixel);
    //         //Label32_Rosenfeld8_Features_SPEED(label);

    //         ns_segment = label->ns;
    //         ne_segment = label->nea;
    //         na_segment = label->na;

    //         nb_concavity = ne_segment - na_segment;
    //         nb_step      = ne_pixel - ne_segment;

    //         printf("%3d", d);

    //         printf("%8d", np_pixel);
    //         printf("%8d", ne_pixel);
    //         printf("%8d", na_pixel);

    //         printf("%6s", "");

    //         printf("%8d", ns_segment);
    //         printf("%8d", ne_segment);
    //         printf("%8d", na_segment);

    //         printf("%6s", "");

    //         printf("%8d", nb_concavity);
    //         printf("%8d", nb_step);

    //         printf("");
    //     }
    //     printf("");
    // }
    // free_ui8matrix(X,    0-border, n-1+border, 0-border, n-1+border);
    // free_ui8matrix(X255, 0-border, n-1+border, 0-border, n-1+border);

    return 0;
}
// --------------------------
void test_generation_mt(void)
// --------------------------
{
    int i, n = 32;
    
    printf("---------------------------");
    printf("-- test_mersenne_twister --");
    printf("---------------------------");

    
    init_genrand(0);
    for(i=0; i<n; i++) {
        printf("%10lu ", genrand_int32());
        if (i%8==7) printf("\n");
    }
    printf("\n---");
    
    init_genrand(1);
    for(i=0; i<n; i++) {
        printf("%10lu ", genrand_int32());
        if (i%8==7) printf("\n");
    }
    printf("\n---");
    
    init_genrand(0);
    for(i=0; i<n; i++) {
        printf("%10lu ", genrand_int32());
        if (i%8==7) printf("\n");
    }
    printf("\n---");
    
    init_genrand(1);
    for(i=0; i<n; i++) {
        printf("%10lu ", genrand_int32());
        if (i%8==7) printf("\n");
    }
}
// -------------------------------------
void image_zoom2(int argc, char *argv[])
// -------------------------------------
{
    uint8 x, **X, **Y;
    int i, j, i0, i1, j0, j1;
    int height, width;
    char *src_filename;
    char *dst_filename;
    
    if(argc<3) {
        printf("too few arguments");
        printf("%s src.pgm dst.pgm\n", argv[0]);
        return;
    }
    
    src_filename = argv[1];
    dst_filename = argv[2];
    
    X = LoadPGM_ui8matrix(src_filename, &i0, &i1, &j0, &j1);
    
    height = i1-i0+1;
    width  = j1-j0+1;
    
    printf("width = %d height = %d\n", width, height);
    
    Y = ui8matrix(0, 2*height-1, 0, 2*width-1);
    
    for(i=0; i<=height-1; i++) {
        for(j=0; j<=width-1; j++) {
            x = X[i][j];
            Y[2*i+0][2*j+0] = x; Y[2*i+0][2*j+1] = x;
            Y[2*i+1][2*j+0] = x; Y[2*i+1][2*j+1] = x;
        }
    }
    SavePGM_ui8matrix(Y, 0, 2*height-1, 0, 2*width-1, dst_filename);
    
    free_ui8matrix(X, 0,   height-1, 0,   width-1);
    free_ui8matrix(Y, 0, 2*height-1, 0, 2*width-1);
}
// --------------------------------------------
void image_duplication2(int argc, char *argv[])
// --------------------------------------------
{
    uint8 x, **X, **Y;
    int i, j, i0, i1, j0, j1;
    int height, width;
    char *src_filename;
    char *dst_filename;
    
    if (argc < 3) {
        printf("too few arguments");
        printf("%s src.pgm dst.pgm\n", argv[0]);
        return;
    }
    
    src_filename = argv[1];
    dst_filename = argv[2];
    
    X = LoadPGM_ui8matrix(src_filename, &i0, &i1, &j0, &j1);
    
    height = i1-i0+1;
    width  = j1-j0+1;
    
    printf("width = %d height = %d\n", width, height);
    
    Y = ui8matrix(0, 2*height-1, 0, 2*width-1);
    
    // horizontal duplication
    for(i=0; i<=height-1; i++) {
        for(j=0; j<=width-1; j++) {
            x = X[i][j];
            Y[i][width+j] = x;
        }
    }
    
    // vertical duplication
    for(i=0; i<=height-1; i++) {
        for(j=0; j<=2*width-1; j++) {
            x = X[i][j];
            Y[height+i][j] = x;
        }
    }
    SavePGM_ui8matrix(Y, 0, 2*height-1, 0, 2*width-1, dst_filename);
    
    free_ui8matrix(X, 0,   height-1, 0,   width-1);
    free_ui8matrix(Y, 0, 2*height-1, 0, 2*width-1);
}
