/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/*************************************************************************/

#define MASTER            0
#define RED_ITER          0
#define BLACK_ITER        1
#define UP                0
#define DOWN              1
#define LEFT              2
#define RIGHT             3
#define UPLEFT            4
#define UPRIGHT           5
#define DOWNLEFT          6
#define DOWNRIGHT         7
#define PAGE_SIZE      4096

#include <user_barrier.h>
#include <user_lock.h>

// macro to use a shared TTY with the GIET_VM
#define printf(...);    { lock_acquire( &tty_lock ); \
                          giet_tty_printf(__VA_ARGS__);  \
                          lock_release( &tty_lock ); }

///////////////////////////////////////////////////////////////////////
//             structures definition
///////////////////////////////////////////////////////////////////////

struct multi_struct 
{
    double err_multi;
};

struct global_struct 
{
    double psiai;
    double psibi;
};

struct Global_Private 
{
    long *     rel_num_x;        // array[numlev]
    long *     rel_num_y;        // array[numlev]
    long *     eist;             // array[numlev]
    long *     ejst;             // array[numlev]
    long *     oist;             // array[numlev]
    long *     ojst;             // array[numlev]
    long *     rlist;            // array[numlev]
    long *     rljst;            // array[numlev]
    long *     rlien;            // array[numlev]
    long *     rljen;            // array[numlev]
    long       rownum;
    long       colnum;
    long       neighbors[8];
    long       total_time;       // total number of cyles in slave()
    long       multi_time;       // number of cycles in multig()
    long       sync_time;        // number of cycles waiting barriers
    long       steps_time[10];   // number of cycles in phases of slave2()
};

///////////////////////////////////////////////////////////////////////
//        extern global variables
///////////////////////////////////////////////////////////////////////

extern struct multi_struct *    multi;
extern struct global_struct *   global;
extern struct Global_Private ** gps;

extern user_lock_t              tty_lock;

extern giet_sqt_barrier_t       barrier;

extern sqt_lock_t               id_lock;
extern sqt_lock_t               psiai_lock;
extern sqt_lock_t               psibi_lock;
extern sqt_lock_t               done_lock;
extern sqt_lock_t               error_lock;
extern sqt_lock_t               bar_lock;

extern double                   eig2;
extern double                   ysca;
extern long                     jmm1;
extern const double             pi;
extern const double             dt0;

extern double ****              psi;
extern double ****              psim;
extern double ***               psium;
extern double ***               psilm;
extern double ***               psib;
extern double ***               ga;
extern double ***               gb;
extern double ****              work1;
extern double ***               work2;
extern double ***               work3;
extern double ****              work4;
extern double ****              work5;
extern double ***               work6;
extern double ****              work7;
extern double ****              temparray;
extern double ***               tauz;
extern double ***               oldga;
extern double ***               oldgb;
extern double *                 f;
extern double ****              q_multi;
extern double ****              rhs_multi;

extern double                   factjacob;
extern double                   factlap;

extern double *                 i_int_coeff;
extern double *                 j_int_coeff;

extern long                     xprocs;
extern long                     yprocs;

extern long                     numlev;

extern long *                   imx;
extern long *                   jmx;
extern double                   tolerance;
extern double *                 lev_res;
extern double *                 lev_tol;
extern const double             maxwork;
extern long *                   xpts_per_proc;
extern long *                   ypts_per_proc;
extern long                     minlevel;
extern const double             outday0;
extern const double             outday1;
extern const double             outday2;
extern const double             outday3;

extern long                     nprocs;

extern const double             h1;
extern const double             h3;
extern const double             h;
extern const double             lf;
extern double                   res;
extern double                   dtau;
extern const double             f0;
extern const double             beta;
extern const double             gpr;
extern long                     oim;
extern long                     im;
extern long                     jm;

/*
 * jacobcalc.C
 */
void jacobcalc (double ***x, double ***y, double ***z, long pid, long firstrow, long lastrow, long firstcol, long lastcol);

/*
 * jacobcalc2.C
 */
void jacobcalc2 (double ****x, double ****y, double ****z, long psiindex, long pid, long firstrow, long lastrow, long firstcol, long lastcol);

/*
 * laplacalc.C
 */
void laplacalc (long procid, double ****x, double ****z, long psiindex, long firstrow, long lastrow, long firstcol, long lastcol);

/*
 * linkup.C
 */
void link_all (void);
void linkup (double **row_ptr);
void link_multi (void);

/*
 * main.C
 */
long log_2 (long number);
void printerr (char *s);

/*
 * multi.C
 */
void multig (long my_id);
void relax (long k, double *err, long color, long my_num);
void rescal (long kf, long my_num);
void intadd (long kc, long my_num);
void putz (long k, long my_num);
void copy_borders (long k, long pid);
void copy_rhs_borders (long k, long procid);
void copy_red (long k, long procid);
void copy_black (long k, long procid);

/*
 * slave1.C
 */
void slave (long *ptr_procid);

/*
 * slave2.C
 */
void slave2 (long procid, long firstrow, long lastrow, long numrows, long firstcol, long lastcol, long numcols);

/*
 * subblock.C
 */
void subblock (void);
