/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/*************************************************************************/

#include <math.h>

#include "decs.h"

///////////////
void subblock()
{
    long i;
    long j;
    long k;
    long xportion;
    long yportion;
    long my_num;

/* Determine starting coord and number of points to process in     */
/* each direction : i in numlev / j in xprocs / k in yprocs        */

    for (i = 0; i < numlev; i++) 
    {
        xportion = (jmx[i] - 2) / xprocs;
        for (j = 0; j < xprocs; j++) 
        {
            for (k = 0; k < yprocs; k++) 
            {
                gps[k * xprocs + j]->rel_num_x[i] = xportion;
            }
        }
        yportion = (imx[i] - 2) / yprocs;
        for (j = 0; j < yprocs; j++) 
        {
            for (k = 0; k < xprocs; k++) 
            {
                gps[j * xprocs + k]->rel_num_y[i] = yportion;
            }
        }
    }

    for (my_num = 0; my_num < nprocs; my_num++) 
    {
        for (i = 0; i < numlev; i++) 
        {
            gps[my_num]->rlist[i] = 1;
            gps[my_num]->rljst[i] = 1;
            gps[my_num]->rlien[i] = gps[my_num]->rlist[i] + gps[my_num]->rel_num_y[i];
            gps[my_num]->rljen[i] = gps[my_num]->rljst[i] + gps[my_num]->rel_num_x[i];
            gps[my_num]->eist[i]  = gps[my_num]->rlist[i] + 1;
            gps[my_num]->oist[i]  = gps[my_num]->rlist[i];
            gps[my_num]->ejst[i]  = gps[my_num]->rljst[i] + 1;
            gps[my_num]->ojst[i]  = gps[my_num]->rljst[i];
        }
    }
    
    for (i = 0; i < nprocs; i++) 
    {
        gps[i]->neighbors[LEFT]      = -1;
        gps[i]->neighbors[RIGHT]     = -1;
        gps[i]->neighbors[UP]        = -1;
        gps[i]->neighbors[DOWN]      = -1;
        gps[i]->neighbors[UPLEFT]    = -1;
        gps[i]->neighbors[UPRIGHT]   = -1;
        gps[i]->neighbors[DOWNLEFT]  = -1;
        gps[i]->neighbors[DOWNRIGHT] = -1;
        
        if (i >= xprocs) 
        {
            gps[i]->neighbors[UP] = i - xprocs;
        }
        if (i < nprocs - xprocs) 
        {
            gps[i]->neighbors[DOWN] = i + xprocs;
        }
        if ((i % xprocs) > 0) 
        {
            gps[i]->neighbors[LEFT] = i - 1;
        }
        if ((i % xprocs) < (xprocs - 1)) 
        {
            gps[i]->neighbors[RIGHT] = i + 1;
        }
        
        j = gps[i]->neighbors[UP];
        
        if (j != -1) 
        {
            if ((j % xprocs) > 0) 
            {
                gps[i]->neighbors[UPLEFT] = j - 1;
            }
            if ((j % xprocs) < (xprocs - 1)) 
            {
                gps[i]->neighbors[UPRIGHT] = j + 1;
            }
        }
        
        j = gps[i]->neighbors[DOWN];
        
        if (j != -1) 
        {
            if ((j % xprocs) > 0) 
            {
                gps[i]->neighbors[DOWNLEFT] = j - 1;
            }
            if ((j % xprocs) < (xprocs - 1)) 
            {
                gps[i]->neighbors[DOWNRIGHT] = j + 1;
            }
        }
    }
    
    for (i = 0; i < nprocs; i++) 
    {
        gps[i]->rownum = i / xprocs;
		gps[i]->colnum = i % xprocs;
    }
}  // end subblock()
