/* ----------------------- */
/* --- mca_rosenfeld.h --- */
/* ----------------------- */

/*
 * Copyright (c) 2016 Lionel Lacassagne, LIP6, UPMC, CNRS
 * Init  : 2016/03/03
 */

// Multi/Many Cores Connected Component Computation en Analysis
// extension of pixel-based and run-based algorithm to manycores with distributed memory

#ifndef __MCA_ROSENFELD_H__
#define __MCA_ROSENFELD_H__

#include "mca.h"

#ifdef __cplusplus
#ifdef VERBOSE_PRAGMA
#pragma message ("C++")
#endif
extern "C" {
#endif

uint32 line0Labeling_Rosenfeld  (uint8 ** X, int i, int width, uint32 ** E, uint32 * T, uint32 ne);
uint32 lineLabeling_DT_Rosenfeld(uint8 ** X, int i, int width, uint32 ** E, uint32 * T, uint32 ne);

uint32 countTable_Range_Rosenfeld(uint32 * T, uint32 e0, uint32 e1);
void   solveTable_Range_Rosenfeld(uint32 * T, uint32 e0, uint32 e1);

void MCA_Label_Rosenfeld(MCA * mca);
    
#ifdef __cplusplus
}
#endif

#endif // __MCA_ROSENFELD_H__

