/* -------------------- */
/* --- matrix_dist.c -- */
/* -------------------- */

// Copyright (c) 2015-2016 Lionel Lacassagne, All Rights Reserved
// Laboratoire d'Informatique de Paris 6 - LIP6
// Universite Pierre et Marie Curie UPMC / CNRS


#include <stdio.h>
#include <stdbool.h> // C99
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif


#include "mca_matrix_dist.h"

// ==================================================================
// === fonctions allocation memoire =================================
// ==================================================================

// ------------------------------------------------------
uint32 ** dist_ui32matrix(int i0, int i1, int j0, int j1)
// ------------------------------------------------------
{
    int i;
    int nrow = i1 - i0 + 1;
    int ncol = j1 - j0 + 1;
    uint32 ** m;
    
    // allocate pointers to rows
    m = (uint32 **) malloc((nrow + 2) * sizeof(uint32 *));
    if (!m) {
        nrerror("allocation failure 1 in dist_ui32matrix()");
    }
    m -= i0;
    m += 1;
    
    // allocate rows and set pointers to them
    m[i0] = (uint32 *) malloc((nrow * ncol + 1) * sizeof(uint32));
    if (!m[i0]) {
        nrerror("allocation failure 2 in dist_ui32matrix()");
    }
    m[i0] -= j0;
    
    for (i = i0 + 1; i <= i1; i++) {
        m[i] = m[i - 1] + ncol;
    }
    
    // make borders to point to first and last lines
    m[i0 - 1] = m[i0];
    m[i1 + 1] = m[i1];
    
    return m;
}


// -------------------------------------------------------------------
void free_dist_ui32matrix(uint32 ** m, int i0, int i1, int j0, int j1)
// -------------------------------------------------------------------
{
    free((FREE_ARG) (m[i0] + j0));
    free((FREE_ARG) (m + i0 - 1));
}

