/* ------------- */
/* --- MCA.h --- */
/* ------------- */

/*
 * Copyright (c) 2016 Lionel Lacassagne, LIP6, UPMC, CNRS
 * Init  : 2016/03/03
 */

// Multi/Many Cores Connected Component Computation en Analysis
// extension of pixel-based and run-based algorithm to manycores with distributed memory

#ifndef __MCA_H__
#define __MCA_H__

#include <user_lock.h>


#ifdef __cplusplus
#ifdef VERBOSE_PRAGMA
#pragma message ("C++")
#endif
extern "C" {
#endif

user_lock_t print_lock;

#define MCA_VERBOSE0(X) ({         \
        lock_acquire(&print_lock); \
        X;                         \
        lock_release(&print_lock); \
        })
#define MCA_VERBOSE1(X) ({         \
        lock_acquire(&print_lock); \
        X;                         \
        lock_release(&print_lock); \
        })


//#define MCA_VERBOSE2(X) X
#define MCA_VERBOSE2(X) 



typedef struct sMCA {
    int p, np;         // numero du processeur et nb total de processeurs
    
    uint8  ** X; // image source
    uint32 ** E; // image d'etiquette 32 bits
    
    int width;
    int height;
    
    int i0, i1;
    int j0, j1;
    
    uint32 e0, e1; // indice pour chaque bande
    uint32 ne; // indice max d'etiquettes utilise par bande

    int alpha; // puissance de 2 >= a la taille d'un bloc
    //uint32 *I;
    uint32  *T; // table d'quivalence table (Rosenfeld) ou d'indices (Warp)
    uint32 **D; // distributed table (instanciee dans chaque worker)
    
    //RegionStats *Stats;
    
    struct sMCA * mca;   // pointeur vers le maitre (pour les esclaves)
    struct sMCA ** mcas; // tableau de pointeurs vers les workers
} MCA;
    
void MCA_Error(char * msg);

MCA * MCA_pConstructor_Empty(void);
MCA * MCA_pDestructor(MCA * mca);

void MCA_Set_ImageX(MCA * mca, uint8  ** X);
void MCA_Set_ImageL(MCA * mca, uint32 ** E);

void   MCA_Set_Size(MCA * mca, int width, int height);
void   MCA_Set_NP(MCA * mca, int np);

uint32 MCA_CalcMaxLabels(int connection, uint32 height, uint32 width);

void MCA_Display_Parameters(MCA *mca);

void MCA_Initialize(MCA * mca);
void MCA_Finalize  (MCA * mca);


// master to workers
void MCA_Scatter_ImageX(MCA * mca);

// workers to master
void MCA_Gather_ImageL(MCA * mca);

// CC run
void MCA_Rosenfeld(MCA * mca);
void MCA_MPar(MCA * mca);
void MCA_Warp(MCA * mca);

#ifdef __cplusplus
}
#endif

#endif // __MCA_H__

