/* ---------------- */
/* --- nrset1.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/* 
* 2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset1.h"

#define isdigit(x) ((x) >= 0x30 && (x) <= 0x39)

/*
 * -------------------
 * --- zero_vector ---
 * -------------------
 */

/* ------------------------------------------------------- */
IMAGE_EXPORT(void) zero_si8vector(sint8 *v, long nl, long nh)
/* ------------------------------------------------------- */
{
	int i;
	for(i=nl; i<=nh; i++) v[i] = 0;
}
/* ------------------------------------------------------- */
IMAGE_EXPORT(void) zero_ui8vector(uint8 *v, long nl, long nh)
/* ------------------------------------------------------- */
{
	int i;
	for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_si16vector(sint16 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_ui16vector(uint16 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
	int i;
	for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_si32vector(sint32 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_ui32vector(uint32 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_si64vector(sint64 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_ui64vector(uint64 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_f32vector(float32 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
	int i;
	for(i=nl; i<=nh; i++) v[i] = 0;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_f64vector(float64 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
	int i;
	for(i=nl; i<=nh; i++) v[i] = 0;
}
/* ------------------------------------------------------- */
IMAGE_EXPORT(void) zero_rgb8vector(rgb8 *v, long nl, long nh)
/* ------------------------------------------------------- */
{
	int i;
	rgb8 z;
	z.r = 0; z.g = 0; z.b = 0;
	for(i=nl; i<=nh; i++) v[i] = z;
}
/* --------------------------------------------------------- */
IMAGE_EXPORT(void) zero_rgbx8vector(rgbx8 *v, long nl, long nh)
/* --------------------------------------------------------- */
{
	int i;
	rgbx8 z;
	z.r = 0; z.g = 0; z.b = 0; z.x = 0;
    for(i=nl; i<=nh; i++) v[i] = z;
}
/*
 * ------------------
 * --- set_vector ---
 * ------------------
 */

/* -------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8vector(sint8 *v, long nl, long nh, sint8 x)
/* -------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++)
        v[i] = x;
}
/* --------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8vector(uint8 *v, long nl, long nh, uint8 x)
/* --------------------------------------------------------------- */
{
    int i;
    for(i=nl; i<=nh; i++)
        v[i] = x;
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_si16vector(sint16 *v, long nl, long nh, sint16 x)
/* ------------------------------------------------------------------ */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_ui16vector(uint16 *v, long nl, long nh, uint16 x)
/* ------------------------------------------------------------------ */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_si32vector(sint32 *v, long nl, long nh, sint32 x)
/* ------------------------------------------------------------------ */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_ui32vector(uint32 *v, long nl, long nh, uint32 x)
/* ------------------------------------------------------------------ */
{
	int i;
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ----------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si64vector(sint64 *v, long nl, long nh, sint64 x)
/* ----------------------------------------------------------------- */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------ */
IMAGE_EXPORT(void) set_ui64vector(uint64 *v, long nl, long nh, uint64 x)
/* ------------------------------------------------------------------ */
{
	int i;
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32vector(float32 *v, long nl, long nh, float32 x)
/* ------------------------------------------------------------------- */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64vector(float64 *v, long nl, long nh, float64 x)
/* ------------------------------------------------------------------- */
{
	int i;	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* -------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8vector(rgb8 *v, long nl, long nh, rgb8 x)
/* -------------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/* ----------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8vector(rgbx8 *v, long nl, long nh, rgbx8 x)
/* ----------------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = x;
}
/*
 * ------------------------
 * --- set_vector_param ---
 * ------------------------
 */
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8vector_param(sint8 *v, long nl, long nh, sint8 x, sint8 xstep)
/* ---------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* ---------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8vector_param(uint8 *v, long nl, long nh, uint8 x, uint8 xstep)
/* ---------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16vector_param(sint16 *v, long nl, long nh, sint16 x, sint16 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16vector_param(uint16 *v, long nl, long nh, uint16 x, uint16 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32vector_param(sint32 *v, long nl, long nh, sint32 x, sint32 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32vector_param(uint32 *v, long nl, long nh, uint32 x, uint32 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si64vector_param(sint64 *v, long nl, long nh, sint64 x, sint64 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* -------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui64vector_param(uint64 *v, long nl, long nh, uint64 x, uint64 xstep)
/* -------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}
/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32vector_param(float32 *v, long nl, long nh, float32 x, float32 xstep)
/* ---------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}/* --------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64vector_param(float64 *v, long nl, long nh, float64 x, float64 xstep)
/* --------------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        x += xstep;
    }
}/* ------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8vector_param(rgb8 *v, long nl, long nh, rgb8 x, rgb8 xstep)
/* ------------------------------------------------------------------------- */
{
    int i;   
    for(i=nl; i<=nh; i++) {
        v[i] = x;
        RGB8_ADD(x, xstep, x);
    }
}/* ----------------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8vector_param(rgbx8 *v, long nl, long nh, rgbx8 x, rgbx8 xstep)
/* ------------------------------------------------------------------------------ */
{
	int i;
	
    for(i=nl; i<=nh; i++) {
		v[i] = x;
        RGB8_ADD(x, xstep, x);
    }
}
/*
 * --------------------
 * --- set_vector_j ---
 * --------------------
 */
/* -------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8vector_j(sint8 *v, long nl, long nh)
/* -------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (sint8) i;
}
/* -------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8vector_j(uint8 *v, long nl, long nh)
/* -------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (uint8) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16vector_j(sint16 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (sint16) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16vector_j(uint16 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (uint16) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32vector_j(sint32 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (sint32) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32vector_j(uint32 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (uint32) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_si64vector_j(sint64 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (sint64) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui64vector_j(uint64 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (uint64) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_f32vector_j(float32 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (float32) i;
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_f64vector_j(float64 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
	for(i=nl; i<=nh; i++)
		v[i] = (float64) i;
}
/* -------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgb8vector_j(rgb8 *v, long nl, long nh)
/* -------------------------------------------------------- */
{
	int i;
	
    for(i=nl; i<=nh; i++) {
		v[i].r = (uint8) i;
        v[i].g = (uint8) i;
        v[i].b = (uint8) i;
    }
}
/* ---------------------------------------------------------- */
IMAGE_EXPORT(void) set_rgbx8vector_j(rgbx8 *v, long nl, long nh)
/* ---------------------------------------------------------- */
{
	int i;
	
    for(i=nl; i<=nh; i++) {
		v[i].r = (uint8) i;
        v[i].g = (uint8) i;
        v[i].b = (uint8) i;
        v[i].x = (uint8) 255;
    }
}

/*
 * ----------------------
 * --- set_vector_str ---
 * ----------------------
 */

/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si8vector_str(sint8 *v, long nl, long nh, char *str)
/* --------------------------------------------------------------------- */
{
	int i;
	char c[1];
	for(i=nl; i<=nh; i++) {

		*c = *str++;
		if(isdigit(*c))
			v[i] = (sint8) atoi(c);
		else
			v[i] = (sint8) 0;
	}
}
/* --------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui8vector_str(uint8 *v, long nl, long nh, char *str)
/* --------------------------------------------------------------------- */
{
    // @QM
	int i;
	char c[2];
    c[1] = '\0';
	for (i = nl; i <= nh; i++) {
		c[0] = *str++;
		if (isdigit(c[0])) {
			v[i] = (uint8) atoi(c);
        }
		else {
			v[i] = (uint8) 0;
        }
	}
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si16vector_str(sint16 *v, long nl, long nh, char *str)
/* ----------------------------------------------------------------------- */
{
    int i;
    char c[1];
    for(i=nl; i<=nh; i++) {
        
        *c = *str++;
        if(isdigit(*c))
            v[i] = (sint16) atoi(c);
        else
            v[i] = (sint16) 0;
    }
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui16vector_str(uint16 *v, long nl, long nh, char *str)
/* ----------------------------------------------------------------------- */
{
    int i;
    char c[1];
    for(i=nl; i<=nh; i++) {
        
        *c = *str++;
        if(isdigit(*c))
            v[i] = (uint16) atoi(c);
        else
            v[i] = (uint16) 0;
    }
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_si32vector_str(sint32 *v, long nl, long nh, char *str)
/* ----------------------------------------------------------------------- */
{
    int i;
    char c[1];
    for(i=nl; i<=nh; i++) {
        
        *c = *str++;
        if(isdigit(*c))
            v[i] = (sint32) atoi(c);
        else
            v[i] = (sint32) 0;
    }
}
/* ----------------------------------------------------------------------- */
IMAGE_EXPORT(void) set_ui32vector_str(uint32 *v, long nl, long nh, char *str)
/* ----------------------------------------------------------------------- */
{
    int i;
    char c[1];
    for(i=nl; i<=nh; i++) {
        
        *c = *str++;
        if(isdigit(*c))
            v[i] = (uint32) atoi(c);
        else
            v[i] = (uint32) 0;
    }
}
