/* --------------- */
/* --- nrio1.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nrio0.h"
#include "nrio1.h"

/*
 * ----------------------
 * --- display_vector ---
 * ----------------------
 */

/* ------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bvector(byte *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8vector(sint8 *v,long nl,long nh, char *format, char *name)
/* ---------------------------------------------------------------------------------- */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8vector(uint8 *v,long nl,long nh, char *format, char *name)
/* ---------------------------------------------------------------------------------- */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si16vector(sint16 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16vector(uint16 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si32vector(sint32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui32vector(uint32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si64vector(sint64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui64vector(uint64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
  long i;

  if(name != NULL) printf("%s", name);

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f32vector(float32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_f64vector(float64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}
/* ---------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8vector(rgb8 *v,long nl,long nh, char *format, char *name)
/* ---------------------------------------------------------------------------------- */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}
/* ------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_rgbx8vector(rgbx8 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------ */
{
    long i;
    
    if(name != NULL) printf("%s", name);
    
    for(i=nl; i<=nh; i++) {
        printf(format, v[i]);
    }
    printf("\n");
}

/*
 * -----------------------------
 * --- display_vector_number ---
 * -----------------------------
 */

/* -------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_bvector_number(byte *v,long nl,long nh, char *format, char *name)
/* -------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8vector_number(sint8 *v,long nl,long nh, char *format, char *name)
/* ----------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf(name);
  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8vector_number(uint8 *v,long nl,long nh, char *format, char *name)
/* ----------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf(name);
  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16vector_number(sint16 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf(name);
  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16vector_number(uint16 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf(name);
  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si32vector_number(sint32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32vector_number(uint32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
    printf(" ");
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
    printf(" ");
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si64vector_number(sint64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui64vector_number(uint64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32vector_number(float32 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f64vector_number(float64 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ----------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8vector_number(rgb8 *v,long nl,long nh, char *format, char *name)
/* ----------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/* ------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgbx8vector_number(rgbx8 *v,long nl,long nh, char *format, char *name)
/* ------------------------------------------------------------------------------------------- */
{
  long i;

  if(name != NULL) printf("%s\n", name);

  for(i=nl; i<=nh; i++) {
    printf(format, i);
  }
  printf("\n");

  for(i=nl; i<=nh; i++) {
    printf(format, v[i]);
  }
  printf("\n");
}
/*
 * ------------------------
 * --- display_vector_T ---
 * ------------------------
 */

/* ----------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si8vector_T(sint8 *v,int i0, int i1, char *format, char *name)
/* ----------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ----------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui8vector_T(uint8 *v,int i0, int i1, char *format, char *name)
/* ----------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16vector_T(sint16 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16vector_T(uint16 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si32vector_T(sint32 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32vector_T(uint32 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si64vector_T(sint64 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui64vector_T(uint64 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32vector_T(float32 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f64vector_T(float64 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ----------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgb8vector_T(rgb8 *v,int i0, int i1, char *format, char *name)
/* ----------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgbx8vector_T(rgbx8 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf(format, v[i]);
        printf("\n");
    }
}

/*
 * -------------------------------
 * --- display_vector_number_T ---
 * -------------------------------
 */

/* ------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_si8vector_number_T(sint8 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------------ */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_ui8vector_number_T(uint8 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------------ */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si16vector_number_T(sint16 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui16vector_number_T(uint16 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si32vector_number_T(sint32 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui32vector_number_T(uint32 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_si64vector_number_T(sint64 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_ui64vector_number_T(uint64 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f32vector_number_T(float32 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {  
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_f64vector_number_T(float64 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* ------------------------------------------------------------------------------------------ */
IMAGE_EXPORT(void) display_rgb8vector_number_T(rgb8 *v,int i0, int i1, char *format, char *name)
/* ------------------------------------------------------------------------------------------ */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}
/* -------------------------------------------------------------------------------------------- */
IMAGE_EXPORT(void) display_rgbx8vector_number_T(rgbx8 *v,int i0, int i1, char *format, char *name)
/* -------------------------------------------------------------------------------------------- */
{
    int i;
    
    if(name != NULL) printf(name);
    
    for(i=i0; i<=i1; i++) {           
        printf("%8d ", i);
        printf(format, v[i]);
        printf("\n");
    }
}

/*
 * -------------------------------
 * --- display_vector_positive ---
 * -------------------------------
 */

// -------------------------------------------------------------------------------
void display_ui8vector_positive(uint8 *v, int j0, int j1, int iformat, char *name)
// -------------------------------------------------------------------------------
{
    int j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(j=j0; j<=j1; j++) {
        if(v[j]) {
            printf(format, v[j]);
        } else {
            printf("%s", str);
        }
    }
    printf("\n");
}

// ---------------------------------------------------------------------------------
void display_ui16vector_positive(uint16 *v, int j0, int j1, int iformat, char *name)
// ---------------------------------------------------------------------------------
{
    int j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(j=j0; j<=j1; j++) {
        if(v[j]) {
            printf(format, v[j]);
        } else {
            printf("%s", str);
        }
    }
    printf("\n");
}
// ---------------------------------------------------------------------------------
void display_ui32vector_positive(uint32 *v, int j0, int j1, int iformat, char *name)
// ---------------------------------------------------------------------------------
{
    int j;
    char *format, *str;
    
    select_display_positive_parameters(iformat, &format, &str);
    
    if(name != NULL) printf(name);
    
    for(j=j0; j<=j1; j++) {
        if(v[j]) {
            printf(format, v[j]);
        } else {
            printf("%s", str);
        }
    }
    printf("\n");
}
