/* ------------------ */
/* --- mca_test.c --- */
/* ------------------ */

/*
 * Copyright (c) 2016 Lionel Lacassagne, LIP6, UPMC, CNRS
 * Init  : 2016/03/03
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <user_barrier.h>

#ifdef CLI
#include "nrc_os_config.h"
#include "nrc.h"
#endif



#include "util.h"
#include "ecc_common.h"
#include "ecc_features.h"
#include "palette.h"
#include "bmpNR.h"
#include "mca_matrix_dist.h"
#include "mca_rosenfeld.h"


/* -- local -- */
#include "mca.h"
#include "mca_test.h"

#define DEFAULT_NTHREADS 4
#define MAX_THREADS 256

pthread_t thread_table[MAX_THREADS];

giet_barrier_t main_barrier;

int num_threads = DEFAULT_NTHREADS;

// --------------------------------------------------------------------------
void init_forme_boulon1(uint8 *** X0, int * i0, int * i1, int * j0, int * j1)
// --------------------------------------------------------------------------
{
    uint8 ** X;
    int i =  0;
    int h =  28;
    int w =  30;
    
    X = ui8matrix(0, h - 1, 0, w - 1);
    zero_ui8matrix(X, 0, h - 1, 0, w - 1);
    
    *X0 = X;
    *i0 = 0;
    *i1 = h - 1;
    *j0 = 0;
    *j1 = w - 1;
    
    //                                 0000000001111111111122222222223
    //                                 0123456789012345678901234567890
    set_ui8vector_str(X[i++], 0, w - 1, "                         111  "); // 00
    set_ui8vector_str(X[i++], 0, w - 1, "                        11111 "); // 01
    set_ui8vector_str(X[i++], 0, w - 1, "                      1111111 "); // 02
    set_ui8vector_str(X[i++], 0, w - 1, "                     11111111 "); // 03
    set_ui8vector_str(X[i++], 0, w - 1, "                    1111111111"); // 04
    set_ui8vector_str(X[i++], 0, w - 1, "                   11111111111"); // 05
    set_ui8vector_str(X[i++], 0, w - 1, "                 1111111111111"); // 06
    set_ui8vector_str(X[i++], 0, w - 1, "               11111111111111 "); // 07
    set_ui8vector_str(X[i++], 0, w - 1, "              11111111111111  "); // 08
    set_ui8vector_str(X[i++], 0, w - 1, "             11111111111111   "); // 09
    set_ui8vector_str(X[i++], 0, w - 1, "     11    11111111111111     "); // 10
    set_ui8vector_str(X[i++], 0, w - 1, "    111   11111111111111      "); // 11
    set_ui8vector_str(X[i++], 0, w - 1, "   11111111111111111111       "); // 12
    set_ui8vector_str(X[i++], 0, w - 1, " 11111111111111111111         "); // 13
    set_ui8vector_str(X[i++], 0, w - 1, "1111111111111111111           "); // 14
    set_ui8vector_str(X[i++], 0, w - 1, " 11111111111111111            "); // 15
    set_ui8vector_str(X[i++], 0, w - 1, " 1111111111111111             "); // 16
    set_ui8vector_str(X[i++], 0, w - 1, " 111111111111111              "); // 17
    set_ui8vector_str(X[i++], 0, w - 1, "  111111111111                "); // 18
    set_ui8vector_str(X[i++], 0, w - 1, "  1111111111                  "); // 29
    set_ui8vector_str(X[i++], 0, w - 1, "  1111111111                  "); // 20
    set_ui8vector_str(X[i++], 0, w - 1, "   111111111                  "); // 21
    set_ui8vector_str(X[i++], 0, w - 1, "   111111111                  "); // 22
    set_ui8vector_str(X[i++], 0, w - 1, "    11111111                  "); // 23
    set_ui8vector_str(X[i++], 0, w - 1, "    1111111                   "); // 24
    set_ui8vector_str(X[i++], 0, w - 1, "     11111                    "); // 25
    set_ui8vector_str(X[i++], 0, w - 1, "     111                      "); // 26
    set_ui8vector_str(X[i++], 0, w - 1, "                              "); // 27
    
    //printf("[init_forme_boulon1]: h = %d i = %d\n", h, i);
    if (i != h) {
        MCA_Error("init_forme_boulon1 i != h");
    }

    
    //display_ui8matrix_positive(X, 0, h-1, 0, w-1, 4, "forme_boulon1"); printf("");
    //write_ui8matrix_positive(  X, 0, h-1, 0, w-1, 4, "forme_boulon1.txt");
}


// -----------------
void mca_test1(void)
// -----------------
{
    int i0, i1, j0, j1;
    int height, width;
    
    uint8 ** X0;
    uint8 ** X;
    uint32 ** E;
    MCA * mca;

    barrier_init(&main_barrier, num_threads);

    // -- Allocation --
    init_forme_boulon1(&X0, &i0, &i1, &j0, &j1);
    
    height = i1 - i0 + 1;
    width  = j1 - j0 + 1;
    
    // @QM à quoi sert X ??
    X = ui8matrix (i0, i1, j0, j1);
    E = ui32matrix(i0, i1, j0, j1);
    
    zero_ui32matrix(E, i0, i1, j0, j1);
    zero_ui8matrix (X, i0, i1, j0, j1);
    
    mca = MCA_pConstructor_Empty();
    
    // -- set param
    MCA_Set_Size(mca, width, height);
    MCA_Set_ImageX(mca, X0);
    MCA_Set_ImageL(mca, E);
    MCA_Set_NP(mca, num_threads);
    
    // -- MCA init
    MCA_Initialize(mca);
    MCA_Display_Parameters(mca);
    
    display_ui8matrix_positive(mca->X, i0, i1, j0, j1, 5, "X0");
    for (int i = 1; i < num_threads; i++) {
        giet_pthread_create(&thread_table[i], NULL, MCA_Label_Rosenfeld, (void *) mca->mcas[i]);
    }
    MCA_Label_Rosenfeld(mca->mcas[0]);
    for (int i = 1; i < num_threads; i++) {
        giet_pthread_join(thread_table[i], NULL);
    }
    display_ui32matrix_positive(mca->E, i0, i1, j0, j1, 5, "Efinal");

    
    // -- free --
    printf("Finalize\n");
    MCA_Finalize(mca);
    
    printf("Free_matrix\n");
    free_ui8matrix (X0, i0, i1, j0, j1);
    free_ui8matrix (X,  i0, i1, j0, j1);
    free_ui32matrix(E,  i0, i1, j0, j1);
}



// -----------------
void mca_test2(void)
// -----------------
{
    int i0, i1, j0, j1;
    int height, width;
    
    uint8 ** X0;
    uint8 ** X;
    uint8 ** E8;
    uint32 ** E;
    MCA * mca;

    char * pathSrc = "/misc/";
    char * pathDst = "";
    char * filename = "boulons.pgm";

    //RegionStats * Stats = NULL;
    RGBQuad palette[256];
    char complete_filename[1024];

    barrier_init(&main_barrier, num_threads);

    Palette_18ColorsBW(palette);
    generate_path_filename(pathSrc, filename, complete_filename, 1024);
    
    printf("Loading file %s... ", filename);
    X0 = LoadPGM_ui8matrix(complete_filename, &i0, &i1, &j0, &j1);
    printf("done.\n");

    printf("Allocating memory... ");
    height = i1 - i0 + 1;
    width  = j1 - j0 + 1;
    
    X  = ui8matrix (i0, i1, j0, j1);
    E8 = ui8matrix (i0, i1, j0, j1);
    E  = ui32matrix(i0, i1, j0, j1);
    
    zero_ui32matrix(E, i0, i1, j0, j1);
    zero_ui8matrix(E8, i0, i1, j0, j1);
    zero_ui8matrix(X,  i0, i1, j0, j1);

    // pre-traitements
    binarisation_ui8matrix(X0, i0, i1, j0, j1, 20, 1, X); // pour le traitement
    binarisation_ui8matrix(X0, i0, i1, j0, j1, 20, 255, X0); // pour la verif visuelle
    printf("done.\n");

    generate_path_filename(pathDst, "verif.pgm", complete_filename, 1024);
    printf("Saving file %s for verification... ", complete_filename);
    SavePGM_ui8matrix(X0, i0, i1, j0, j1, complete_filename);
    printf("done.\n");


    printf("Allocating and initializing MCA... \n");
    mca = MCA_pConstructor_Empty();
    
    // -- set param
    MCA_Set_Size(mca, width, height);
    MCA_Set_ImageX(mca, X);
    MCA_Set_ImageL(mca, E);
    MCA_Set_NP(mca, num_threads);
    
    // -- MCA init
    MCA_Initialize(mca);
    MCA_Display_Parameters(mca);
    printf("End of MCA allocation and initialization.\n");
    
    //display_ui8matrix_positive(mca->X, i0, i1, j0, j1, 5, "X0");
    for (int i = 1; i < num_threads; i++) {
        giet_pthread_create(&thread_table[i], NULL, MCA_Label_Rosenfeld, (void *) mca->mcas[i]);
    }
    MCA_Label_Rosenfeld(mca->mcas[0]);
    for (int i = 1; i < num_threads; i++) {
        giet_pthread_join(thread_table[i], NULL);
    }
    //display_ui32matrix_positive(mca->E, i0, i1, j0, j1, 5, "Efinal");
    mod_ui32matrix_ui8matrix(mca->E, i0, i1, j0, j1, E8);
    generate_path_filename(pathDst, "verif_final.bmp", complete_filename, 1024);
    printf("Saving file %s for verification... ", complete_filename);
    SaveBMP2_ui8matrix(E8, width, height, palette, complete_filename);
    printf("done.\n");


    
    // -- free --
    MCA_Finalize(mca);
    printf("Deallocating memory...");
    free_ui8matrix (X0, i0, i1, j0, j1);
    free_ui8matrix (X,  i0, i1, j0, j1);
    free_ui32matrix(E,  i0, i1, j0, j1);
    printf("done.\n");

    //free_RegionStatsVector(Stats, 0, nemax);
}




// --------------------------------------
int main_test_mca()
// --------------------------------------
{
    printf("===================\n");
    printf("== main_test_mca ==\n");
    printf("===================\n");
    
    mca_test2();
    
    return 0;
}

