/* -------------------- */
/* --- ecc_common.h --- */
/* -------------------- */

#ifndef _ECC_COMMON_H_
#define _ECC_COMMON_H_

#include <stdbool.h>

// ------------------------------------------
// -- valeur des parametres des benchmarks --
// ------------------------------------------  

#define ECC_G0  1
#define ECC_G1 16
#define ECC_GS  1
    
#define ECC_D0   0
#define ECC_D1 100
#define ECC_DS   1
#define ECC_DSCALE 1
    
//#define ECC_SIZE 2048
#define ECC_SIZE 2048
//#endif // ENABLE_GLOBAL_PARAM
    

#define ITER 25
#define RUN 10
#define HEIGHT  2048
#define WIDTH   2048
#define NEMAX HEIGHT*WIDTH/4

#define INTEL
//#define POWERPC

#define ECC_DEBUG(X)
//#define ECC_DEBUG(X) X

//#define ECC_VERBOSE(X)
#define ECC_VERBOSE(X) X

#define ECC_VERBOSE2(X)
//#define ECC_VERBOSE2(X) X

#define SOLVE(X) X
#define ECC_SOLVE(X) X

#define LABEL2(X) X
#define ECC_LABEL2(X) X

//#define FEATURES(X) X 
#define ECC_FEATURES(X) X

#define ECC_CHECK(ne, nemax)
//#define ECC_CHECK(ne, nemax) if(ne>=nemax) {printf("Error ne >= %d\n", nemax); exit(-1);}

//#define BENCH(X,dc) t0=dcycle();X;t1=dcycle(); dc=(t1-t0)/(double)(height*width)

//#define BENCH(X,dc) t0=dtime();X;t1=dtime(); dc=(t1-t0)*FREQ/(double)(height*width)
//#define BENCH(X,dc) for(r=0; r<RUN; r++) {tmin = 1e30; t0=dtime(); for(i=0; i<ITER; i++) { X; } t1=dtime(); dt=(t1-t0); if(dt<tmin) tmin = dt;} dc=tmin*FREQ/(double)(ITER*height*width)

#define DUP2(X) X; X; X; X
#define DUP3(X) X; X; X; X
#define DUP4(X) X; X; X; X
#define DUP10(X) X; X; X; X; X; X; X; X; X; X

#define BENCH10_WHILE(X, c) \
do {                \
double t0, t1, dt;  \
t0 = _rdtsc();      \
DUP10(X);           \
t1 = _rdtsc();      \
dt = t1-t0;         \
c = dt/10.0;        \
} while(0)

#define BENCH4_WHILE(X, c) \
do {                \
double t0, t1, dt;  \
t0 = _rdtsc();      \
DUP4(X);            \
t1 = _rdtsc();      \
dt = t1-t0;         \
c = dt/4.0;         \
} while(0)
    
#define BENCH1_WHILE(X, c) \
do {                \
double t0, t1, dt;  \
t0 = _rdtsc();      \
X;                  \
t1 = _rdtsc();      \
dt = t1-t0;         \
c = dt/1.0;         \
} while(0)


#define BENCH_VAR(X, c) \
t0 = _rdtsc();      \
X;                  \
t1 = _rdtsc();      \
dt = t1-t0;         \
c = dt

//#define BENCH(X, c) BENCH10_WHILE(X, c)
//#define BENCH(X, c) BENCH1_WHILE(X, c)
#define BENCH(X, c) BENCH4_WHILE(X, c)

#define BENCH_RUN(X, c)      \
do {                         \
    int r, run = 4;          \
    double t, tmin = 1e30;   \
    for(r=0 r<run; r++) {    \
        BENCH4_WHILE(X, t);  \
        if(t<tmin) tmin = t; \
    }                        \
    c = tmin;                \
} while(0)

// pour simplifier le debug: variables globales pour eviter de changer la liste d'arguments


//#define ENABLE_GLOBAL_DEBUG
#ifdef ENABLE_GLOBAL_DEBUG
#define GLOBAL_DEBUG(X) X
#else
#define GLOBAL_DEBUG(X) 
#endif
    
#ifdef ENABLE_GLOBAL_DEBUG
// variables globales externes pour log de configurations particulieres
extern int g_density;
extern int g_granularity;
extern int g_iter;
extern int g_i;
extern int g_j;
    
extern int g_p;
extern uint32 g_ne;
extern uint32 g_ne_start;
extern uint32 g_ne_end;  
#endif
    
//#define ENABLE_CHECK_DEBUG
#ifdef ENABLE_CHECK_DEBUG
#define CHECK_DEBUG(X) X
#else
#define CHECK_DEBUG(X) 
#endif
    
uint32 ui32Max2(uint32 a, uint32 b);
uint32 ui32Max3(uint32 a, uint32 b, uint32 c);
uint32 ui32Max4(uint32 a, uint32 b, uint32 c, uint32 d);
    
uint32 ui32Min2(uint32 a, uint32 b);
uint32 ui32Min3(uint32 a, uint32 b, uint32 c);
uint32 ui32Min4(uint32 a, uint32 b, uint32 c, uint32 d);

// retourne le monimum positif d'un ensemble de points
uint32 ui32MinNonNul2(uint32 a0, uint32 a1);
uint32 ui32MinNonNul3(uint32 a0, uint32 a1, uint32 a2);
uint32 ui32MinNonNul4(uint32 a0, uint32 a1, uint32 a2, uint32 a3);
uint32 ui32MinNonNul5(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4);
uint32 ui32MinNonNul8(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7);
uint32 ui32MinNonNul9(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7, uint32 a8);

// retourne le minimum positif, si le point central est non nul
uint32 ui32MinNonNul3Cond(uint32 a0, uint32 a1, uint32 a2);
uint32 ui32MinNonNul5Cond(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4);
uint32 ui32MinNonNul9Cond(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7, uint32 a8);

void initT(uint32 *T, uint32 nemax); // T[i] = i
//void initA(uint32 *A, uint32 nemax);
void initZ(uint32 *T, uint32 nemax);// T[i] = 0
    
void check_initT(uint32 *T, uint32 nemax);    
void check_initZ(uint32 *T, uint32 nemax);

void check_initT_range(uint32 *T, uint32 i0, uint32 ii, uint32 i1);
void check_initR_range(uint32 *T, uint32 i0, uint32 ii, uint32 i1);
void check_initZ_range(uint32 *T, uint32 i0, uint32 ii, uint32 i1);
    
void applyTable(uint32 **X, int height, int width, uint32 *T, uint32 **Y);
void binarisation_ui8matrix(uint8 **X, int i0, int i1, int j0, int j1, uint8 seuil, uint8 val, uint8 **Y);

void graphviz_write_ui8vector (uint8  *v, int i0, int i1, char *format, char *filename);
void graphviz_write_ui16vector(uint16 *v, int i0, int i1, char *format, char *filename);
void graphviz_write_ui32vector(uint32 *v, int i0, int i1, char *format, char *filename);

void          mod_ui32matrix_ui8matrix(uint32 **X, int i0, int i1, int j0, int j1, uint8 **Y);
void positive_mod_ui32matrix_ui8matrix(uint32 **X, int i0, int i1, int j0, int j1, uint8 **Y);

uint32 mt19937_uint32(uint32 a, uint32 b);
    
bool strto_Bool(char *str);

void check_no_write(uint32 **T, int i0, int i1, int j0, int j1);

#ifdef __cplusplus
}
#endif

#endif // _ECC_COMMON_H_
