/* -------------------- */
/* --- ecc_common.c --- */
/* -------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "nrc_os_config.h"
#include "nrc.h"

#if TARGET_OS == LINUX
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <fcntl.h>
#endif


#include "ecc_common.h"
#include "mt19937.h"

#ifdef ENABLE_GLOBAL_DEBUG
// variables globales externes pour log de configurations particulieres
int g_density;
int g_granularity;
int g_iter;
int g_i;
int g_j;

int g_p;
uint32 g_ne;
uint32 g_ne_start;
uint32 g_ne_end;  
#endif


// --------------------------------
uint32 ui32Max2(uint32 a, uint32 b)
// --------------------------------
{
    return (a > b ? a : b);
}


// ------------------------------------------
uint32 ui32Max3(uint32 a, uint32 b, uint32 c)
// ------------------------------------------
{
    return ui32Max2(ui32Max2(a, b), c);
}


// ----------------------------------------------------
uint32 ui32Max4(uint32 a, uint32 b, uint32 c, uint32 d)
// ----------------------------------------------------
{
    return ui32Max2(ui32Max2(a, b), ui32Max2(c,d));
}


// --------------------------------
uint32 ui32Min2(uint32 a, uint32 b)
// --------------------------------
{
    return (a < b ? a : b);
}


// ------------------------------------------
uint32 ui32Min3(uint32 a, uint32 b, uint32 c)
// ------------------------------------------
{
    return ui32Min2(ui32Min2(a, b), c);
}


// ----------------------------------------------------
uint32 ui32Min4(uint32 a, uint32 b, uint32 c, uint32 d)
// ----------------------------------------------------
{
    return ui32Min2(ui32Min2(a, b), ui32Min2(c,d));
}


/* ----------------------------------- */
uint32 ui32MinNonNul2(uint32 a, uint32 b)
/* ----------------------------------- */
{
    if (a && b)
        return (a < b ? a : b);
    if (a == 0)
        return b;
    return a;
}


/* --------------------------------------------- */
uint32 ui32MinNonNul3(uint32 a, uint32 b, uint32 c)
/* --------------------------------------------- */
{
    uint32 m = 0xffffffff;
    
    if (a) m = a;
    if (b && (b<m)) m = b;
    if (c && (c<m)) m = c;
    
    return m;
}


/* ---------------------------------------------------- */
uint32 ui32MinNonNul3Cond(uint32 a0, uint32 a1, uint32 a2)
/* ---------------------------------------------------- */
{
    uint32 m = 0;
    
    if (a1) m = ui32MinNonNul3(a0, a1, a2);
    return m;
}


/* ----------------------------------------------------------- */
uint32 ui32MinNonNul4(uint32 a0, uint32 a1, uint32 a2, uint32 a3)
/* ----------------------------------------------------------- */
{
    uint32 m = 0xffffffff;
    
    if (a0) m = a0;
    if (a1 && (a1<m)) m = a1;
    if (a2 && (a2<m)) m = a2;
    if (a3 && (a3<m)) m = a3;

    return m;
}


/* ---------------------------------------------------------------------- */
uint32 ui32MinNonNul5(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4)
/* ---------------------------------------------------------------------- */
{
    uint32 m = 0xffffffff;
    
    if (a0) m = a0;
    if (a1 && (a1<m)) m = a1;
    if (a2 && (a2<m)) m = a2;
    if (a3 && (a3<m)) m = a3;
    if (a4 && (a4<m)) m = a4;

    return m;
}


/* -------------------------------------------------------------------------- */
uint32 ui32MinNonNul5Cond(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4)
/* -------------------------------------------------------------------------- */
{
    uint32 m = 0;
    
    if (a2) m = ui32MinNonNul5(a0, a1, a2, a3, a4);
    return m;
}


/* ------------------------------------------------------------------------------------------------------- */
uint32 ui32MinNonNul8(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7)
/* ------------------------------------------------------------------------------------------------------- */
{
    uint32 m = 0xffffffff;
    
    if (a0) m = a0;
    if (a1 && (a1<m)) m = a1;
    if (a2 && (a2<m)) m = a2;
    if (a3 && (a3<m)) m = a3;
    if (a4 && (a4<m)) m = a4;
    if (a5 && (a5<m)) m = a5;
    if (a6 && (a6<m)) m = a6;
    if (a7 && (a7<m)) m = a7;
    
    return m;
}


/* ------------------------------------------------------------------------------------------------------------------ */
uint32 ui32MinNonNul9(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7, uint32 a8)
/* ------------------------------------------------------------------------------------------------------------------ */
{
    uint32 m = 0xffffffff;
    
    if (a0) m = a0;
    if (a1 && (a1<m)) m = a1;
    if (a2 && (a2<m)) m = a2;
    if (a3 && (a3<m)) m = a3;
    if (a4 && (a4<m)) m = a4;
    if (a5 && (a5<m)) m = a5;
    if (a6 && (a6<m)) m = a6;
    if (a7 && (a7<m)) m = a7;
    if (a8 && (a8<m)) m = a8;
    
    return m;
}


/* ---------------------------------------------------------------------------------------------------------------------- */
uint32 ui32MinNonNul9Cond(uint32 a0, uint32 a1, uint32 a2, uint32 a3, uint32 a4, uint32 a5, uint32 a6, uint32 a7, uint32 a8)
/* ---------------------------------------------------------------------------------------------------------------------- */
{
    // a0  b0  c0
    // a1  b1  c1
    // a2  b2  c2
    
    uint32 m = 0;
    
    if (a4) m = ui32MinNonNul9(a0, a1, a2, a3, a4, a5, a6, a7, a8);
    
    return m;
}


// ---------------------------------
void initT(uint32 * T, uint32 nemax)
// ---------------------------------
{
    int i;
    for (i = 0; i <= (int) nemax; i++) {
        T[i] = i;
    }
}


/* -------------------------- */
//void initA(uint32 *A, uint32 nemax)
/* ------------------------------- */
/*{
    int i;
    for(i=0; i<=nemax; i++) {
        A[i] = 0;
    }
}*/


// --------------------------------
void initZ(uint32 *T, uint32 nemax)
// --------------------------------
{
    int i;
    for (i = 0; i <= (int) nemax; i++) {
        T[i] = 0;
    }
}


// --------------------------------------
void check_initT(uint32 *T, uint32 nemax)
// --------------------------------------
{
    check_initT_range(T, 0, nemax, nemax);
}


// --------------------------------------
void check_initZ(uint32 *T, uint32 nemax)
// --------------------------------------
{
    check_initZ_range(T, 0, nemax, nemax);
}


// ---------------------------------------------------------------
void check_initT_range(uint32 *T, uint32 i0, uint32 ii, uint32 i1)
// ---------------------------------------------------------------
{
    uint32 i;
    
    printf("check_initT_range[%d %d %d]\n", i0, ii, i1);
    
    for (i = i0; i <= i1; i++) {
        if (T[i] != i) {
            printf("[check_initT]: T[%d] = %d\n", i, T[i]);
        }
    }
}


// ---------------------------------------------------------------
void check_initR_range(uint32 *R, uint32 i0, uint32 ii, uint32 i1)
// ---------------------------------------------------------------
{
    uint32 i;
    
    printf("check_initR_range[%d %d %d]\n", i0, ii, i1);
    
    for (i = i0; i <= i1; i++) {
        if (R[i] != i) {
            printf("[check_initR]: R[%d] = %d\n", i, R[i]);
        }
    }
}


// ---------------------------------------------------------------
void check_initZ_range(uint32 *T, uint32 i0, uint32 ii, uint32 i1)
// ---------------------------------------------------------------
{
    uint32 i;
    
    printf("check_initZ_range[%d %d %d]\n", i0, ii, i1);
    
    for (i = i0; i <= i1; i++) {
        if (T[i] != 0) {
            printf("[check_initZ]: T[%d] = %d\n", i, T[i]);
        }
    }
}


/* --------------------------------------------------------------------------------------------------- */
void binarisation_ui8matrix(uint8 **X, int i0, int i1, int j0, int j1, uint8 seuil, uint8 val, uint8 **Y)
/* --------------------------------------------------------------------------------------------------- */
{
    int i, j;
    uint8 x, y;

    for (i = i0; i <= i1; i++) {
        for (j = j0; j <= j1; j++) {
            x = X[i][j];
            if (x >= seuil)
                y = val;
            else
                y = 0;
            Y[i][j] = y;
        }
    }
}

/* ------------------------------------------------------------------- */
void applyTable(uint32 **X, int height, int width, uint32 *T, uint32 **Y)
/* ------------------------------------------------------------------- */
{
    int i, j;

    uint32 e, a;

    
    for (i = 0; i < height; i++) {
        for (j = 0; j < width; j++) {
            
            e = X[i][j];
            a = T[e];
            
            Y[i][j] = a;
        }
    }
}
/* ---------------------------------------------------------------------------------- */
void graphviz_write_ui8vector(uint8 * v, int i0, int i1, char * format, char * filename)
/* ---------------------------------------------------------------------------------- */
{
    int i;
    char complete_filename[64];
    
    snprintf(complete_filename, 64, "%s.dot", filename);
    
#if TARGET_OS == GIETVM
    int fd;
    fd = open(complete_filename, O_CREAT | O_TRUNC);
    
    fprintf(fd, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(fd, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(fd, "}\n");
    close(fd);
#elif TARGET_OS == LINUX
    FILE * f;
    f = fopen(complete_filename, "w");
    if (f == NULL) {
        fprintf(stderr, "Can't open file %s in %s\n", complete_filename, __func__);
    }
    
    fprintf(f, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(f, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(f, "}\n");
    fclose(f);
#endif
}
/* ------------------------------------------------------------------------------------ */
void graphviz_write_ui16vector(uint16 * v, int i0, int i1, char * format, char * filename)
/* ------------------------------------------------------------------------------------ */
{
    int i;
    char complete_filename[64];
    
    snprintf(complete_filename, 64, "%s.dot", filename);
    
#if TARGET_OS == GIETVM
    int fd;
    fd = open(complete_filename, O_CREAT | O_TRUNC);
    
    fprintf(fd, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(fd, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(fd, "}\n");
    close(fd);
#elif TARGET_OS == LINUX
    FILE * f;
    f = fopen(complete_filename, "w");
    if (f == NULL) {
        fprintf(stderr, "Can't open file %s in %s\n", complete_filename, __func__);
    }
    
    fprintf(f, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(f, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(f, "}\n");
    fclose(f);
#endif
}


/* ------------------------------------------------------------------------------------ */
void graphviz_write_ui32vector(uint32 * v, int i0, int i1, char * format, char * filename)
/* ------------------------------------------------------------------------------------ */
{
    int i;
    char complete_filename[64];
    
    snprintf(complete_filename, 64, "%s.dot", filename);
    
#if TARGET_OS == GIETVM
    int fd;
    fd = open(complete_filename, O_CREAT | O_TRUNC);
    
    fprintf(fd, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(fd, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(fd, "}\n");
    close(fd);
#elif TARGET_OS == LINUX
    FILE * f;
    f = fopen(complete_filename, "w");
    if (f == NULL) {
        fprintf(stderr, "Can't open file %s in %s\n", complete_filename, __func__);
    }
    
    fprintf(f, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(f, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(f, "}\n");
    fclose(f);
#endif
}


/* -------------------------------------------------------------------------------- */
void mod_ui32matrix_ui8matrix(uint32 ** X, int i0, int i1, int j0, int j1, uint8 ** Y)
/* -------------------------------------------------------------------------------- */
{
    int i, j;
    for (i = i0; i <= i1; i++) {
        for (j = j0; j <= j1; j++) {
            Y[i][j] = X[i][j] & 255;
        }
    }
}


// --------------------------------------------------------------------------------------------
void positive_mod_ui32matrix_ui8matrix(uint32 ** X, int i0, int i1, int j0, int j1, uint8 ** Y)
// --------------------------------------------------------------------------------------------
{
    int i, j;
    for (i = i0; i <= i1; i++) {
        for (j = j0; j <= j1; j++) {
            if (X[i][j]) {
                if (X[i][j] < 255) {
                    Y[i][j] = X[i][j]; // pour que e=1 reste rouge
                }
                else {
                    Y[i][j] = (X[i][j] % 254) + 1;
                }
            } 
            else {
                Y[i][j] = 0;
            }
            
        }
    }
}


/* ---------------------------------------------------------------------------------------- */
void graphviz_write_ui32vector_par(uint32 * v, int i0, int i1, char * format, char * filename)
/* ---------------------------------------------------------------------------------------- */
{
    int i;
    char complete_filename[64];
    
    snprintf(complete_filename, 64, "%s.dot", filename);
    
#if TARGET_OS == GIETVM 
    int fd;
    fd = open(complete_filename, O_CREAT | O_TRUNC);
    
    fprintf(fd, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(fd, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(fd, "}\n");
    close(fd);
#else
    FILE * f;
    f = fopen(complete_filename, "w");
    if (f == NULL) { 
        fprintf(stderr, "Can't open file %s in %s\n", complete_filename, __func__);
    }
    fprintf(f, "digraph %s {\n", filename);
    for (i = i0; i <= i1; i++) {
        fprintf(f, "%3d -> %3d;\n", i, v[i]);
    }
    fprintf(f, "}\n");
    fclose(f);
#endif
}


// --------------------------------------
uint32 mt19937_uint32(uint32 a, uint32 b)
// --------------------------------------
// nombre aleatoire 32 bit sur [a..b]
{
    uint32 d;
    uint32 x32;

    if (b < a) {
        return mt19937_uint32(b, a);
    }
    
    //printf("a = %u b = %u\n", a, b);
    
    d = b - a + 1;
    x32 = genrand_int32();
    //printf("x32 = %u, d = %u\n", x32, d);
    x32 = (x32 % d) + a;
    return x32;
}


// ------------------------
bool strto_Bool(char * str)
// ------------------------
{
    bool b = true;
    if (strcmp(str, "TRUE" ) == 0) b = true;
    if (strcmp(str, "true" ) == 0) b = true;
    
    if (strcmp(str, "FALSE") == 0) b = false;
    if (strcmp(str, "false") == 0) b = false;
    
    return b;
}


// -------------------------------------------------------------
void check_no_write(uint32 ** T, int i0, int i1, int j0, int j1)
// -------------------------------------------------------------
{
    int i, j;
    for (i = i0; i <= i1; i++) {
        for (j = j0; j <= j1; j++) {
            if (T[i][j] == 0xDEADBEFF) {
                printf("[check_no_write]: T[%d][%d] = %d\n", i, j, T[i][j]);
            }
        }
    }
}


