/* ------------------- */
/* --- nralloc2X.c --- */
/* ------------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
*/

/* 
* 2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc2x.h"


/* ----------------- */
/* --- trimatrix --- */
/* ----------------- */


#undef type_trimatrix
#define type_trimatrix(t) \
t ** short_name(t,,trimatrix)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t step) \
/* allocate an byte triangle-matrix with subscript range m[nrl..nrh][ncl..nch] */               \
{                                                                                               \
    int32_t nrow = nrh - nrl + 1;                                                               \
    int32_t ncol = nch - ncl + 1;                                                               \
    int n = nrow * ncol + (nrow * (nrow - 1) * step) / 2;                                       \
    /* Attention, factorisation of n IS NOT PERMITTED : (nrow - 1) step / 2 is not even!!! */   \
    t ** m;                                                                                     \
    /* allocate pointers to rows */                                                             \
    m = malloc((nrow + NR_END) * sizeof(t *));                                                  \
    if (m == NULL) {                                                                            \
        nrerror("*** Error: allocation failure in %s\n", __func__);                             \
    }                                                                                           \
    m += NR_END;                                                                                \
    m -= nrl;                                                                                   \
    /* allocate rows and set pointers to them */                                                \
    m[nrl] = malloc(((n + NR_END) * sizeof(t)));                                                \
    if (m[nrl] == NULL) {                                                                       \
        nrerror("*** Error: allocation failure in %s\n", __func__);                             \
    }                                                                                           \
    m[nrl] += NR_END;                                                                           \
    m[nrl] -= ncl;                                                                              \
    for (int32_t i = nrl + 1; i <= nrh;i++) {                                                   \
        m[i] = m[i - 1] + ncol;                                                                 \
        ncol += step;                                                                           \
    }                                                                                           \
    /* return pointer to array of pointers to rows */                                           \
    return m;                                                                                   \
}


type_trimatrix(int8_t);
type_trimatrix(uint8_t);
type_trimatrix(int16_t);
type_trimatrix(uint16_t);
type_trimatrix(int32_t);
type_trimatrix(uint32_t);
type_trimatrix(float);
type_trimatrix(double);

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

