/* ------------------ */
/* --- nrarith2.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
*/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrarith2.h"

/* ------------------ */
/* --- min_matrix --- */
/* ------------------ */

#undef min_type_matrix
#define min_type_matrix(t) \
t short_name(t,min_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                                       \
    t minimum = m[nrl][nrh];                                                            \
    for (int32_t i = nrl; i <= nrh; i++) {                                              \
        for (int32_t j = ncl; j <= nch; j++) {                                          \
            if (m[i][j] < minimum) {                                                    \
                minimum = m[i][j];                                                      \
            }                                                                           \
        }                                                                               \
    }                                                                                   \
    return minimum;                                                                     \
}

min_type_matrix(int8_t);
min_type_matrix(uint8_t);
min_type_matrix(int16_t);
min_type_matrix(uint16_t);
min_type_matrix(int32_t);
min_type_matrix(uint32_t);
min_type_matrix(int64_t);
min_type_matrix(uint64_t);
min_type_matrix(float);
min_type_matrix(double);


/* ------------------ */
/* --- max_matrix --- */
/* ------------------ */

#undef max_type_matrix
#define max_type_matrix(t) \
t short_name(t,max_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                                       \
    t maximum = m[nrl][nrh];                                                            \
    for (int32_t i = nrl; i <= nrh; i++) {                                              \
        for (int32_t j = ncl; j <= nch; j++) {                                          \
            if (m[i][j] > maximum) {                                                    \
                maximum = m[i][j];                                                      \
            }                                                                           \
        }                                                                               \
    }                                                                                   \
    return maximum;                                                                     \
}

max_type_matrix(int8_t);
max_type_matrix(uint8_t);
max_type_matrix(int16_t);
max_type_matrix(uint16_t);
max_type_matrix(int32_t);
max_type_matrix(uint32_t);
max_type_matrix(int64_t);
max_type_matrix(uint64_t);
max_type_matrix(float);
max_type_matrix(double);



/* ------------------ */
/* --- Add Matrix --- */
/* ------------------ */


#undef add_type_matrix
#define add_type_matrix(t) \
void short_name(t,add_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z) \
{                                                                                                          \
    for (int32_t i = nrl; i <= nrh; i++) {                                                                 \
        for (int32_t j = ncl; j <= nch; j++) {                                                             \
            Z[i][j] = X[i][j] + Y[i][j];                                                                   \
        }                                                                                                  \
    }                                                                                                      \
}

add_type_matrix(int8_t);
add_type_matrix(uint8_t);
add_type_matrix(int16_t);
add_type_matrix(uint16_t);
add_type_matrix(int32_t);
add_type_matrix(uint32_t);
add_type_matrix(int64_t);
add_type_matrix(uint64_t);
add_type_matrix(float);
add_type_matrix(double);


/* ----------------------------------------------------------------------------------------------- */
void add_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 ** Y, rgb8 ** Z)
/* ----------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            //z = x + y;
            RGB8_ADD(X[i][j], Y[i][j], Z[i][j]);
        }
    }
}

/* --------------------------------------------------------------------------------------------------- */
void add_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 ** Y, rgbx8 ** Z)
/* --------------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            //z = x + y;
            RGBX8_ADD(X[i][j], Y[i][j], Z[i][j]);
        }
    }
}

/* -------------------- */
/* --- Add constant --- */
/* -------------------- */

#undef addc_type_matrix
#define addc_type_matrix(t) \
void short_name(t,addc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                                                                        \
    for (int32_t i = nrl; i <= nrh; i++) {                                                               \
        for (int32_t j = ncl; j <= nch; j++) {                                                           \
            Z[i][j] = X[i][j] + y;                                                                       \
        }                                                                                                \
    }                                                                                                    \
}

addc_type_matrix(int8_t);
addc_type_matrix(uint8_t);
addc_type_matrix(int16_t);
addc_type_matrix(uint16_t);
addc_type_matrix(int32_t);
addc_type_matrix(uint32_t);
addc_type_matrix(int64_t);
addc_type_matrix(uint64_t);
addc_type_matrix(float);
addc_type_matrix(double);



/* ---------------------------------------------------------------------------------------------- */
void addc_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 y, rgb8 ** Z)
/* ---------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGB8_ADD(X[i][j], y, Z[i][j]);
        }
    }
}

/* -------------------------------------------------------------------------------------------------- */
void addc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z)
/* -------------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGBX8_ADD(X[i][j], y, Z[i][j]);
        }
    }
}


/* ------------------ */
/* --- Sub Matrix --- */
/* ------------------ */

#undef sub_type_matrix
#define sub_type_matrix(t) \
void short_name(t,sub_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z) \
{                                                                                                          \
    for (int32_t i = nrl; i <= nrh; i++) {                                                                 \
        for (int32_t j = ncl; j <= nch; j++) {                                                             \
            Z[i][j] = X[i][j] - Y[i][j];                                                                   \
        }                                                                                                  \
    }                                                                                                      \
}

sub_type_matrix(int8_t);
sub_type_matrix(uint8_t);
sub_type_matrix(int16_t);
sub_type_matrix(uint16_t);
sub_type_matrix(int32_t);
sub_type_matrix(uint32_t);
sub_type_matrix(int64_t);
sub_type_matrix(uint64_t);
sub_type_matrix(float);
sub_type_matrix(double);


/* ----------------------------------------------------------------------------------------------- */
void sub_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 ** Y, rgb8 ** Z)
/* ----------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            //z = x + y;
            RGB8_SUB(X[i][j], Y[i][j], Z[i][j]);
        }
    }
}

/* --------------------------------------------------------------------------------------------------- */
void sub_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 ** Y, rgbx8 ** Z)
/* --------------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            //z = x + y;
            RGBX8_SUB(X[i][j], Y[i][j], Z[i][j]);
        }
    }
}


/* -------------------- */
/* --- Sub constant --- */
/* -------------------- */

#undef subc_type_matrix
#define subc_type_matrix(t) \
void short_name(t,subc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                                                                        \
    for (int32_t i = nrl; i <= nrh; i++) {                                                               \
        for (int32_t j = ncl; j <= nch; j++) {                                                           \
            Z[i][j] = X[i][j] - y;                                                                       \
        }                                                                                                \
    }                                                                                                    \
}

subc_type_matrix(int8_t);
subc_type_matrix(uint8_t);
subc_type_matrix(int16_t);
subc_type_matrix(uint16_t);
subc_type_matrix(int32_t);
subc_type_matrix(uint32_t);
subc_type_matrix(int64_t);
subc_type_matrix(uint64_t);
subc_type_matrix(float);
subc_type_matrix(double);



/* ---------------------------------------------------------------------------------------------- */
void subc_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 y, rgb8 ** Z)
/* ---------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGB8_SUB(X[i][j], y, Z[i][j]);
        }
    }
}

/* -------------------------------------------------------------------------------------------------- */
void subc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z)
/* -------------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGBX8_SUB(X[i][j], y, Z[i][j]);
        }
    }
}


/* -------------------- */
/* --- Mul constant --- */
/* -------------------- */

#undef mulc_type_matrix
#define mulc_type_matrix(t) \
void short_name(t,mulc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                                                                        \
    for (int32_t i = nrl; i <= nrh; i++) {                                                               \
        for (int32_t j = ncl; j <= nch; j++) {                                                           \
            Z[i][j] = X[i][j] * y;                                                                       \
        }                                                                                                \
    }                                                                                                    \
}

mulc_type_matrix(int8_t);
mulc_type_matrix(uint8_t);
mulc_type_matrix(int16_t);
mulc_type_matrix(uint16_t);
mulc_type_matrix(int32_t);
mulc_type_matrix(uint32_t);
mulc_type_matrix(int64_t);
mulc_type_matrix(uint64_t);
mulc_type_matrix(float);
mulc_type_matrix(double);



/* ---------------------------------------------------------------------------------------------- */
void mulc_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 y, rgb8 ** Z)
/* ---------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGB8_MUL(X[i][j], y, Z[i][j]);
        }
    }
}

/* -------------------------------------------------------------------------------------------------- */
void mulc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z)
/* -------------------------------------------------------------------------------------------------- */
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            RGBX8_MUL(X[i][j], y, Z[i][j]);
        }
    }
}


/* --------------- */
/* --- MulFrac --- */
/* --------------- */

// Y = (a * X) / b

#undef mulfrac_type_matrix
#define mulfrac_type_matrix(t) \
void short_name(t,mulfrac_,matrix)(t ** X, int32_t nrl, int32_t nrh, \
        int32_t ncl, int32_t nch, int32_t a, int32_t b, t ** Y)      \
{                                                                    \
    for (int32_t i = nrl; i <= nrh; i++) {                           \
        for (int32_t j = ncl; j <= nch; j++) {                       \
            Y[i][j] = (t) ((a * X[i][j]) / b);                       \
        }                                                            \
    }                                                                \
}

mulfrac_type_matrix(int8_t);
mulfrac_type_matrix(uint8_t);
mulfrac_type_matrix(int16_t);
mulfrac_type_matrix(uint16_t);
mulfrac_type_matrix(int32_t);
mulfrac_type_matrix(uint32_t);
mulfrac_type_matrix(int64_t);
mulfrac_type_matrix(uint64_t);
mulfrac_type_matrix(float);
mulfrac_type_matrix(double);


/* ------------------------------------------------------------------------------------------------------------ */
void mulfrac_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb32 a, rgb32 b, rgb8 ** Y)
/* ------------------------------------------------------------------------------------------------------------ */
{
    rgb32 y32;
    rgb8 x8, y8;
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            x8 = X[i][j];
            RGB8_MULFRAC(x8, a, b, y32);
            RGB32CAST8(y32, y8);
            Y[i][j] = y8;
        }
    }
}

/* ----------------------------------------------------------------------------------------------------------------- */
void mulfrac_rgb8xmatrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx32 a, rgbx32 b, rgbx8 ** Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    rgbx32 y32;
    rgbx8 x8, y8;
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            x8 = X[i][j];
            RGBX8_MULFRAC(x8, a, b, y32);
            RGBX32CAST8(y32, y8);
            Y[i][j] = y8;
        }
    }
}


/* ---------------- */
/* --- MulShift --- */
/* ---------------- */

// m3 = (a * m1) >> s

#undef mulshift_type_matrix
#define mulshift_type_matrix(t) \
void short_name(t,mulshift_,matrix)(t ** X, int32_t nrl, int32_t nrh, \
        int32_t ncl, int32_t nch, int32_t a, int32_t s, t ** Y)      \
{                                                                    \
    for (int32_t i = nrl; i <= nrh; i++) {                           \
        for (int32_t j = ncl; j <= nch; j++) {                       \
            Y[i][j] = (t) ((a * X[i][j]) >> s);                      \
        }                                                            \
    }                                                                \
}

mulshift_type_matrix(int8_t);
mulshift_type_matrix(uint8_t);
mulshift_type_matrix(int16_t);
mulshift_type_matrix(uint16_t);
mulshift_type_matrix(int32_t);
mulshift_type_matrix(uint32_t);
mulshift_type_matrix(int64_t);
mulshift_type_matrix(uint64_t);


/* ---------------------------------------------------------------------------------------------------------------- */
void mulshift_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb32  a, rgb32  s, rgb8 ** Y)
/* ---------------------------------------------------------------------------------------------------------------- */
{
    rgb32 y32;
    rgb8 x8, y8;
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            x8 = X[i][j];
            RGB8_MULSHIFT(x8, a, s, y32);
            RGB32CAST8(y32, y8);
            Y[i][j] = y8;
        }
    }
}

/* ----------------------------------------------------------------------------------------------------------------- */
void mulshift_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx32 a, rgbx32 s, rgbx8 ** Y)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    rgbx32 y32;
    rgbx8 x8, y8;
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            x8 = X[i][j];
            RGBX8_MULSHIFT(x8, a, s, y32);
            RGBX32CAST8(y32, y8);
            Y[i][j] = y8;
        }
    }
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

