/* ------------------ */
/* --- nrarith2.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"


#undef addcnz_type_matrix
#define addcnz_type_matrix(t) \
void short_name(t,addcnz_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t cte, t ** dst) \
{                                              \
	t * Xi;                                    \
    t * Yi;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		Xi = src[i];                           \
		Yi = dst[i];                           \
		for (int32_t j = ncl; j <= nch; j++) { \
			if (Xi[j] != 0) {                  \
				Yi[j] = Xi[j] + cte;           \
            }                                  \
			else {                             \
				Yi[j] = Xi[j];                 \
            }                                  \
		}                                      \
	}                                          \
}

addcnz_type_matrix(int8_t);
addcnz_type_matrix(uint8_t);
addcnz_type_matrix(int16_t);
addcnz_type_matrix(uint16_t);
addcnz_type_matrix(int32_t);
addcnz_type_matrix(uint32_t);
addcnz_type_matrix(int64_t);
addcnz_type_matrix(uint64_t);
addcnz_type_matrix(float);
addcnz_type_matrix(double);


#undef addandc_type_matrix
#define addandc_type_matrix(t) \
void short_name(t,addandc_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t cte, t ** dst) \
{                                              \
	t * Xi;                                    \
    t * Yi;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		Xi = src[i];                           \
		Yi = dst[i];                           \
		for (int32_t j = ncl; j <= nch; j++) { \
			if (Xi[j] != 0) {                  \
                Yi[j] = Xi[j] + cte;           \
            }                                  \
		}                                      \
	}                                          \
}

addandc_type_matrix(int8_t);
addandc_type_matrix(uint8_t);
addandc_type_matrix(int16_t);
addandc_type_matrix(uint16_t);
addandc_type_matrix(int32_t);
addandc_type_matrix(uint32_t);
addandc_type_matrix(int64_t);
addandc_type_matrix(uint64_t);
addandc_type_matrix(float);
addandc_type_matrix(double);


#undef sum_type_matrix
#define sum_type_matrix(t,rt) \
rt short_name(t,sum_,matrix)(t ** m, int32_t nrl, int32_t nrh,int32_t ncl, int32_t nch) \
{                                              \
	rt s = 0;                                  \
	t * Xi;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		Xi = m[i];                             \
		for (int32_t j = ncl; j <= nch; j++) { \
			s += Xi[j];                        \
		}                                      \
    }                                          \
    return s;                                  \
}


sum_type_matrix(int8_t, int32_t);
sum_type_matrix(uint8_t, uint32_t);
sum_type_matrix(int16_t, int32_t);
sum_type_matrix(uint16_t, uint32_t);
sum_type_matrix(int32_t, int64_t);
sum_type_matrix(uint32_t, uint64_t);
sum_type_matrix(int64_t, int64_t);
sum_type_matrix(uint64_t, uint64_t);
sum_type_matrix(float, float);
sum_type_matrix(double, double);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

