/* ------------------ */
/* --- nralloc2.h --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
* 
*/

/* 
 * 2002/06/11 ajout des fonctions endline
 */

#ifndef __NRALLOC2_H__
#define __NRALLOC2_H__

#include "nrc_os_config.h"

/*
 * --------------
 * --- matrix ---
 * --------------
 */


#undef type_matrix
#define type_matrix(t) \
t ** short_name(t,,matrix)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)


type_matrix(int8_t);
type_matrix(uint8_t);
type_matrix(int16_t);
type_matrix(uint16_t);
type_matrix(int32_t);
type_matrix(uint32_t);
type_matrix(int64_t);
type_matrix(uint64_t);
type_matrix(float);
type_matrix(double);
type_matrix(void_p);
type_matrix(rgb8);
type_matrix(rgbx8);
type_matrix(rgb32);
type_matrix(rgbx32);
type_matrix(complex32);
type_matrix(complex64);


#undef type_matrix0
#define type_matrix0(t) \
t ** short_name(t,,matrix0)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)


type_matrix0(int8_t);
type_matrix0(uint8_t);
type_matrix0(int16_t);
type_matrix0(uint16_t);
type_matrix0(int32_t);
type_matrix0(uint32_t);
type_matrix0(int64_t);
type_matrix0(uint64_t);
type_matrix0(float);
type_matrix0(double);
type_matrix0(void_p);
type_matrix0(rgb8);
type_matrix0(rgbx8);
type_matrix0(rgb32);
type_matrix0(rgbx32);
type_matrix0(complex32);
type_matrix0(complex64);


#if TARGET_OS == GIETVM

#undef remote_type_matrix
#define remote_type_matrix(t) \
t ** short_name(t,remote_,matrix)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)

remote_type_matrix(int8_t);
remote_type_matrix(uint8_t);
remote_type_matrix(int16_t);
remote_type_matrix(uint16_t);
remote_type_matrix(int32_t);
remote_type_matrix(uint32_t);
remote_type_matrix(int64_t);
remote_type_matrix(uint64_t);
remote_type_matrix(float);
remote_type_matrix(double);
remote_type_matrix(void_p);
remote_type_matrix(rgb8);
remote_type_matrix(rgbx8);
remote_type_matrix(rgb32);
remote_type_matrix(rgbx32);
remote_type_matrix(complex32);
remote_type_matrix(complex64);

#endif


#undef free_type_matrix
#define free_type_matrix(t) \
void short_name(t,free_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)

free_type_matrix(int8_t);
free_type_matrix(uint8_t);
free_type_matrix(int16_t);
free_type_matrix(uint16_t);
free_type_matrix(int32_t);
free_type_matrix(uint32_t);
free_type_matrix(int64_t);
free_type_matrix(uint64_t);
free_type_matrix(float);
free_type_matrix(double);
free_type_matrix(void_p);
free_type_matrix(rgb8);
free_type_matrix(rgbx8);
free_type_matrix(rgb32);
free_type_matrix(rgbx32);
free_type_matrix(complex32);
free_type_matrix(complex64);


#endif /* __NRALLOC2_H__ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

