/* ------------------ */
/* --- nrarith0.h --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef __NRARITH0_H__
#define __NRARITH0_H__

/* ---------- */
/* -- Swap -- */
/* ---------- */

#define type_swap(t)                   \
void short_name(t,,swap)(t * a, t * b)

type_swap(int8_t);
type_swap(int16_t);
type_swap(int32_t);
type_swap(int64_t);
type_swap(float);
type_swap(double);
type_swap(rgb8);
type_swap(rgbx8);


/* --------- */
/* -- Min -- */
/* --------- */

#define type_min(t)                                 \
t short_name(t,,min)(t x1, t x2);                   \
t short_name(t,,min2)(t x1, t x2);                  \
t short_name(t,,min3)(t x1, t x2, t x3);            \
t short_name(t,,min4)(t x1, t x2, t x3, t x4);      \
t short_name(t,,min5)(t x1, t x2, t x3, t x4, t x5) \

type_min(float);
type_min(double);
type_min(int8_t);
type_min(uint8_t);
type_min(int16_t);
type_min(uint16_t);
type_min(int32_t);
type_min(uint32_t);
type_min(rgb8);


/* --------- */
/* -- Max -- */
/* --------- */

#define type_max(t)                                 \
t short_name(t,,max)(t x1, t x2);                   \
t short_name(t,,max2)(t x1, t x2);                  \
t short_name(t,,max3)(t x1, t x2, t x3);            \
t short_name(t,,max4)(t x1, t x2, t x3, t x4);      \
t short_name(t,,max5)(t x1, t x2, t x3, t x4, t x5) \

type_max(float);
type_max(double);
type_max(int8_t);
type_max(uint8_t);
type_max(int16_t);
type_max(uint16_t);
type_max(int32_t);
type_max(uint32_t);
type_max(rgb8);


/* ----------- */
/* -- Other -- */
/* ----------- */

int32_t i32bit(int32_t x, int32_t n);
int32_t sym_int32(int32_t x);
int32_t myLog2(int32_t x);
int32_t next_power2(int32_t x);
int32_t myGCD(int32_t u, int32_t v);
int32_t myLCM(int32_t u, int32_t v);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

