/* ------------------- */
/* --- nrarith2x.h --- */
/* ------------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRARITH2X_H_
#define _NRARITH2X_H_

// Add conditionnel

#define addcnz_type_matrix(t) \
void short_name(t,addcnz_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t cte, t ** dst)

addcnz_type_matrix(int8_t);
addcnz_type_matrix(uint8_t);
addcnz_type_matrix(int16_t);
addcnz_type_matrix(uint16_t);
addcnz_type_matrix(int32_t);
addcnz_type_matrix(uint32_t);
addcnz_type_matrix(int64_t);
addcnz_type_matrix(uint64_t);
addcnz_type_matrix(float);
addcnz_type_matrix(double);


#define addandc_type_matrix(t) \
void short_name(t,addandc_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t cte, t ** dst)

addandc_type_matrix(int8_t);
addandc_type_matrix(uint8_t);
addandc_type_matrix(int16_t);
addandc_type_matrix(uint16_t);
addandc_type_matrix(int32_t);
addandc_type_matrix(uint32_t);
addandc_type_matrix(int64_t);
addandc_type_matrix(uint64_t);
addandc_type_matrix(float);
addandc_type_matrix(double);


/* renvoie la somme des points de la matrice */

#define sum_type_matrix(t,rt) \
rt short_name(t,sum_,matrix)(t ** m, int32_t nrl, int32_t nrh,int32_t ncl, int32_t nch)

sum_type_matrix(int8_t, int32_t);
sum_type_matrix(uint8_t, uint32_t);
sum_type_matrix(int16_t, int32_t);
sum_type_matrix(uint16_t, uint32_t);
sum_type_matrix(int32_t, int64_t);
sum_type_matrix(uint32_t, uint64_t);
sum_type_matrix(int64_t, int64_t);
sum_type_matrix(uint64_t, uint64_t);
sum_type_matrix(float, float);
sum_type_matrix(double, double);



#endif /* _NRUTIL_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

