/* ------------------ */
/* --- nralloc2.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
*/

/* 
 * this code is based on the "Numerical Recipes in C 2nd edition" nrutil.c nrutil.h files from
 * William H. Press, Saul A. Teukolsky, William T. Vetterling, Brian P. Flannery
 *
 * The original code is not-copyrighted.
 * The original routines are placed into the public domain
 * (see Appendix B: utility routines, pp 964)
 * for more information, visit http://www.nr.com
 */

/* 
* 2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrtypex.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc2.h"

/*
 * --------------
 * --- matrix ---
 * --------------
 */


#undef type_matrix
#define type_matrix(t) \
t ** short_name(t,,matrix)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                              \
    int32_t nrow = nrh - nrl + 1;                                              \
    int32_t ncol = nch - ncl + 1;                                              \
    t ** m;                                                                    \
    /* allocate pointers to row */                                             \
    m = malloc((nrow + NR_END) * sizeof(t *));                                 \
    if (m == NULL) {                                                           \
        nrerror("*** Error: allocation failure in %s\n", __func__);            \
    }                                                                          \
    m += NR_END;                                                               \
    m -= nrl;                                                                  \
    /* allocate rows and set pointers to them */                               \
    m[nrl] = malloc((nrow * ncol + NR_END) * sizeof(t));                       \
    if (m[nrl] == NULL) {                                                      \
        nrerror("*** Error: allocation failure in %s\n", __func__);            \
    }                                                                          \
    m[nrl] += NR_END;                                                          \
    m[nrl] -= ncl;                                                             \
    for (int32_t i = nrl + 1; i <= nrh; i++) {                                 \
        m[i] = m[i - 1] + ncol;                                                \
    }                                                                          \
    /* return pointer to array of pointers to rows */                          \
    return m;                                                                  \
}


type_matrix(int8_t);
type_matrix(uint8_t);
type_matrix(int16_t);
type_matrix(uint16_t);
type_matrix(int32_t);
type_matrix(uint32_t);
type_matrix(int64_t);
type_matrix(uint64_t);
type_matrix(float);
type_matrix(double);
type_matrix(void_p);
type_matrix(rgb8);
type_matrix(rgbx8);
type_matrix(rgb32);
type_matrix(rgbx32);
type_matrix(complex32);
type_matrix(complex64);
type_matrix(si16Point);
type_matrix(ui16Point);
type_matrix(si32Point);
type_matrix(ui32Point);
type_matrix(f32Point);
type_matrix(si16Triplet);
type_matrix(ui16Triplet);
type_matrix(si32Triplet);
type_matrix(ui32Triplet);
type_matrix(f32Triplet);




#undef type_matrix0
#define type_matrix0(t) \
t ** short_name(t,,matrix0)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                               \
    int32_t nrow = nrh - nrl + 1;                                               \
    int32_t ncol = nch - ncl + 1;                                               \
    t ** m;                                                                     \
    /* allocate pointers to row */                                              \
    m = malloc((nrow + NR_END) * sizeof(t *));                                  \
    if (m == NULL) {                                                            \
        nrerror("*** Error: allocation failure in %s\n", __func__);             \
    }                                                                           \
    m += NR_END;                                                                \
    m -= nrl;                                                                   \
    /* allocate rows and set pointers to them */                                \
    m[nrl] = calloc((nrow * ncol + NR_END), sizeof(t));                         \
    if (m[nrl] == NULL) {                                                       \
        nrerror("*** Error: allocation failure in %s\n", __func__);             \
    }                                                                           \
    m[nrl] += NR_END;                                                           \
    m[nrl] -= ncl;                                                              \
    for (int32_t i = nrl + 1; i <= nrh; i++) {                                  \
        m[i] = m[i - 1] + ncol;                                                 \
    }                                                                           \
    /* return pointer to array of pointers to rows */                           \
    return m;                                                                   \
}


type_matrix0(int8_t);
type_matrix0(uint8_t);
type_matrix0(int16_t);
type_matrix0(uint16_t);
type_matrix0(int32_t);
type_matrix0(uint32_t);
type_matrix0(int64_t);
type_matrix0(uint64_t);
type_matrix0(float);
type_matrix0(double);
type_matrix0(void_p);
type_matrix0(rgb8);
type_matrix0(rgbx8);
type_matrix0(rgb32);
type_matrix0(rgbx32);
type_matrix0(complex32);
type_matrix0(complex64);


#if TARGET_OS == GIETVM

#undef remote_type_matrix
#define remote_type_matrix(t) \
t ** short_name(t,remote_,matrix)(int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                              \
    int32_t nrow = nrh - nrl + 1;                                              \
    int32_t ncol = nch - ncl + 1;                                              \
    t ** m;                                                                    \
    /* allocate pointers to row */                                             \
    m = malloc((nrow + NR_END) * sizeof(t *));                                 \
    if (m == NULL) {                                                           \
        nrerror("*** Error: allocation failure in %s\n", __func__);            \
    }                                                                          \
    m += NR_END;                                                               \
    m -= nrl;                                                                  \
    /* allocate rows and set pointers to them */                               \
    m[nrl] = malloc((nrow * ncol + NR_END) * sizeof(t));                       \
    if (m[nrl] == NULL) {                                                      \
        nrerror("*** Error: allocation failure in %s\n", __func__);            \
    }                                                                          \
    m[nrl] += NR_END;                                                          \
    m[nrl] -= ncl;                                                             \
    for (int32_t i = nrl + 1; i <= nrh; i++) {                                 \
        m[i] = m[i - 1] + ncol;                                                \
    }                                                                          \
    /* return pointer to array of pointers to rows */                          \
    return m;                                                                  \
}


remote_type_matrix(int8_t);
remote_type_matrix(uint8_t);
remote_type_matrix(int16_t);
remote_type_matrix(uint16_t);
remote_type_matrix(int32_t);
remote_type_matrix(uint32_t);
remote_type_matrix(int64_t);
remote_type_matrix(uint64_t);
remote_type_matrix(float);
remote_type_matrix(double);
remote_type_matrix(void_p);
remote_type_matrix(rgb8);
remote_type_matrix(rgbx8);
remote_type_matrix(rgb32);
remote_type_matrix(rgbx32);
remote_type_matrix(complex32);
remote_type_matrix(complex64);

#endif


#undef free_type_matrix
#define free_type_matrix(t) \
void short_name(t,free_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{ \
    free((FREE_ARG) (m[nrl] + ncl - NR_END)); \
    free((FREE_ARG) (m + nrl - NR_END)); \
}

free_type_matrix(int8_t);
free_type_matrix(uint8_t);
free_type_matrix(int16_t);
free_type_matrix(uint16_t);
free_type_matrix(int32_t);
free_type_matrix(uint32_t);
free_type_matrix(int64_t);
free_type_matrix(uint64_t);
free_type_matrix(float);
free_type_matrix(double);
free_type_matrix(void_p);
free_type_matrix(rgb8);
free_type_matrix(rgbx8);
free_type_matrix(rgb32);
free_type_matrix(rgbx32);
free_type_matrix(complex32);
free_type_matrix(complex64);
free_type_matrix(si16Point);
free_type_matrix(ui16Point);
free_type_matrix(si32Point);
free_type_matrix(ui32Point);
free_type_matrix(f32Point);
free_type_matrix(si16Triplet);
free_type_matrix(ui16Triplet);
free_type_matrix(si32Triplet);
free_type_matrix(ui32Triplet);
free_type_matrix(f32Triplet);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

