/* ------------------ */
/* --- nralloc3.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/* 
 * this code is based on the "Numerical Recipes in C 2nd edition" nrutil.c nrutil.h files from
 * William H. Press, Saul A. Teukolsky, William T. Vetterling, Brian P. Flannery
 *
 * The original code is not-copyrighted.
 * The original routines are placed into the public domain
 * (see Appendix B: utility routines, pp 964)
 * for more information, visit http://www.nr.com
 */

/* 
* 2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <ctype.h> // isdigit
#include <string.h> // memcpy
#include <math.h> // fabs


#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc3.h"


#undef type_cube
#define type_cube(t) \
t *** short_name(t,,cube)(int32_t ndl, int32_t ndh, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                                                       \
    int32_t ndep = ndh - ndl + 1;                                                                       \
    int32_t nrow = nrh - nrl + 1;                                                                       \
    int32_t nrol = nch - ncl + 1;                                                                       \
    t *** c;                                                                                            \
    /* allocate pointers to pointers to rows */                                                         \
    c = malloc((ndep + NR_END) * sizeof(t **));                                                         \
    if (c == NULL) {                                                                                    \
        nrerror("*** Error: allocation failure in %s\n", __func__);                                     \
    }                                                                                                   \
    c += NR_END;                                                                                        \
    c -= ndl;                                                                                           \
    /* allocate pointers to rows anc set pointers to them */                                            \
    c[ndl] = malloc((ndep * nrow + NR_END) * sizeof(t *));                                              \
    if (c[ndl] == NULL) {                                                                               \
        nrerror("*** Error: allocation failure in %s\n", __func__);                                     \
    }                                                                                                   \
    c[ndl] += NR_END;                                                                                   \
    c[ndl] -= nrl;                                                                                      \
    /* allocate rows anc set pointers to them */                                                        \
    c[ndl][nrl] = malloc((ndep * nrow * nrol + NR_END) * sizeof(t));                                    \
    if (c[ndl][nrl]) {                                                                                  \
        nrerror("*** Error: allocation failure in %s\n", __func__);                                     \
    }                                                                                                   \
    c[ndl][nrl] += NR_END;                                                                              \
    c[ndl][nrl] -= ncl;                                                                                 \
                                                                                                        \
    for(int32_t j = nrl + 1; j <= nrh; j++) {                                                           \
        c[ndl][j] = c[ndl][j - 1] + nrol;                                                               \
    }                                                                                                   \
    for(int32_t i = ndl + 1; i <= ndh; i++) {                                                           \
        c[i] = c[i - 1] + nrow;                                                                         \
        c[i][nrl] = c[i - 1][nrl] + nrow * nrol;                                                        \
        for (int32_t j = nrl + 1; j <= nrh; j++) {                                                      \
            c[i][j] = c[i][j - 1] + nrol;                                                               \
        }                                                                                               \
    }                                                                                                   \
    /* return pointer to array of pointers to rows */                                                   \
    return t;                                                                                           \
}


type_cube(int8_t);
type_cube(uint8_t);
type_cube(int16_t);
type_cube(uint16_t);
type_cube(int32_t);
type_cube(uint32_t);
type_cube(int64_t);
type_cube(uint64_t);
type_cube(float);
type_cube(double);
type_cube(rgb8);
type_cube(rgbx8);

#undef free_type_cube
#define free_type_cube(t) \
void short_name(t,free_,cube)(t *** c, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t ndl, int32_t ndh) \
{                                                                                                        \
    free((FREE_ARG) (c[nrl][ncl] + ndl - NR_END));                                                       \
    free((FREE_ARG) (c[nrl] + ncl - NR_END));                                                            \
    free((FREE_ARG) (c + nrl - NR_END));                                                                 \
}

free_type_cube(int8_t);
free_type_cube(uint8_t);
free_type_cube(int16_t);
free_type_cube(uint16_t);
free_type_cube(int32_t);
free_type_cube(uint32_t);
free_type_cube(int64_t);
free_type_cube(uint64_t);
free_type_cube(float);
free_type_cube(double);
free_type_cube(rgb8);
free_type_cube(rgbx8);


#if 0
/* ----------------------------------------------------------------------- */
double*** d3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh)
/* ----------------------------------------------------------------------- */
/* allocate a float 3tensor with range t[nrl..nrh][ncl..nch][ndl..ndh] */
{
    long i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1;
    double ***t;
    
    /* allocate pointers to pointers to rows */
    t=(double ***) malloc((size_t)((nrow+NR_END)*sizeof(double**)));
    if (!t) nrerror("allocation failure 1 in d3tensor()");
    t += NR_END;
    t -= nrl;
    
    /* allocate pointers to rows and set pointers to them */
    t[nrl]=(double **) malloc((size_t)((nrow*ncol+NR_END)*sizeof(double*)));
    if (!t[nrl]) nrerror("allocation failure 2 in d3tensor()");
    t[nrl] += NR_END;
    t[nrl] -= ncl;
    
    /* allocate rows and set pointers to them */
    t[nrl][ncl]=(double *) malloc((size_t)((nrow*ncol*ndep+NR_END)*sizeof(double)));
    if (!t[nrl][ncl]) nrerror("allocation failure 3 in d3tensor()");
    t[nrl][ncl] += NR_END;
    t[nrl][ncl] -= ndl;
    
    for(j=ncl+1;j<=nch;j++) t[nrl][j]=t[nrl][j-1]+ndep;
    for(i=nrl+1;i<=nrh;i++) {
        t[i]=t[i-1]+ncol;
        t[i][ncl]=t[i-1][ncl]+ncol*ndep;
        for(j=ncl+1;j<=nch;j++) t[i][j]=t[i][j-1]+ndep;
    }
    
    /* return pointer to array of pointers to rows */
    return t;
}


/* ------------------------------------------------------------------------------ */
void free_d3tensor(double ***t,long nrl,long nrh,long ncl,long nch,long ndl,long ndh)
/* ------------------------------------------------------------------------------ */
/* free a float f3tensor allocated by d3tensor() */
{
    free((FREE_ARG) (t[nrl][ncl]+ndl-NR_END));
    free((FREE_ARG) (t[nrl]+ncl-NR_END));
    free((FREE_ARG) (t+nrl-NR_END));
}
#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

