/* ------------------ */
/* --- nrarith0.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/*
 * History:
 * modif : log2  -> ilog2 (conflict with math.h on Mac OSX)
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrarith0.h"

#undef type_swap
#define type_swap(t)                   \
void short_name(t,,swap)(t * a, t * b) \
{                                      \
    t c;                               \
    c = *a;                            \
    *a = *b;                           \
    *b = c;                            \
}

type_swap(int8_t);
type_swap(int16_t);
type_swap(int32_t);
type_swap(int64_t);
type_swap(float);
type_swap(double);
type_swap(rgb8);
type_swap(rgbx8);

/* --------- */
/* -- Min -- */
/* --------- */

#undef type_min
#define type_min(t)               \
t short_name(t,,min)(t x1, t x2)  \
{                                 \
    return (x1 < x2) ? x1 : x2;   \
}                                 \
t short_name(t,,min2)(t x1, t x2) \
{                                 \
    return (x1 < x2) ? x1 : x2;   \
}                                 \
t short_name(t,,min3)(t x1, t x2, t x3)                          \
{                                                                \
    return short_name(t,,min2)(short_name(t,,min2)(x1, x2), x3); \
}                                                                \
t short_name(t,,min4)(t x1, t x2, t x3, t x4)                                                 \
{                                                                                             \
    return short_name(t,,min2)(short_name(t,,min2)(x1, x2), short_name(t,,min2)(x3, x4));     \
}                                                                                             \
t short_name(t,,min5)(t x1, t x2, t x3, t x4, t x5)                                           \
{                                                                                             \
    return short_name(t,,min3)(short_name(t,,min2)(x1, x2), short_name(t,,min2)(x3, x4), x5); \
}

type_min(float);
type_min(double);
type_min(int8_t);
type_min(uint8_t);
type_min(int16_t);
type_min(uint16_t);
type_min(int32_t);
type_min(uint32_t);

rgb8 rgb8min (rgb8 x1, rgb8 x2)                            {rgb8 y; y.r = ui8min2(x1.r,x2.r);y.g=ui8min2(x1.g,x2.g);y.b=ui8min2(x1.b,x2.b);return y;}
rgb8 rgb8min2(rgb8 x1, rgb8 x2)                            {rgb8 y; y.r = ui8min2(x1.r,x2.r);y.g=ui8min2(x1.g,x2.g);y.b=ui8min2(x1.b,x2.b);return y;}
rgb8 rgb8min3(rgb8 x1, rgb8 x2, rgb8 x3)                   {return rgb8min2(rgb8min2(x1, x2), x3);}
rgb8 rgb8min4(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4)          {return rgb8min2(rgb8min2(x1, x2), rgb8min2(x3,x4));}
rgb8 rgb8min5(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4, rgb8 x5) {return rgb8min3(rgb8min2(x1, x2), rgb8min2(x3,x4), x5);}

/* --------- */
/* -- Max -- */
/* --------- */

#undef type_max
#define type_max(t)               \
t short_name(t,,max)(t x1, t x2)  \
{                                 \
    return (x1 > x2) ? x1 : x2;   \
}                                 \
t short_name(t,,max2)(t x1, t x2) \
{                                 \
    return (x1 > x2) ? x1 : x2;   \
}                                 \
t short_name(t,,max3)(t x1, t x2, t x3)                          \
{                                                                \
    return short_name(t,,max2)(short_name(t,,max2)(x1, x2), x3); \
}                                                                \
t short_name(t,,max4)(t x1, t x2, t x3, t x4)                                                 \
{                                                                                             \
    return short_name(t,,max2)(short_name(t,,max2)(x1, x2), short_name(t,,max2)(x3, x4));     \
}                                                                                             \
t short_name(t,,max5)(t x1, t x2, t x3, t x4, t x5)                                           \
{                                                                                             \
    return short_name(t,,max3)(short_name(t,,max2)(x1, x2), short_name(t,,max2)(x3, x4), x5); \
}

type_max(float);
type_max(double);
type_max(int8_t);
type_max(uint8_t);
type_max(int16_t);
type_max(uint16_t);
type_max(int32_t);
type_max(uint32_t);

ROUTINE(rgb8) rgb8max (rgb8 x1, rgb8 x2)                            {rgb8 y; y.r = ui8max2(x1.r,x2.r);y.g=ui8max2(x1.g,x2.g);y.b=ui8max2(x1.b,x2.b);return y;}
ROUTINE(rgb8) rgb8max2(rgb8 x1, rgb8 x2)                            {rgb8 y; y.r = ui8max2(x1.r,x2.r);y.g=ui8max2(x1.g,x2.g);y.b=ui8max2(x1.b,x2.b);return y;}
ROUTINE(rgb8) rgb8max3(rgb8 x1, rgb8 x2, rgb8 x3)                   {return rgb8max2(rgb8max2(x1, x2), x3);}
ROUTINE(rgb8) rgb8max4(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4)          {return rgb8max2(rgb8max2(x1, x2), rgb8max2(x3,x4));}
ROUTINE(rgb8) rgb8max5(rgb8 x1, rgb8 x2, rgb8 x3, rgb8 x4, rgb8 x5) {return rgb8max3(rgb8max2(x1, x2), rgb8max2(x3,x4), x5);}

/* ----------- */
/* -- Other -- */
/* ----------- */

/* ------------------------------- */
int32_t i32bit(int32_t x, int32_t n)
/* ------------------------------- */
{
    return ((x >> n) & 1);
}

/* --------------------------- */
int32_t sym_int32(int32_t x)
/* --------------------------- */
{
    int32_t y = 0;
    for (int32_t i = 0; i < 31; i++) {
        y = y | (x & 1);
        x = x >> 1;
    }
    y = y | x;
    return y;
}


/* ----------------------- */
int32_t ilog2(int32_t x)
/* ----------------------- */
{
    int32_t s = 0;
    while (x) {
        x >>= 1;
        s++;
    }
    return s - 1;
}

/* ----------------------------- */
int32_t next_power2(int32_t x)
/* ----------------------------- */
{
    int32_t s = ilog2(x);
    int32_t n = 1 << s;

    if (x != n) {
        return n << 1;
    }
    else {
        return n;
    }
}

/* ---------------------------- */
int32_t myGCD(int32_t u, int32_t v)
/* ---------------------------- */
{
    int32_t r;
    while (v != 0) {
        r = u % v;
        u = v;
        v = r;
    }
    return u;
}

/* ---------------------------- */
int32_t myLCM(int32_t u, int32_t v)
/* ---------------------------- */
{
    return (u * v) / myGCD(u, v);
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

