/* ------------------ */
/* --- mca_warp.c --- */
/* ------------------ */

/*
 * Copyright (c) 2016 Lionel Lacassagne, LIP6, UPMC, CNRS
 * Init  : 2016/03/03
 */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <math.h>


#include "nrc_os_config.h"
#include "nrc.h"

#if TARET_OS == GIETVM
#include <user_barrier.h>
#endif

#include "util.h"
#include "ecc_common.h"
#include "palette.h"
#include "bmpNR.h"
#include "mca.h"
#include "str_ext.h"


// ---------------------------------------------------------------
void line0Labeling_Warp(uint8 ** X, int i, int width, uint32 ** E)
// ---------------------------------------------------------------
{
    int j;
    uint8 x;
    uint32 e4;
    uint32 r4;
    
    // prologue
    x = X[i][0];
    if (x) {
        E[i][0] = i * width + 1;
    }
    else {
        E[i][0] = 0;
    }
    
    // boucle et epilogue
    for (j = 1; j <= width - 1; j++) {
        x = X[i][j];
        if (x) {
            e4 = E[i][j-1];
            
            if (e4 == 0) {
                E[i][j] =  i * width + 1;
            }
            else {
                E[i][j] = e4;
            }
        }
        else {
            E[i][j] = 0;
        }
    }
}

