#!/usr/bin/python
# -*- coding: utf-8 -*-

from __future__ import print_function
import os
import sys
import re
import subprocess
import shutil
import filecmp

#images = ['../../images/boulons.pgm', '../../images/cadastre.pgm', '../../images/alea1.pgm', '../../images/alea2.pgm', '../../images/alea3.pgm']
images = ['../../images/alea1.pgm']
config_file = "include/config.h"

use_valgrind = False
infinite_mode = True

threads = [64]
binary = "./appli.elf"
outimages_dir = "output_images"
log_dir = "logs"

configs = [
#        {
#            'SLOW':'1',
#            'FAST':'0',
#            'FEATURES':'0',
#            'PARMERGE':'0'
#        },
#        {
#            'SLOW':'0',
#            'FAST':'1',
#            'FEATURES':'0',
#            'PARMERGE':'0'
#        },
#        {
#            'SLOW':'1',
#            'FAST':'0',
#            'FEATURES':'1',
#            'PARMERGE':'0'
#        },
#        {
#            'SLOW':'0',
#            'FAST':'1',
#            'FEATURES':'1',
#            'PARMERGE':'0'
#        },
        {
            'SLOW':'0',
            'FAST':'1',
            'FEATURES':'1',
            'PARMERGE':'1'
        }
]



def my_mkdir(dirname):
    try:
        print("mkdir %s" % (dirname))
        os.mkdir(dirname)
    except OSError:
        print("*** Error: impossible to create directory %s" % (dirname), file=sys.stderr)
        sys.exit(1)

def my_chdir(dirname):
    print("cd %s" % (dirname));
    os.chdir(dirname)

def my_cp(src, dst):
    print("cp %s %s" % (src, dst))
    shutil.copy(src, dst)

def print_and_call(cmd):
    print(subprocess.list2cmdline(cmd))
    retval = subprocess.call(cmd)
    return retval

def print_and_popen(cmd, outfile):
    print(subprocess.list2cmdline(cmd), end = "")
    print(" >", outfile)
    output = subprocess.Popen(cmd, stdout = subprocess.PIPE, stderr = subprocess.STDOUT).communicate()[0]
    return output




def update_config_file(config):
    if os.path.isfile(config_file):
        print("# Updating file %s" % (config_file))
        f = open(config_file, "r")
        lines = f.readlines()
        f.close()

        f = open(config_file, "w")

        for line in lines:
            line_with_key = False
            for key in config.keys():
                if "#define %s" % (key) in line:
                    f.write("#define %s %s\n" % (key, config[key]))
                    line_with_key = True
                    break
            if not line_with_key:
                f.write(line)

        f.close()
    else:
        print("# Creating file %s" % (config_file))
        f = open(config_file, "w")
        f.write("\n")
        for key in config.keys():
            f.write("#define %s %s\n" % (key, config[key]))
        f.write("\n")
        f.close()


root_dir = os.getcwd()


if not os.path.exists(outimages_dir):
    my_mkdir(outimages_dir)

if not os.path.exists(log_dir):
    my_mkdir(log_dir)


stat_array = {}
finished = False

for config in configs:
    update_config_file(config)
    cmd = ['make']
    print_and_call(cmd)
    for image in images:
        ref_bmpfile = os.path.join(outimages_dir, os.path.splitext(os.path.basename(image))[0] + "_ref.bmp")
        ref_statfile = os.path.join(outimages_dir, os.path.splitext(os.path.basename(image))[0] + "_ref.txt")
        for nthreads in threads:
            while not finished:
                if not os.path.exists(ref_bmpfile):
                    bmpfile = ref_bmpfile
                else:
                    bmpfile = os.path.join(outimages_dir, os.path.splitext(os.path.basename(image))[0] + ".bmp")

                if not os.path.exists(ref_statfile):
                    statfile = ref_statfile
                else:
                    statfile = os.path.join(outimages_dir, os.path.splitext(os.path.basename(image))[0] + ".txt")

                cmd = []
                if use_valgrind:
                    cmd.append('valgrind')

                cmd.extend([binary, '-n', str(nthreads), '-i', image, '-o', bmpfile, '-g'])
                
                if config['FEATURES'] == '1':
                    cmd.append('-d')

                config_keys = config.keys()
                logfile = os.path.join(log_dir, os.path.splitext(os.path.basename(image))[0] + "_" + str(nthreads) + "_" + "_".join(map(lambda x:'%s_%s' % (x, config[x]), config_keys)) + ".txt")
                output = print_and_popen(cmd, logfile)
                
                # Write simulation results to log file
                file = open(logfile, 'w')
                file.write(output)
                file.close()

                if bmpfile != ref_bmpfile:
                    if filecmp.cmp(bmpfile, ref_bmpfile):
                        print("# Files %s and %s are identical" % (bmpfile, ref_bmpfile))
                    else:
                        print("*** Error: files %s and %s differ" % (bmpfile, ref_bmpfile))
                        sys.exit(1)

                if use_valgrind:
                    if not "== ERROR SUMMARY: 0 errors from 0 contexts" in output:
                        print("*** Error: Valgrind error")
                        sys.exit(1)
                    if not "== All heap blocks were freed -- no leaks are possible" in output:
                        print("*** Error: Valgrind detected a memory leak")
                        sys.exit(1)

                if config['FEATURES'] == '1':
                    stat_array = {}
                    in_stats = False
                    outlines = output.splitlines()
                    index = 0
                    for line in outlines:
                        #print("bla i")
                        #print(line)
                        if "[STATS]" in line:
                            in_stats = True
                            continue
                        if "[/STATS]" in line:
                            in_stat = False
                            break
                        if in_stats:
                            tokens = line.split()
                            #print("#len : %d" % len(tokens))
                            #print(tokens[0])
                            assert(len(tokens) == 8)
                            stat_array[index] = {}
                            for j in range(len(tokens)):
                                stat_array[index][j] = tokens[j]
                            index += 1


                    # Dump stat array in stat file
                    file = open(statfile, 'w')
                    for i in range(len(stat_array)):
                        for j in range(8):
                            file.write("%s " % stat_array[i][j])
                        file.write("\n");
                    file.close()

                    # Comparison to reference
                    if statfile != ref_statfile:
                        if filecmp.cmp(statfile, ref_statfile):
                            print("# Feature files %s and %s are identical" % (statfile, ref_statfile))
                        else:
                            print("*** Error: feature files %s and %s differ" % (statfile, ref_statfile))
                            sys.exit(1)

                if not infinite_mode:
                    finished = True
                














