/* ------------------ */
/* --- nralloc1.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef __NRALLOC1_H__
#define __NRALLOC1_H__

#include <stdint.h>

#include "nrc_os_config.h"
#include "nrtype.h"

/*
 * --------------
 * --- vector ---
 * --------------
 */

#define type_vector(t) \
t * short_name(t,,vector)(int32_t nl, int32_t nh)

type_vector(int8_t);
type_vector(uint8_t);
type_vector(int16_t);
type_vector(uint16_t);
type_vector(int32_t);
type_vector(uint32_t);
type_vector(int64_t);
type_vector(uint64_t);
type_vector(float);
type_vector(double);
type_vector(rgb8);
type_vector(rgbx8);
type_vector(rgb32);
type_vector(void_p);



#if TARGET_OS == GIETVM
#define remote_type_vector(t) \
t * short_name(t,remote_,vector)(int32_t nl, int32_t nh, int32_t x, int32_t y)

remote_type_vector(int8_t);
remote_type_vector(uint8_t);
remote_type_vector(int16_t);
remote_type_vector(uint16_t);
remote_type_vector(int32_t);
remote_type_vector(uint32_t);
remote_type_vector(int64_t);
remote_type_vector(uint64_t);
remote_type_vector(float);
remote_type_vector(double);
remote_type_vector(rgb8);
remote_type_vector(rgbx8);
remote_type_vector(rgb32);
remote_type_vector(void_p);

//void ** remote_vvector(long nl, long nh, int x, int y);
#endif

#define type_vector0(t) \
t * short_name(t,,vector0)(int32_t nl, int32_t nh)

type_vector0(int8_t);
type_vector0(uint8_t);
type_vector0(int16_t);
type_vector0(uint16_t);
type_vector0(int32_t);
type_vector0(uint32_t);
type_vector0(int64_t);
type_vector0(uint64_t);
type_vector0(float);
type_vector0(double);
type_vector0(rgb8);
type_vector0(rgbx8);
type_vector0(rgb32);
type_vector0(void_p);

#define realloc_type_vector(t) \
t * short_name(t,realloc_,vector)(t * v, int32_t nl, int32_t nh)

realloc_type_vector(int8_t);
realloc_type_vector(uint8_t);
realloc_type_vector(int16_t);
realloc_type_vector(uint16_t);
realloc_type_vector(int32_t);
realloc_type_vector(uint32_t);
realloc_type_vector(int64_t);
realloc_type_vector(uint64_t);
realloc_type_vector(float);
realloc_type_vector(double);
realloc_type_vector(rgb8);
realloc_type_vector(rgbx8);
realloc_type_vector(rgb32);
realloc_type_vector(void_p);


#define free_type_vector(t) \
void short_name(t,free_,vector)(t * v, long nl, long nh)

free_type_vector(int8_t);
free_type_vector(uint8_t);
free_type_vector(int16_t);
free_type_vector(uint16_t);
free_type_vector(int32_t);
free_type_vector(uint32_t);
free_type_vector(int64_t);
free_type_vector(uint64_t);
free_type_vector(float);
free_type_vector(double);
free_type_vector(rgb8);
free_type_vector(rgbx8);
free_type_vector(rgb32);
free_type_vector(void_p);



/*
void ** vvector(long nl, long nh);
void ** vvector0(long nl, long nh);
void ** realloc_vvector(void ** v, long nl, long nh);
void free_vvector(void ** v, long nl, long nh);
*/

#endif /* __NRALLOC1_H__ */

